/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.VideoSize;
import com.sun.media.ui.VideoSizeControl;
import com.sun.media.util.JMFI18N;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class VideoFormatChooser
extends Panel
implements ItemListener,
ActionListener {
    public static final String ACTION_TRACK_ENABLED = "ACTION_VIDEO_TRACK_ENABLED";
    public static final String ACTION_TRACK_DISABLED = "ACTION_VIDEO_TRACK_DISABLED";
    private VideoFormat formatOld;
    private Format[] arrSupportedFormats = null;
    private float[] customFrameRates = null;
    private Vector vectorContSuppFormats = new Vector();
    private boolean boolDisplayEnableTrack;
    private ActionListener listenerEnableTrack;
    private boolean boolEnableTrackSaved = true;
    private Checkbox checkEnableTrack;
    private Label labelEncoding;
    private Choice comboEncoding;
    private Label labelSize;
    private VideoSizeControl controlSize;
    private Label labelFrameRate;
    private Choice comboFrameRate;
    private Label labelExtra;
    private Choice comboExtra;
    private int nWidthLabel = 0;
    private int nWidthData = 0;
    private static final int MARGINH = 12;
    private static final int MARGINV = 6;
    private static final float[] standardCaptureRates = new float[]{15.0f, 1.0f, 2.0f, 5.0f, 7.5f, 10.0f, 12.5f, 20.0f, 24.0f, 25.0f, 30.0f};
    private static final String DEFAULT_STRING = JMFI18N.getResource("formatchooser.default");

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, float[] frameRates) {
        this(arrFormats, formatDefault, false, null, frameRates);
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault) {
        this(arrFormats, formatDefault, false, null, null);
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, boolean boolDisplayEnableTrack, ActionListener listenerEnableTrack) {
        this(arrFormats, formatDefault, boolDisplayEnableTrack, listenerEnableTrack, null);
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, boolean boolDisplayEnableTrack, ActionListener listenerEnableTrack, boolean capture) {
        this(arrFormats, formatDefault, boolDisplayEnableTrack, listenerEnableTrack, (float[])(capture ? standardCaptureRates : null));
    }

    public VideoFormatChooser(Format[] arrFormats, VideoFormat formatDefault, boolean boolDisplayEnableTrack, ActionListener listenerEnableTrack, float[] frameRates) {
        this.arrSupportedFormats = arrFormats;
        this.boolDisplayEnableTrack = boolDisplayEnableTrack;
        this.listenerEnableTrack = listenerEnableTrack;
        this.customFrameRates = frameRates;
        int nCount = this.arrSupportedFormats.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (this.arrSupportedFormats[i2] instanceof VideoFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i2]);
            }
            ++i2;
        }
        this.formatOld = this.isFormatSupported(formatDefault) ? formatDefault : null;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setEnabled(boolean boolEnable) {
        super.setEnabled(boolEnable);
        if (this.checkEnableTrack != null) {
            this.checkEnableTrack.setEnabled(boolEnable);
        }
        this.enableControls(boolEnable);
    }

    public Format getFormat() {
        VideoFormat formatVideoNew;
        String strYuvType = null;
        VideoFormat formatVideo = null;
        String strEncoding = this.comboEncoding.getSelectedItem();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat) && this.isFormatGoodForVideoSize(formatVideo) && this.isFormatGoodForFrameRate(formatVideo)) {
                YUVFormat formatYUV;
                int nYuvType;
                if (strEncoding.equalsIgnoreCase("rgb") && formatVideo instanceof RGBFormat) {
                    RGBFormat formatRGB = (RGBFormat)formatVideo;
                    Integer integerBitsPerPixel = new Integer(formatRGB.getBitsPerPixel());
                    String strBitsPerPixel = integerBitsPerPixel.toString();
                    if (this.comboExtra.getSelectedItem().equals(strBitsPerPixel)) break;
                } else if (!strEncoding.equalsIgnoreCase("yuv") || !(formatVideo instanceof YUVFormat) || (strYuvType = this.getYuvType(nYuvType = (formatYUV = (YUVFormat)formatVideo).getYuvType())) != null && this.comboExtra.getSelectedItem().equals(strYuvType)) break;
            }
            ++i2;
        }
        if (i2 >= nSize) {
            return null;
        }
        if (formatVideo.getSize() == null) {
            formatVideoNew = new VideoFormat(null, this.controlSize.getVideoSize(), -1, null, -1.0f);
            formatVideo = (VideoFormat)formatVideoNew.intersects(formatVideo);
        }
        if (this.customFrameRates != null && formatVideo != null) {
            formatVideoNew = new VideoFormat(null, null, -1, null, this.getFrameRate());
            formatVideo = (VideoFormat)formatVideoNew.intersects(formatVideo);
        }
        return formatVideo;
    }

    public float getFrameRate() {
        String selection = this.comboFrameRate.getSelectedItem();
        if (selection != null) {
            if (selection.equals(DEFAULT_STRING)) {
                return -1.0f;
            }
            try {
                float fr = Float.valueOf(selection).floatValue();
                return fr;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1.0f;
    }

    public void setCurrentFormat(VideoFormat formatDefault) {
        if (this.isFormatSupported(formatDefault)) {
            this.formatOld = formatDefault;
        }
        this.updateFields(this.formatOld);
    }

    public void setFrameRate(float frameRate) {
        int i2 = 0;
        while (i2 < this.comboFrameRate.getItemCount()) {
            float value = Float.valueOf(this.comboFrameRate.getItem(i2)).floatValue();
            if ((double)Math.abs(frameRate - value) < 0.5) {
                this.comboFrameRate.select(i2);
                return;
            }
            ++i2;
        }
    }

    public void setSupportedFormats(Format[] arrFormats, VideoFormat formatDefault) {
        this.arrSupportedFormats = arrFormats;
        this.vectorContSuppFormats.removeAllElements();
        int nCount = this.arrSupportedFormats.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (this.arrSupportedFormats[i2] instanceof VideoFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i2]);
            }
            ++i2;
        }
        this.formatOld = this.isFormatSupported(formatDefault) ? formatDefault : null;
        this.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void setSupportedFormats(Vector vectorContSuppFormats) {
        this.vectorContSuppFormats = vectorContSuppFormats;
        if (vectorContSuppFormats.isEmpty()) {
            this.checkEnableTrack.setState(false);
            this.checkEnableTrack.setEnabled(false);
            this.onEnableTrack(true);
            return;
        }
        this.checkEnableTrack.setEnabled(true);
        this.checkEnableTrack.setState(this.boolEnableTrackSaved);
        this.onEnableTrack(true);
        if (!this.isFormatSupported(this.formatOld)) {
            this.formatOld = null;
        }
        this.updateFields(this.formatOld);
    }

    public void setTrackEnabled(boolean boolEnable) {
        this.boolEnableTrackSaved = boolEnable;
        if (this.checkEnableTrack == null) {
            return;
        }
        this.checkEnableTrack.setState(boolEnable);
        this.onEnableTrack(true);
    }

    public boolean isTrackEnabled() {
        boolean boolEnabled = this.checkEnableTrack.getState();
        return boolEnabled;
    }

    public Dimension getPreferredSize() {
        Dimension dimControl;
        Dimension dim = new Dimension();
        if (this.boolDisplayEnableTrack) {
            dimControl = this.checkEnableTrack.getPreferredSize();
            dim.width = Math.max(dim.width, dimControl.width);
            dim.height += dimControl.height + 6;
        }
        Dimension dimLabel = this.labelEncoding.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimLabel.width);
        dimControl = this.comboEncoding.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimControl.width);
        dim.height += Math.max(dimLabel.height, dimControl.height) + 6;
        dimLabel = this.labelSize.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimLabel.width);
        dimControl = this.controlSize.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimControl.width);
        dim.height += Math.max(dimLabel.height, dimControl.height) + 6;
        dimLabel = this.labelFrameRate.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimLabel.width);
        dimControl = this.comboFrameRate.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimControl.width);
        dim.height += Math.max(dimLabel.height, dimControl.height) + 6;
        dimLabel = this.labelExtra.getPreferredSize();
        this.nWidthLabel = Math.max(this.nWidthLabel, dimLabel.width);
        dimControl = this.comboExtra.getPreferredSize();
        this.nWidthData = Math.max(this.nWidthData, dimControl.width);
        dim.height += Math.max(dimLabel.height, dimControl.height);
        dim.width = Math.max(dim.width, this.nWidthLabel + 12 + this.nWidthData);
        return dim;
    }

    public void doLayout() {
        Dimension dimControl;
        this.getPreferredSize();
        int nOffsetY = 0;
        int nLabelOffsetX = 0;
        int nDataOffsetX = this.nWidthLabel + 12;
        Dimension dimThis = this.getSize();
        if (this.boolDisplayEnableTrack) {
            dimControl = this.checkEnableTrack.getPreferredSize();
            this.checkEnableTrack.setBounds(nLabelOffsetX, nOffsetY, dimControl.width, dimControl.height);
            nOffsetY += dimControl.height + 6;
        }
        Dimension dimLabel = this.labelEncoding.getPreferredSize();
        dimControl = this.comboEncoding.getPreferredSize();
        this.labelEncoding.setBounds(nLabelOffsetX, nOffsetY, this.nWidthLabel, dimLabel.height);
        this.comboEncoding.setBounds(nDataOffsetX, nOffsetY, dimThis.width - nDataOffsetX, dimControl.height);
        dimLabel = this.labelSize.getPreferredSize();
        dimControl = this.controlSize.getPreferredSize();
        this.labelSize.setBounds(nLabelOffsetX, nOffsetY += Math.max(dimLabel.height, dimControl.height) + 6, this.nWidthLabel, dimLabel.height);
        this.controlSize.setBounds(nDataOffsetX, nOffsetY, dimThis.width - nDataOffsetX, dimControl.height);
        dimLabel = this.labelFrameRate.getPreferredSize();
        dimControl = this.comboFrameRate.getPreferredSize();
        this.labelFrameRate.setBounds(nLabelOffsetX, nOffsetY += Math.max(dimLabel.height, dimControl.height) + 6, this.nWidthLabel, dimLabel.height);
        this.comboFrameRate.setBounds(nDataOffsetX, nOffsetY, dimThis.width - nDataOffsetX, dimControl.height);
        dimLabel = this.labelExtra.getPreferredSize();
        dimControl = this.comboExtra.getPreferredSize();
        this.labelExtra.setBounds(nLabelOffsetX, nOffsetY += Math.max(dimLabel.height, dimControl.height) + 6, this.nWidthLabel, dimLabel.height);
        this.comboExtra.setBounds(nDataOffsetX, nOffsetY, dimThis.width - nDataOffsetX, dimControl.height);
        int n2 = nOffsetY + (Math.max(dimLabel.height, dimControl.height) + 6);
    }

    private void init() throws Exception {
        this.setLayout(null);
        this.checkEnableTrack = new Checkbox(JMFI18N.getResource("formatchooser.enabletrack"), true);
        this.checkEnableTrack.addItemListener(this);
        if (this.boolDisplayEnableTrack) {
            this.add(this.checkEnableTrack);
        }
        this.labelEncoding = new Label(JMFI18N.getResource("formatchooser.encoding"), 2);
        this.add(this.labelEncoding);
        this.comboEncoding = new Choice();
        this.comboEncoding.addItemListener(this);
        this.add(this.comboEncoding);
        this.labelSize = new Label(JMFI18N.getResource("formatchooser.videosize"), 2);
        this.add(this.labelSize);
        if (this.formatOld == null) {
            this.controlSize = new VideoSizeControl();
        } else {
            VideoSize sizeVideo = new VideoSize(this.formatOld.getSize());
            this.controlSize = new VideoSizeControl(sizeVideo);
        }
        this.controlSize.addActionListener(this);
        this.add(this.controlSize);
        this.labelFrameRate = new Label(JMFI18N.getResource("formatchooser.framerate"), 2);
        this.add(this.labelFrameRate);
        this.comboFrameRate = new Choice();
        this.comboFrameRate.addItemListener(this);
        this.add(this.comboFrameRate);
        this.labelExtra = new Label("Extra:", 2);
        this.labelExtra.setVisible(false);
        this.add(this.labelExtra);
        this.comboExtra = new Choice();
        this.comboExtra.setVisible(false);
        this.add(this.comboExtra);
        this.updateFields(this.formatOld);
    }

    private void updateFields(VideoFormat formatDefault) {
        String strEncoding;
        String strEncodingPref = null;
        Vector<String> vectorEncoding = new Vector<String>();
        boolean boolEnable = this.comboEncoding.isEnabled();
        this.comboEncoding.setEnabled(false);
        this.comboEncoding.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat) {
                VideoFormat formatVideo = (VideoFormat)objectFormat;
                strEncoding = formatVideo.getEncoding().toUpperCase();
                if (strEncodingPref == null) {
                    strEncodingPref = strEncoding;
                }
                if (!vectorEncoding.contains(strEncoding)) {
                    this.comboEncoding.addItem(strEncoding);
                    vectorEncoding.addElement(strEncoding);
                }
            }
            ++i2;
        }
        if (formatDefault != null) {
            strEncoding = formatDefault.getEncoding().toUpperCase();
            this.comboEncoding.select(strEncoding);
        } else if (strEncodingPref != null) {
            this.comboEncoding.select(strEncodingPref);
        } else if (this.comboEncoding.getItemCount() > 0) {
            this.comboEncoding.select(0);
        }
        this.updateFieldsFromEncoding(formatDefault);
        this.comboEncoding.setEnabled(boolEnable);
    }

    private void updateFieldsFromEncoding(VideoFormat formatDefault) {
        VideoSize sizeVideo;
        Dimension formatVideoSize;
        VideoSize sizeVideoPref = null;
        boolean boolVideoSizePref = false;
        boolean boolEnable = this.controlSize.isEnabled();
        this.controlSize.setEnabled(false);
        this.controlSize.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            VideoFormat formatVideo;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat)) {
                formatVideoSize = formatVideo.getSize();
                sizeVideo = formatVideoSize == null ? null : new VideoSize(formatVideoSize);
                if (!boolVideoSizePref) {
                    boolVideoSizePref = true;
                    sizeVideoPref = sizeVideo;
                }
                this.controlSize.addItem(sizeVideo);
            }
            ++i2;
        }
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault)) {
            formatVideoSize = formatDefault.getSize();
            sizeVideo = formatVideoSize == null ? null : new VideoSize(formatVideoSize);
            this.controlSize.select(sizeVideo);
        } else if (boolVideoSizePref) {
            this.controlSize.select(sizeVideoPref);
        } else if (this.controlSize.getItemCount() > 0) {
            this.controlSize.select(0);
        }
        this.updateFieldsFromSize(formatDefault);
        this.controlSize.setEnabled(boolEnable);
    }

    private void updateFieldsFromSize(VideoFormat formatDefault) {
        Float floatFrameRate;
        int i2;
        Float floatFrameRatePref = null;
        Vector<Float> vectorRates = new Vector<Float>();
        boolean boolEnable = this.comboFrameRate.isEnabled();
        this.comboFrameRate.setEnabled(false);
        if (this.customFrameRates == null) {
            this.comboFrameRate.removeAll();
        } else if (this.comboFrameRate.getItemCount() < 1) {
            i2 = 0;
            while (i2 < this.customFrameRates.length) {
                this.comboFrameRate.addItem(Float.toString(this.customFrameRates[i2]));
                ++i2;
            }
        }
        int nSize = this.vectorContSuppFormats.size();
        i2 = 0;
        while (i2 < nSize) {
            VideoFormat formatVideo;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat) && this.isFormatGoodForVideoSize(formatVideo) && this.customFrameRates == null) {
                floatFrameRate = new Float(formatVideo.getFrameRate());
                if (floatFrameRatePref == null) {
                    floatFrameRatePref = floatFrameRate;
                }
                if (!vectorRates.contains(floatFrameRate)) {
                    if (floatFrameRate.floatValue() == -1.0f) {
                        this.comboFrameRate.addItem(DEFAULT_STRING);
                    } else {
                        this.comboFrameRate.addItem(floatFrameRate.toString());
                    }
                    vectorRates.addElement(floatFrameRate);
                }
            }
            ++i2;
        }
        if (formatDefault != null && this.customFrameRates == null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForVideoSize(formatDefault)) {
            floatFrameRate = new Float(formatDefault.getFrameRate());
            if (floatFrameRate.floatValue() == -1.0f) {
                this.comboFrameRate.select(DEFAULT_STRING);
            } else {
                this.comboFrameRate.select(floatFrameRate.toString());
            }
        } else if (floatFrameRatePref != null) {
            if (floatFrameRatePref.floatValue() == -1.0f) {
                this.comboFrameRate.select(DEFAULT_STRING);
            } else {
                this.comboFrameRate.select(floatFrameRatePref.toString());
            }
        } else if (this.comboFrameRate.getItemCount() > 0) {
            this.comboFrameRate.select(0);
        }
        this.updateFieldsFromRate(formatDefault);
        this.comboFrameRate.setEnabled(boolEnable);
    }

    private void updateFieldsFromRate(VideoFormat formatDefault) {
        YUVFormat formatYUV;
        int nYuvType;
        Integer integerBitsPerPixel;
        RGBFormat formatRGB;
        String strYuvType = null;
        Vector<Object> vectorExtra = new Vector<Object>();
        boolean boolRGB = false;
        boolean boolYUV = false;
        String strEncoding = this.comboEncoding.getSelectedItem();
        if (strEncoding == null) {
            return;
        }
        if (strEncoding.equalsIgnoreCase("rgb")) {
            this.labelExtra.setText(JMFI18N.getResource("formatchooser.bitsperpixel"));
            this.labelExtra.setVisible(true);
            this.comboExtra.setVisible(true);
            boolRGB = true;
        } else if (strEncoding.equalsIgnoreCase("yuv")) {
            this.labelExtra.setText(JMFI18N.getResource("formatchooser.yuvtype"));
            this.labelExtra.setVisible(true);
            this.comboExtra.setVisible(true);
            boolYUV = true;
        } else {
            this.labelExtra.setVisible(false);
            this.comboExtra.setVisible(false);
            return;
        }
        boolean boolEnable = this.comboExtra.isEnabled();
        this.comboExtra.setEnabled(false);
        this.comboExtra.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            VideoFormat formatVideo;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat && this.isFormatGoodForEncoding(formatVideo = (VideoFormat)objectFormat) && this.isFormatGoodForVideoSize(formatVideo) && this.isFormatGoodForFrameRate(formatVideo)) {
                if (boolRGB && formatVideo instanceof RGBFormat) {
                    formatRGB = (RGBFormat)formatVideo;
                    integerBitsPerPixel = new Integer(formatRGB.getBitsPerPixel());
                    if (!vectorExtra.contains(integerBitsPerPixel)) {
                        this.comboExtra.addItem(integerBitsPerPixel.toString());
                        vectorExtra.addElement(integerBitsPerPixel);
                    }
                } else if (boolYUV && formatVideo instanceof YUVFormat && (strYuvType = this.getYuvType(nYuvType = (formatYUV = (YUVFormat)formatVideo).getYuvType())) != null && !vectorExtra.contains(strYuvType)) {
                    this.comboExtra.addItem(strYuvType);
                    vectorExtra.addElement(strYuvType);
                }
            }
            ++i2;
        }
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForVideoSize(formatDefault) && this.isFormatGoodForFrameRate(formatDefault)) {
            if (boolRGB && formatDefault instanceof RGBFormat) {
                formatRGB = (RGBFormat)formatDefault;
                integerBitsPerPixel = new Integer(formatRGB.getBitsPerPixel());
                this.comboExtra.select(integerBitsPerPixel.toString());
            } else if (boolYUV && formatDefault instanceof YUVFormat) {
                formatYUV = (YUVFormat)formatDefault;
                nYuvType = formatYUV.getYuvType();
                strYuvType = this.getYuvType(nYuvType);
                if (strYuvType != null) {
                    this.comboExtra.select(strYuvType);
                }
            } else if (this.comboExtra.getItemCount() > 0) {
                this.comboExtra.select(0);
            }
        } else if (this.comboExtra.getItemCount() > 0) {
            this.comboExtra.select(0);
        }
        this.comboExtra.setEnabled(boolEnable);
    }

    private boolean isFormatGoodForEncoding(VideoFormat format) {
        boolean boolResult = false;
        String strEncoding = this.comboEncoding.getSelectedItem();
        if (strEncoding != null) {
            boolResult = format.getEncoding().equalsIgnoreCase(strEncoding);
        }
        return boolResult;
    }

    private boolean isFormatGoodForVideoSize(VideoFormat format) {
        boolean boolResult = false;
        VideoSize sizeVideo = this.controlSize.getVideoSize();
        Dimension formatVideoSize = format.getSize();
        boolResult = formatVideoSize == null ? true : sizeVideo.equals(formatVideoSize);
        return boolResult;
    }

    private boolean isFormatGoodForFrameRate(VideoFormat format) {
        boolean boolResult = false;
        if (this.customFrameRates != null) {
            return true;
        }
        String strFrameRate = this.comboFrameRate.getSelectedItem();
        if (strFrameRate.equals(DEFAULT_STRING)) {
            return true;
        }
        float fFrameRate2 = format.getFrameRate();
        if (fFrameRate2 == -1.0f) {
            return true;
        }
        if (strFrameRate != null) {
            float fFrameRate1 = Float.valueOf(strFrameRate).floatValue();
            boolResult = fFrameRate1 == fFrameRate2;
        }
        return boolResult;
    }

    private boolean isFormatSupported(VideoFormat format) {
        boolean boolSupported = false;
        if (format == null) {
            return boolSupported;
        }
        int nCount = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nCount && !boolSupported) {
            VideoFormat formatVideo = (VideoFormat)this.vectorContSuppFormats.elementAt(i2);
            if (formatVideo.matches(format)) {
                boolSupported = true;
            }
            ++i2;
        }
        return boolSupported;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("Size Changed")) {
            this.updateFieldsFromSize(this.formatOld);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.checkEnableTrack) {
            this.boolEnableTrackSaved = this.checkEnableTrack.getState();
            this.onEnableTrack(true);
        } else if (objectSource == this.comboEncoding) {
            this.updateFieldsFromEncoding(this.formatOld);
        } else if (objectSource == this.controlSize) {
            this.updateFieldsFromSize(this.formatOld);
        } else if (objectSource == this.comboFrameRate) {
            this.updateFieldsFromRate(this.formatOld);
        }
    }

    private void onEnableTrack(boolean notifyListener) {
        boolean boolEnable = this.checkEnableTrack.getState();
        this.enableControls(boolEnable && this.isEnabled());
        if (notifyListener && this.listenerEnableTrack != null) {
            ActionEvent event = boolEnable ? new ActionEvent(this, 1001, ACTION_TRACK_ENABLED) : new ActionEvent(this, 1001, ACTION_TRACK_DISABLED);
            this.listenerEnableTrack.actionPerformed(event);
        }
    }

    private void enableControls(boolean boolEnable) {
        this.labelEncoding.setEnabled(boolEnable);
        this.comboEncoding.setEnabled(boolEnable);
        this.labelSize.setEnabled(boolEnable);
        this.controlSize.setEnabled(boolEnable);
        this.labelFrameRate.setEnabled(boolEnable);
        this.comboFrameRate.setEnabled(boolEnable);
        this.labelExtra.setEnabled(boolEnable);
        this.comboExtra.setEnabled(boolEnable);
    }

    private String getYuvType(int nType) {
        String strType = null;
        strType = (nType & 2) == 2 ? JMFI18N.getResource("formatchooser.yuv.4:2:0") : ((nType & 4) == 4 ? JMFI18N.getResource("formatchooser.yuv.4:2:2") : ((nType & 0x20) == 32 ? JMFI18N.getResource("formatchooser.yuv.YUYV") : ((nType & 8) == 8 ? JMFI18N.getResource("formatchooser.yuv.1:1:1") : ((nType & 1) == 1 ? JMFI18N.getResource("formatchooser.yuv.4:1:1") : ((nType & 0x10) == 16 ? JMFI18N.getResource("formatchooser.yuv.YVU9") : null)))));
        return strType;
    }
}

