/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.renderer.video.BasicVideoRenderer;
import com.sun.media.renderer.video.Blitter;
import com.sun.media.util.Arch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class AWTRenderer
extends BasicVideoRenderer
implements Blitter {
    private static final String MyName = "AWT Renderer";
    private transient Vector cacheInputData = null;
    private transient Vector cacheInputImage = null;
    private transient Vector cacheOutputImage = null;
    private transient Image lastImage = null;
    private RGBFormat supportedRGB = null;
    private RGBFormat supportedOther = null;
    private transient int lastWidth = 1;
    private transient int lastHeight = 1;
    private Blitter blitter = null;
    public static String vendor = null;
    public static boolean runningOnMac = false;

    public AWTRenderer() {
        this(MyName);
    }

    public AWTRenderer(String name) {
        super(name);
        int bMask;
        int gMask;
        int rMask;
        if ((Arch.getArch() & 8) != 0 && !runningOnMac) {
            rMask = 255;
            gMask = 65280;
            bMask = 0xFF0000;
        } else {
            bMask = 255;
            gMask = 65280;
            rMask = 0xFF0000;
        }
        this.supportedRGB = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, rMask, gMask, bMask, 1, -1, 0, -1);
        this.supportedOther = new RGBFormat(null, -1, Format.intArray, -1.0f, 32, bMask, gMask, rMask, 1, -1, 0, -1);
        this.supportedFormats = new VideoFormat[2];
        this.supportedFormats[0] = this.supportedRGB;
        this.supportedFormats[1] = this.supportedOther;
        if (runningOnMac) {
            this.supportedFormats[1] = this.supportedRGB;
        }
        try {
            Class<?> cls = Class.forName("com.sun.media.renderer.video.Java2DRenderer");
            this.blitter = (Blitter)cls.newInstance();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.blitter = this;
        }
    }

    public boolean isLightWeight() {
        return false;
    }

    public void open() throws ResourceUnavailableException {
        this.cacheInputData = new Vector();
        this.cacheInputImage = new Vector();
        this.cacheOutputImage = new Vector();
    }

    public synchronized void reset() {
        this.cacheInputData = new Vector();
        this.cacheInputImage = new Vector();
        this.cacheOutputImage = new Vector();
    }

    public Format setInputFormat(Format format) {
        if (super.setInputFormat(format) != null) {
            this.reset();
            return format;
        }
        return null;
    }

    protected synchronized int doProcess(Buffer buffer) {
        Object data;
        if (this.component == null) {
            return 0;
        }
        if (!buffer.getFormat().equals(this.inputFormat)) {
            Format in = buffer.getFormat();
            if (BasicPlugIn.matches(in, this.supportedFormats) == null) {
                return 1;
            }
            this.inputFormat = (RGBFormat)in;
        }
        if (!((data = buffer.getData()) instanceof int[])) {
            return 1;
        }
        int cacheSize = this.cacheInputData.size();
        boolean found = false;
        int i2 = 0;
        while (i2 < cacheSize) {
            Object bufKnown = this.cacheInputData.elementAt(i2);
            if (bufKnown == data) {
                found = true;
                break;
            }
            ++i2;
        }
        if (!found) {
            i2 = this.blitter.newData(buffer, this.cacheInputImage, this.cacheOutputImage, this.cacheInputData);
        }
        if (i2 < 0) {
            return 1;
        }
        RGBFormat format = (RGBFormat)buffer.getFormat();
        Dimension size = format.getSize();
        this.inWidth = size.width;
        this.inHeight = size.height;
        if (this.outWidth == -1) {
            this.outWidth = size.width;
        }
        if (this.outHeight == -1) {
            this.outHeight = size.height;
        }
        this.lastImage = this.blitter.process(buffer, this.cacheInputImage.elementAt(i2), this.cacheOutputImage.elementAt(i2), size);
        this.lastWidth = size.width;
        this.lastHeight = size.height;
        if (!this.isLightWeight()) {
            Graphics g2 = this.component.getGraphics();
            if (g2 != null) {
                this.blitter.draw(g2, this.component, this.lastImage, 0, 0, this.outWidth, this.outHeight, 0, 0, size.width, size.height);
            }
        } else {
            this.component.repaint();
        }
        return 0;
    }

    protected void repaint() {
        if (!this.isStarted() && this.lastImage != null) {
            Graphics g2 = this.component.getGraphics();
            this.blitter.draw(g2, this.component, this.lastImage, 0, 0, this.outWidth, this.outHeight, 0, 0, this.lastWidth, this.lastHeight);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            if (this.isLightWeight()) {
                this.component = new LightComponent();
                this.component.setBackground(this.getPreferredBackground());
                if (this.compListener == null) {
                    this.compListener = new BasicVideoRenderer.CompListener();
                }
                this.component.addComponentListener(this.compListener);
            } else {
                this.component = super.getComponent();
            }
        }
        return this.component;
    }

    public synchronized void resized(Component c2) {
        super.resized(c2);
        if (this.blitter != this) {
            this.blitter.resized(c2);
        }
    }

    public Image process(Buffer buffer, Object cacheInputImage, Object cacheOutputImage, Dimension size) {
        MemoryImageSource sourceImage = (MemoryImageSource)cacheInputImage;
        Image lastImage = (Image)cacheOutputImage;
        sourceImage.newPixels(0, 0, size.width, size.height);
        return lastImage;
    }

    public void draw(Graphics g2, Component component, Image lastImage, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh) {
        if (g2 != null) {
            g2.drawImage(lastImage, dx, dy, dw, dh, sx, sy, sw, sh, component);
        }
    }

    public void paint(Graphics g2) {
        if (g2 != null && this.lastImage != null) {
            this.blitter.draw(g2, this.component, this.lastImage, 0, 0, this.outWidth, this.outHeight, 0, 0, this.lastWidth, this.lastHeight);
        }
    }

    public int newData(Buffer buffer, Vector cacheInputImage, Vector cacheOutputImage, Vector cacheInputData) {
        Object data = buffer.getData();
        if (!(data instanceof int[])) {
            return -1;
        }
        RGBFormat format = (RGBFormat)buffer.getFormat();
        DirectColorModel dcm = new DirectColorModel(format.getBitsPerPixel(), format.getRedMask(), format.getGreenMask(), format.getBlueMask());
        MemoryImageSource sourceImage = new MemoryImageSource(format.getLineStride(), format.getSize().height, (ColorModel)dcm, (int[])data, 0, format.getLineStride());
        sourceImage.setAnimated(true);
        sourceImage.setFullBufferUpdates(true);
        Image destImage = null;
        if (this.component != null) {
            destImage = this.component.createImage(sourceImage);
            this.component.prepareImage(destImage, this.component);
        }
        cacheOutputImage.addElement(destImage);
        cacheInputData.addElement(data);
        cacheInputImage.addElement(sourceImage);
        return cacheInputImage.size() - 1;
    }

    static {
        try {
            vendor = System.getProperty("java.vendor");
            if (vendor != null && (vendor = vendor.toUpperCase()).startsWith("APPLE")) {
                runningOnMac = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class LightComponent
    extends Component {
        public synchronized void paint(Graphics g2) {
            AWTRenderer.this.paint(g2);
        }

        public synchronized void update(Graphics g2) {
        }

        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }

        public Dimension getPreferredSize() {
            return AWTRenderer.this.myPreferredSize();
        }

        public synchronized void addNotify() {
            super.addNotify();
            AWTRenderer.this.setAvailable(true);
        }

        public synchronized void removeNotify() {
            AWTRenderer.this.setAvailable(false);
            super.removeNotify();
        }
    }
}

