/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.ExclusiveUse;
import com.sun.media.JMFSecurityManager;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.JavaSoundOutput;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.Owned;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaSoundRenderer
extends AudioRenderer
implements ExclusiveUse {
    static String NAME = "JavaSound Renderer";
    Codec ulawDecoder;
    Format ulawOutputFormat;
    Format ulawFormat;
    Format linearFormat;
    static int METERHEIGHT = 4;
    static boolean available = false;
    Buffer decodeBuffer = null;

    public JavaSoundRenderer() {
        if (!available) {
            throw new UnsatisfiedLinkError("No JavaSound library");
        }
        this.ulawFormat = new AudioFormat("ULAW");
        this.linearFormat = new AudioFormat("LINEAR");
        this.supportedFormats = new Format[2];
        this.supportedFormats[0] = this.linearFormat;
        this.supportedFormats[1] = this.ulawFormat;
        this.gainControl = new GCA(this);
        this.peakVolumeMeter = new PeakVolumeMeter(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null) {
            if (!this.initDevice(this.inputFormat)) {
                throw new ResourceUnavailableException("Cannot intialize audio device for playback");
            }
            this.device.pause();
        }
    }

    public boolean isExclusive() {
        return false;
    }

    protected boolean initDevice(AudioFormat in) {
        Format newInput = in;
        if (this.ulawDecoder != null) {
            this.ulawDecoder.close();
            this.ulawDecoder = null;
        }
        Format[] outs = new Format[1];
        if (this.ulawFormat.matches(in)) {
            this.ulawDecoder = SimpleGraphBuilder.findCodec(in, this.linearFormat, null, outs);
            if (this.ulawDecoder != null) {
                newInput = outs[0];
                this.ulawOutputFormat = newInput;
            } else {
                return false;
            }
        }
        this.devFormat = in;
        return super.initDevice((AudioFormat)newInput);
    }

    protected AudioOutput createDevice(AudioFormat format) {
        return new JavaSoundOutput();
    }

    public int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        if (this.ulawDecoder == null) {
            try {
                ((PeakVolumeMeter)this.peakVolumeMeter).processData(buffer);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return super.doProcessData(buffer);
        }
        if (this.decodeBuffer == null) {
            this.decodeBuffer = new Buffer();
            this.decodeBuffer.setFormat(this.ulawOutputFormat);
        }
        this.decodeBuffer.setLength(0);
        this.decodeBuffer.setOffset(0);
        this.decodeBuffer.setFlags(buffer.getFlags());
        this.decodeBuffer.setTimeStamp(buffer.getTimeStamp());
        this.decodeBuffer.setSequenceNumber(buffer.getSequenceNumber());
        int rc = this.ulawDecoder.process(buffer, this.decodeBuffer);
        if (rc == 0) {
            try {
                ((PeakVolumeMeter)this.peakVolumeMeter).processData(this.decodeBuffer);
            }
            catch (Throwable t) {
                System.err.println(t);
            }
            return super.doProcessData(this.decodeBuffer);
        }
        return 1;
    }

    public Object[] getControls() {
        Object[] c2 = new Control[]{this.gainControl, this.bufferControl, this.peakVolumeMeter};
        return c2;
    }

    static {
        String javaVersion = null;
        String subver = null;
        try {
            javaVersion = System.getProperty("java.version");
            int len = javaVersion.length() < 3 ? javaVersion.length() : 3;
            subver = javaVersion.substring(0, len);
        }
        catch (Throwable t) {
            javaVersion = null;
            subver = null;
        }
        if (subver == null || subver.compareTo("1.3") < 0) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                JMFSecurityManager.loadLibrary("jsound");
                available = true;
            }
            catch (Throwable throwable) {}
        } else {
            available = true;
        }
    }

    class PeakVolumeMeter
    implements Control,
    Owned {
        int averagePeak = 0;
        int lastPeak = 0;
        Panel component = null;
        Checkbox cbEnabled = null;
        Canvas canvas = null;
        AudioRenderer renderer;
        long lastResetTime;
        Graphics cGraphics = null;

        public PeakVolumeMeter(AudioRenderer r) {
            this.renderer = r;
            this.lastResetTime = System.currentTimeMillis();
        }

        public Object getOwner() {
            return this.renderer;
        }

        public Component getControlComponent() {
            if (this.component == null) {
                this.canvas = new Canvas(this){
                    private final /* synthetic */ PeakVolumeMeter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(102, METERHEIGHT);
                    }
                };
                this.cbEnabled = new Checkbox("Peak Volume Meter", false);
                this.component = new Panel();
                this.component.add(this.cbEnabled);
                this.component.add(this.canvas);
                this.canvas.setBackground(Color.black);
            }
            return this.component;
        }

        public void processData(Buffer buf) {
            boolean signed;
            AudioFormat af = (AudioFormat)buf.getFormat();
            int index = 0;
            int peak = 0;
            int inc = 2;
            if (this.component == null) {
                return;
            }
            if (!this.cbEnabled.getState()) {
                return;
            }
            byte[] data = (byte[])buf.getData();
            if (buf.isDiscard()) {
                return;
            }
            if (buf.getLength() <= 0) {
                return;
            }
            if (af.getEndian() == 0) {
                index = 1;
            }
            boolean bl = signed = af.getSigned() == 1;
            if (af.getSampleSizeInBits() == 8) {
                inc = 1;
            }
            if (signed) {
                int i2 = index;
                while (i2 < buf.getLength()) {
                    int d2 = data[i2];
                    if (d2 < 0) {
                        d2 = -d2;
                    }
                    if (d2 > peak) {
                        peak = d2;
                    }
                    i2 += inc * 5;
                }
                peak = peak * 100 / 127;
            } else {
                int i3 = index;
                while (i3 < buf.getLength()) {
                    if ((data[i3] & 0xFF) > peak) {
                        peak = data[i3] & 0xFF;
                    }
                    i3 += inc * 5;
                }
                peak = peak * 100 / 255;
            }
            this.averagePeak = (peak + this.averagePeak) / 2;
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.lastResetTime + 100L) {
                this.lastResetTime = currentTime;
                this.updatePeak(this.averagePeak);
                this.averagePeak = peak;
            }
        }

        private void updatePeak(int newPeak) {
            if (this.canvas == null) {
                return;
            }
            if (this.cGraphics == null) {
                this.cGraphics = this.canvas.getGraphics();
            }
            if (this.cGraphics == null) {
                return;
            }
            if (newPeak > 99) {
                newPeak = 99;
            }
            this.cGraphics.setColor(Color.green);
            if (newPeak < 80) {
                this.cGraphics.drawLine(1, 1, newPeak + 1, 1);
                this.cGraphics.drawLine(1, 2, newPeak + 1, 2);
            } else {
                this.cGraphics.drawLine(1, 1, 81, 1);
                this.cGraphics.drawLine(1, 2, 81, 2);
                this.cGraphics.setColor(Color.yellow);
                if (newPeak < 90) {
                    this.cGraphics.drawLine(81, 1, newPeak + 1, 1);
                    this.cGraphics.drawLine(81, 2, newPeak + 1, 2);
                } else {
                    this.cGraphics.drawLine(81, 1, 91, 1);
                    this.cGraphics.drawLine(81, 2, 91, 2);
                    this.cGraphics.setColor(Color.red);
                    this.cGraphics.drawLine(91, 1, newPeak + 1, 1);
                    this.cGraphics.drawLine(91, 2, newPeak + 1, 2);
                }
            }
            this.cGraphics.setColor(Color.black);
            this.cGraphics.drawLine(newPeak + 2, 1, 102, 1);
            this.cGraphics.drawLine(newPeak + 2, 2, 102, 2);
            this.lastPeak = newPeak;
        }
    }

    class GCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected GCA(AudioRenderer r) {
            super(false);
            this.renderer = r;
        }

        public void setMute(boolean mute) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(mute);
            }
            super.setMute(mute);
        }

        public float setLevel(float g2) {
            float level = super.setLevel(g2);
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(this.getDB());
            }
            return level;
        }
    }
}

