/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.annotation.Platform;
import com.googlecode.javacpp.annotation.Properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    private static String platformName = null;
    private static java.util.Properties platformProperties = null;
    static File tempDir = null;
    static boolean loadLibraries = true;
    static Map<String, String> loadedLibraries = Collections.synchronizedMap(new HashMap());
    static WeakHashMap<Class<? extends Pointer>, HashMap<String, Integer>> memberOffsets;

    public static String getPlatformName() {
        if (platformName != null) {
            return platformName;
        }
        String jvmName = System.getProperty("java.vm.name").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (osName.startsWith("mac os x")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        platformName = osName + "-" + osArch;
        return platformName;
    }

    public static void setPlatformName(String platformName) {
        Loader.platformName = platformName;
        platformProperties = null;
    }

    public static java.util.Properties getProperties() {
        if (platformProperties != null) {
            return platformProperties;
        }
        platformProperties = Loader.getProperties(Loader.getPlatformName());
        return platformProperties;
    }

    public static java.util.Properties getProperties(String name) {
        java.util.Properties p = new java.util.Properties();
        p.put("platform.name", name);
        name = "properties/" + name + ".properties";
        InputStream is = Loader.class.getResourceAsStream(name);
        try {
            try {
                p.load(new InputStreamReader(is));
            }
            catch (NoSuchMethodError e2) {
                p.load(is);
            }
        }
        catch (Exception e3) {
            name = "properties/generic.properties";
            is = Loader.class.getResourceAsStream(name);
            try {
                try {
                    p.load(new InputStreamReader(is));
                }
                catch (NoSuchMethodError e2) {
                    p.load(is);
                }
            }
            catch (Exception e2) {
                throw new MissingResourceException("Could not even get generic properties: " + e2.getMessage(), Loader.class.getName(), name);
            }
        }
        return p;
    }

    public static void appendProperties(java.util.Properties properties, Class cls) {
        Platform[] platforms;
        String platformName = properties.getProperty("platform.name");
        Class c2 = cls;
        Properties classProperties = c2.getAnnotation(Properties.class);
        if (classProperties == null) {
            try {
                Platform platform = c2.getAnnotation(Platform.class);
                if (platform == null) {
                    return;
                }
                platforms = new Platform[]{platform};
            }
            catch (Throwable t) {
                System.err.println("Could not append properties for " + c2.getCanonicalName() + ": " + t);
                return;
            }
        } else {
            platforms = classProperties.value();
        }
        String[] define = new String[]{};
        String[] include = new String[]{};
        String[] cinclude = new String[]{};
        String[] includepath = new String[]{};
        String[] options = new String[]{};
        String[] linkpath = new String[]{};
        String[] link = new String[]{};
        String[] framework = new String[]{};
        String[] preloadpath = new String[]{};
        String[] preload = new String[]{};
        for (Platform p : platforms) {
            String[][] names = new String[][]{p.value(), p.not()};
            boolean[] matches = new boolean[]{false, false};
            block3: for (int i2 = 0; i2 < names.length; ++i2) {
                for (String s : names[i2]) {
                    if (!platformName.startsWith(s)) continue;
                    matches[i2] = true;
                    continue block3;
                }
            }
            if (names[0].length != 0 && !matches[0] || names[1].length != 0 && matches[1]) continue;
            if (p.define().length > 0) {
                define = p.define();
            }
            if (p.include().length > 0) {
                include = p.include();
            }
            if (p.cinclude().length > 0) {
                cinclude = p.cinclude();
            }
            if (p.includepath().length > 0) {
                includepath = p.includepath();
            }
            if (p.options().length > 0) {
                options = p.options();
            }
            if (p.linkpath().length > 0) {
                linkpath = p.linkpath();
            }
            if (p.link().length > 0) {
                link = p.link();
            }
            if (p.framework().length > 0) {
                framework = p.framework();
            }
            if (p.preloadpath().length > 0) {
                preloadpath = p.preloadpath();
            }
            if (p.preload().length <= 0) continue;
            preload = p.preload();
        }
        String s = properties.getProperty("path.separator");
        Loader.appendProperty(properties, "generator.define", "\u0000", define);
        Loader.appendProperty(properties, "generator.include", "\u0000", include);
        Loader.appendProperty(properties, "generator.cinclude", "\u0000", cinclude);
        Loader.appendProperty(properties, "compiler.includepath", s, includepath);
        if (options.length > 0) {
            String defaultOptions = properties.getProperty("compiler.options");
            properties.setProperty("compiler.options", "");
            for (int i3 = 0; i3 < options.length; ++i3) {
                String o2 = defaultOptions;
                if (options[i3].length() > 0) {
                    o2 = properties.getProperty("compiler.options." + options[i3]);
                }
                Loader.appendProperty(properties, "compiler.options", " ", o2);
            }
        }
        Loader.appendProperty(properties, "compiler.linkpath", s, linkpath);
        Loader.appendProperty(properties, "compiler.link", s, link);
        Loader.appendProperty(properties, "compiler.framework", s, framework);
        Loader.appendProperty(properties, "loader.preloadpath", s, linkpath);
        Loader.appendProperty(properties, "loader.preloadpath", s, preloadpath);
        Loader.appendProperty(properties, "loader.preload", s, link);
        Loader.appendProperty(properties, "loader.preload", s, preload);
    }

    public static void appendProperty(java.util.Properties properties, String name, String separator, String ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (values.length == 1) {
            values = values[0].split(separator);
        }
        String oldValue = properties.getProperty(name, "");
        String[] oldValues = oldValue.split(separator);
        String value = "";
        block0: for (String v : values) {
            if (v == null || v.length() == 0) continue;
            for (String ov : oldValues) {
                if (v.equals(ov)) continue block0;
            }
            if (value.length() > 0 && !value.endsWith(separator)) {
                value = value + separator;
            }
            value = value + v;
        }
        if (value.length() > 0 && oldValue.length() > 0) {
            value = value + separator;
        }
        properties.setProperty(name, value + oldValue);
    }

    public static String getLibraryName(Class cls) {
        return "jni" + cls.getSimpleName();
    }

    public static Class getCallerClass(int i2) {
        Class[] classContext = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classContext != null) {
            for (int j2 = 0; j2 < classContext.length; ++j2) {
                if (classContext[j2] != Loader.class) continue;
                return classContext[i2 + j2];
            }
        } else {
            try {
                StackTraceElement[] classNames = Thread.currentThread().getStackTrace();
                for (int j3 = 0; j3 < classNames.length; ++j3) {
                    if (Class.forName(classNames[j3].getClassName()) != Loader.class) continue;
                    return Class.forName(classNames[i2 + j3].getClassName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File extractResource(String name, File directory, String prefix, String suffix) throws IOException {
        Class cls = Loader.getCallerClass(2);
        return Loader.extractResource(cls, name, directory, prefix, suffix);
    }

    public static File extractResource(Class cls, String name, File directory, String prefix, String suffix) throws IOException {
        return Loader.extractResource(cls.getResource(name), directory, prefix, suffix);
    }

    public static File extractResource(URL resourceURL, File directory, String prefix, String suffix) throws IOException {
        InputStream is;
        InputStream inputStream = is = resourceURL != null ? resourceURL.openStream() : null;
        if (is == null) {
            return null;
        }
        File file = null;
        boolean fileExisted = false;
        try {
            int n2;
            if (prefix == null && suffix == null) {
                if (directory == null) {
                    directory = new File(System.getProperty("java.io.tmpdir"));
                }
                file = new File(directory, new File(resourceURL.getPath()).getName());
                fileExisted = file.exists();
            } else {
                file = File.createTempFile(prefix, suffix, directory);
            }
            FileOutputStream os = new FileOutputStream(file);
            byte[] data = new byte[is.available()];
            while ((n2 = is.read(data)) > 0) {
                os.write(data, 0, n2);
            }
            is.close();
            os.close();
        }
        catch (IOException e2) {
            if (file != null && !fileExisted) {
                file.delete();
            }
            throw e2;
        }
        return file;
    }

    static File getTempDir() {
        if (tempDir == null) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File f2 = null;
            for (int i2 = 0; i2 < 1000; ++i2) {
                f2 = new File(tmpdir, "javacpp" + System.nanoTime());
                if (!f2.mkdir()) continue;
                tempDir = f2;
                tempDir.deleteOnExit();
                break;
            }
        }
        return tempDir;
    }

    public static String load() {
        Class cls = Loader.getCallerClass(2);
        return Loader.load(cls);
    }

    public static String load(Class cls) {
        if (!loadLibraries || cls == null) {
            return null;
        }
        String className = cls.getName();
        int topIndex = className.indexOf(36);
        if (topIndex > 0) {
            className = className.substring(0, topIndex);
        }
        try {
            cls = Class.forName(className, true, cls.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            NoClassDefFoundError e2 = new NoClassDefFoundError(ex.toString());
            e2.initCause(ex);
            throw e2;
        }
        java.util.Properties p = (java.util.Properties)Loader.getProperties().clone();
        Loader.appendProperties(p, cls);
        String pathSeparator = p.getProperty("path.separator");
        String platformRoot = p.getProperty("platform.root");
        if (platformRoot != null && !platformRoot.endsWith(File.separator)) {
            platformRoot = platformRoot + File.separator;
        }
        String preloadPath = p.getProperty("loader.preloadpath");
        String preloadLibraries = p.getProperty("loader.preload");
        if (preloadLibraries != null) {
            String[] preloadPaths;
            String[] stringArray = preloadPaths = preloadPath == null ? null : preloadPath.split(pathSeparator);
            if (preloadPaths != null && platformRoot != null) {
                for (int i2 = 0; i2 < preloadPaths.length; ++i2) {
                    if (new File(preloadPaths[i2]).isAbsolute()) continue;
                    preloadPaths[i2] = platformRoot + preloadPaths[i2];
                }
            }
            String[] libnames = preloadLibraries.split(pathSeparator);
            for (int i3 = 0; i3 < libnames.length; ++i3) {
                try {
                    Loader.loadLibrary(cls, preloadPaths, libnames[i3]);
                    continue;
                }
                catch (UnsatisfiedLinkError e3) {
                    // empty catch block
                }
            }
        }
        return Loader.loadLibrary(cls, null, Loader.getLibraryName(cls));
    }

    public static String loadLibrary(String libnameversion) {
        Class cls = Loader.getCallerClass(2);
        return Loader.loadLibrary(cls, null, libnameversion);
    }

    public static String loadLibrary(String[] paths, String libnameversion) {
        Class cls = Loader.getCallerClass(2);
        return Loader.loadLibrary(cls, paths, libnameversion);
    }

    public static String loadLibrary(Class cls, String[] paths, String libnameversion) {
        if (!loadLibraries || cls == null) {
            return null;
        }
        String className = cls.getName();
        int packageIndex = className.lastIndexOf(46);
        String packageName = packageIndex != -1 ? className.substring(0, packageIndex + 1) : "";
        String hashkey = packageName + libnameversion;
        String filename = loadedLibraries.get(hashkey);
        if (filename != null) {
            return filename;
        }
        String[] s = libnameversion.split("@");
        String libname = s[0];
        String version = s.length > 1 ? s[s.length - 1] : "";
        java.util.Properties p = Loader.getProperties();
        String subdir = p.getProperty("platform.name") + '/';
        String prefix = p.getProperty("library.prefix") + libname;
        String suffix = p.getProperty("library.suffix");
        URL resourceURL = cls.getResource(subdir + prefix + suffix + version);
        if (resourceURL == null) {
            resourceURL = cls.getResource(subdir + prefix + version + suffix);
        }
        if (resourceURL == null) {
            resourceURL = cls.getResource(subdir + prefix + suffix);
        }
        File tempFile = null;
        try {
            if (resourceURL != null) {
                tempFile = Loader.extractResource(resourceURL, Loader.getTempDir(), null, null);
                String tempFilename = tempFile.getAbsolutePath();
                loadedLibraries.put(hashkey, tempFilename);
                System.load(tempFilename);
                String string = tempFilename;
                return string;
            }
            for (int j2 = 0; paths != null && j2 < paths.length; ++j2) {
                File file = new File(paths[j2], prefix + suffix + version);
                if (!file.exists()) {
                    file = new File(paths[j2], prefix + version + suffix);
                }
                if (!file.exists()) {
                    file = new File(paths[j2], prefix + suffix);
                }
                if (!file.exists()) continue;
                filename = file.getPath();
                try {
                    loadedLibraries.put(hashkey, filename);
                    System.load(filename);
                    String string = filename;
                    return string;
                }
                catch (UnsatisfiedLinkError e2) {
                    loadedLibraries.remove(hashkey);
                    continue;
                }
            }
            loadedLibraries.put(hashkey, libname);
        }
        catch (UnsatisfiedLinkError e3) {
            loadedLibraries.remove(hashkey);
            if (tempFile != null) {
                tempFile.delete();
            }
            throw e3;
        }
        catch (IOException ex) {
            loadedLibraries.remove(hashkey);
            if (tempFile != null) {
                tempFile.delete();
            }
            UnsatisfiedLinkError e4 = new UnsatisfiedLinkError(ex.toString());
            e4.initCause(ex);
            throw e4;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
        }
        System.loadLibrary(libname);
        String j2 = libname;
        return j2;
    }

    public static void main(String[] args) {
        File tempDir;
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpdir.equals((tempDir = new File(args[0])).getParentFile()) || !tempDir.getName().startsWith("javacpp")) {
            return;
        }
        for (File file : tempDir.listFiles()) {
            while (file.exists() && !file.delete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {}
            }
        }
        tempDir.delete();
    }

    static void putMemberOffset(String typeName, String member, int offset) throws ClassNotFoundException {
        Class<?> c2 = Class.forName(typeName.replace('/', '.'), false, Loader.class.getClassLoader());
        Loader.putMemberOffset(c2.asSubclass(Pointer.class), member, offset);
    }

    static synchronized void putMemberOffset(Class<? extends Pointer> type, String member, int offset) {
        HashMap<String, Integer> offsets = memberOffsets.get(type);
        if (offsets == null) {
            offsets = new HashMap();
            memberOffsets.put(type, offsets);
        }
        offsets.put(member, offset);
    }

    public static int offsetof(Class<? extends Pointer> type, String member) {
        return memberOffsets.get(type).get(member);
    }

    public static int sizeof(Class<? extends Pointer> type) {
        return memberOffsets.get(type).get("sizeof");
    }

    static {
        if (Loader.getPlatformName().startsWith("windows")) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (tempDir == null) {
                        return;
                    }
                    try {
                        LinkedList<String> command = new LinkedList<String>();
                        command.add(System.getProperty("java.home") + "/bin/java");
                        command.add("-classpath");
                        command.add(System.getProperty("java.class.path"));
                        command.add(Loader.class.getName());
                        command.add(tempDir.getAbsolutePath());
                        new ProcessBuilder(command).start();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            });
        }
        memberOffsets = new WeakHashMap();
    }
}

