/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ImageGen {
    static String arname;
    static String pkgname;
    static String destdir;
    static String[] names;
    static byte[][] images;
    static DataOutputStream ds;

    public static void main(String[] args) {
        names = new String[args.length + 1];
        images = new byte[args.length + 1][];
        int i2 = 0;
        int j2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-d")) {
                if (i2++ >= args.length) {
                    ImageGen.printUsage();
                    return;
                }
                destdir = args[i2];
            } else {
                ImageGen.names[j2++] = args[i2];
            }
            ++i2;
        }
        ImageGen.names[j2] = null;
        if (j2 == 0) {
            ImageGen.printUsage();
            return;
        }
        i2 = names[0].lastIndexOf(".");
        if (i2 == -1) {
            pkgname = null;
            arname = names[0];
        } else {
            pkgname = names[0].substring(0, i2);
            arname = names[0].substring(i2 + 1);
        }
        String filename = null;
        try {
            filename = destdir == null ? arname + ".java" : destdir + File.separator + arname + ".java";
            ds = new DataOutputStream(new FileOutputStream(filename));
        }
        catch (IOException e2) {
            System.err.println("Cannot open file: " + filename + e2);
        }
        if (j2 == 1) {
            ImageGen.writeInterface();
        } else {
            ImageGen.writeClass();
        }
    }

    static void printUsage() {
        System.err.println("java ImageGen [-d <destdir>] <imagelib> image1 image2 ...");
    }

    static void writeInterface() {
        try {
            ds.writeBytes("/* Generated by ImageGen.\n   DO NOT EDIT.*/\n\n");
            if (pkgname != null) {
                ds.writeBytes("package ");
                ds.writeBytes(pkgname);
                ds.writeBytes(";\n\n");
            }
            ds.writeBytes("public interface ImageLib {\n");
            ds.writeBytes("    public byte[] getImage(String name);\n");
            ds.writeBytes("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeClass() {
        int accBytes = 0;
        try {
            ImageGen.readImages();
            ds.writeBytes("/* Generated by ImageGen.\n   DO NOT EDIT.*/\n\n");
            if (pkgname != null) {
                ds.writeBytes("package ");
                ds.writeBytes(pkgname);
                ds.writeBytes(";\n\n");
            }
            ds.writeBytes("public abstract class ");
            ds.writeBytes(arname);
            ds.writeBytes(" {\n\n");
            ds.writeBytes("    private static byte[] m(int from,int to){\n");
            ds.writeBytes("       int i;\n");
            ds.writeBytes("       byte[] b= new byte[to - from];\n");
            ds.writeBytes("       for (i=0;i<b.length;i++)\n");
            ds.writeBytes("          b[i] = (byte)(s.charAt(i+from)-1);\n");
            ds.writeBytes("       return b;\n");
            ds.writeBytes("    }\n");
            ds.writeBytes("    private static String s = \n        ");
            int i2 = 1;
            while (names[i2] != null) {
                ds.writeBytes("\"");
                int len = images[i2].length;
                int j2 = 0;
                while (j2 < len) {
                    ds.writeBytes("\\" + ImageGen.byte2oct((byte)(1 + images[i2][j2])));
                    if (j2 % 16 == 15) {
                        ds.writeBytes("\"+\n        \"");
                    }
                    ++j2;
                }
                ds.writeBytes("\"");
                if (names[i2 + 1] != null) {
                    ds.writeBytes("+\n        ");
                }
                ++i2;
            }
            ds.writeBytes(";\n\n");
            ds.writeBytes("    public static byte[] getImage(String name) {\n");
            i2 = 1;
            while (names[i2] != null) {
                ds.writeBytes("        if (name.equals(\"" + ImageGen.fileName(names[i2]) + "\"))\n");
                ds.writeBytes("            return m(" + accBytes + "," + (accBytes += images[i2].length) + ");\n");
                ++i2;
            }
            ds.writeBytes("        return null;\n");
            ds.writeBytes("    }\n\n");
            ds.writeBytes("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void readImages() {
        int i2 = 1;
        while (names[i2] != null) {
            String imageFile = names[i2];
            try {
                FileInputStream fi = new FileInputStream(imageFile);
                int len = fi.available();
                ImageGen.images[i2] = new byte[len];
                fi.read(images[i2]);
            }
            catch (IOException e2) {
                System.err.println("Cannot open image file: " + imageFile);
            }
            ++i2;
        }
    }

    private static String fileName(String name) {
        int i2 = name.lastIndexOf(File.separator);
        return name.substring(i2 + 1);
    }

    private static String byte2oct(byte b2) {
        int i2 = b2 & 0xFF;
        int dig3 = i2 % 8;
        int dig2 = i2 / 8 % 8;
        int dig1 = i2 / 64;
        return "" + dig1 + "" + dig2 + "" + dig3;
    }
}

