/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal.preference;

import com.katalon.platform.api.exception.CryptoException;
import com.katalon.platform.api.exception.InvalidDataTypeFormatException;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.model.Entity;
import com.katalon.platform.api.preference.PluginPreference;
import com.katalon.platform.internal.util.CryptoUtil;
import com.katalon.platform.internal.util.LinkedProperties;
import com.katalon.platform.internal.util.PropertySettingStoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;

public class InternalPluginPreferenceImpl
implements PluginPreference {
    private final String projectId;
    private final String pluginId;
    private final LinkedProperties properties;
    private String projectDir;

    public InternalPluginPreferenceImpl(Entity projectEntity, String pluginId) throws ResourceException {
        this.projectId = projectEntity.getId();
        this.pluginId = pluginId;
        this.projectDir = projectEntity.getFolderLocation();
        try {
            this.properties = this.loadProperties(this.getPropertyFile());
        }
        catch (IOException e) {
            throw new ResourceException(String.format("Unable to load settings for plugin %s", pluginId), e);
        }
    }

    private LinkedProperties loadProperties(File file) throws IOException {
        if (!file.exists()) {
            return new LinkedProperties();
        }
        try (FileInputStream fileInput = new FileInputStream(file);){
            LinkedProperties properties = new LinkedProperties();
            properties.load(new InputStreamReader((InputStream)fileInput, StandardCharsets.UTF_8));
            LinkedProperties linkedProperties = properties;
            return linkedProperties;
        }
    }

    private File getPropertyFile() throws IOException {
        return new File(this.projectDir, "settings/internal/" + this.pluginId + ".properties");
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setInt(String key, int value) {
        try {
            this.setInt(key, value, false);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Override
    public void setInt(String key, int value, boolean shouldEncrypt) throws CryptoException {
        String rawValue = PropertySettingStoreUtil.getRawValue(value);
        if (shouldEncrypt) {
            try {
                rawValue = CryptoUtil.encode(CryptoUtil.getDefault(rawValue));
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                throw new CryptoException(e);
            }
        }
        this.properties.setProperty(key, rawValue);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        try {
            this.setBoolean(key, value, false);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Override
    public void setBoolean(String key, boolean value, boolean shouldEncrypt) throws CryptoException {
        String rawValue = PropertySettingStoreUtil.getRawValue(value);
        if (shouldEncrypt) {
            try {
                rawValue = CryptoUtil.encode(CryptoUtil.getDefault(rawValue));
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                throw new CryptoException(e);
            }
        }
        this.properties.setProperty(key, rawValue);
    }

    @Override
    public void setString(String key, String value) {
        try {
            this.setString(key, value, false);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Override
    public void setString(String key, String value, boolean shouldEncrypt) throws CryptoException {
        String rawValue = PropertySettingStoreUtil.getRawValue(value);
        if (shouldEncrypt) {
            try {
                rawValue = CryptoUtil.encode(CryptoUtil.getDefault(rawValue));
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                throw new CryptoException(e);
            }
        }
        this.properties.setProperty(key, rawValue);
    }

    @Override
    public String getString(String key, String defaultValue) throws InvalidDataTypeFormatException {
        try {
            return this.getString(key, defaultValue, false);
        }
        catch (CryptoException e) {
            return defaultValue;
        }
    }

    @Override
    public String getString(String key, String defaultValue, boolean shouldDecrypt) throws InvalidDataTypeFormatException, CryptoException {
        if (this.properties.containsKey(key)) {
            return this.getDecryptedValue(key, shouldDecrypt);
        }
        return defaultValue;
    }

    private String getDecryptedValue(String key, boolean shouldDecrypt) throws CryptoException {
        String decryptedValue = String.valueOf(PropertySettingStoreUtil.getValue(this.properties.get(key).toString()));
        if (shouldDecrypt) {
            try {
                decryptedValue = CryptoUtil.decode(CryptoUtil.getDefault(decryptedValue));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new CryptoException(e);
            }
        }
        return decryptedValue;
    }

    @Override
    public int getInt(String key, int defaultValue) throws InvalidDataTypeFormatException {
        try {
            return this.getInt(key, defaultValue, false);
        }
        catch (CryptoException ignored) {
            return defaultValue;
        }
    }

    @Override
    public int getInt(String key, int defaultValue, boolean shouldDecrypt) throws InvalidDataTypeFormatException, CryptoException {
        if (this.properties.containsKey(key)) {
            String value = this.getDecryptedValue(key, shouldDecrypt);
            try {
                return Integer.valueOf(value.replace("\"", ""));
            }
            catch (NumberFormatException e) {
                throw new InvalidDataTypeFormatException(String.format("Value of %s is not an integer", key));
            }
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) throws InvalidDataTypeFormatException {
        try {
            return this.getBoolean(key, defaultValue, false);
        }
        catch (CryptoException ignored) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, boolean shouldDecrypt) throws InvalidDataTypeFormatException, CryptoException {
        if (this.properties.containsKey(key)) {
            String value = this.getDecryptedValue(key, shouldDecrypt);
            return Boolean.valueOf(value.replace("\"", ""));
        }
        return defaultValue;
    }

    @Override
    public void save() throws ResourceException {
        FileOutputStream fos = null;
        try {
            File propertyFile = this.getPropertyFile();
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            fos = new FileOutputStream(propertyFile);
            this.properties.store(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8), "");
        }
        catch (IOException ex) {
            throw new ResourceException(String.format("Unable to save setting file for plugin: %s", this.pluginId));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

