/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.api.network;

import com.katalon.platform.api.preference.ApplicationPreference;
import com.katalon.platform.api.service.ApplicationManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ApplicationProxyPreference {
    public static final String PROXY_PREFERENCE_ID = "com.kms.katalon.execution";

    public static boolean isProxyPreferencesSet() {
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        return store.getBoolean("proxy.preferences.set", false);
    }

    private static ApplicationPreference getPreferenceStore() {
        return ApplicationManager.getInstance().getPreferenceManager().getApplicationPreference(PROXY_PREFERENCE_ID);
    }

    public static ProxyInformation getProxyInformation() {
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption(store.getString("proxy.option", ProxyOption.NO_PROXY.name()));
        proxyInfo.setProxyServerType(store.getString("proxy.server.type", ProxyServerType.HTTP.name()));
        proxyInfo.setProxyServerAddress(store.getString("proxy.server.address", ""));
        proxyInfo.setProxyServerPort(store.getInt("proxy.server.port", 0));
        proxyInfo.setUsername(store.getString("proxy.username", ""));
        proxyInfo.setPassword(store.getString("proxy.password", ""));
        proxyInfo.setDisableMobBrowserProxy(store.getBoolean("proxy.preferences.disableMobRowserProxy", false));
        return proxyInfo;
    }

    public static enum ProxyServerType {
        HTTP,
        HTTPS,
        SOCKS;


        public static String[] stringValues() {
            ProxyServerType[] values = ProxyServerType.values();
            return Arrays.asList(values).stream().map(proxyServerType -> proxyServerType.toString()).collect(Collectors.toList()).toArray(new String[values.length]);
        }
    }

    public static enum ProxyOption {
        NO_PROXY("No Proxy"),
        USE_SYSTEM("Use system proxy configuration"),
        MANUAL_CONFIG("Manual proxy configuration");

        private String displayName;

        private ProxyOption(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static String[] stringValues() {
            ProxyOption[] values = ProxyOption.values();
            return Arrays.asList(values).stream().map(proxyServerType -> proxyServerType.toString()).collect(Collectors.toList()).toArray(new String[values.length]);
        }

        public static String[] displayStringValues() {
            ProxyOption[] values = ProxyOption.values();
            return Arrays.asList(values).stream().map(proxyServerType -> proxyServerType.getDisplayName()).collect(Collectors.toList()).toArray(new String[values.length]);
        }

        public static ProxyOption valueOfDisplayName(String displayName) {
            return Arrays.asList(ProxyOption.values()).parallelStream().filter(proxyOption -> proxyOption.getDisplayName().equals(displayName)).findAny().orElse(null);
        }
    }

    public static class ProxyInformation {
        private String proxyOption;
        private String proxyServerType;
        private String username;
        private String password;
        private String proxyServerAddress;
        private boolean disableMobBrowserProxy;
        private int proxyServerPort;

        public String getProxyOption() {
            return this.proxyOption;
        }

        public void setProxyOption(String proxyOption) {
            if (StringUtils.isEmpty((CharSequence)proxyOption)) {
                proxyOption = ProxyOption.NO_PROXY.name();
            }
            this.proxyOption = proxyOption;
        }

        public String getProxyServerType() {
            return this.proxyServerType;
        }

        public void setProxyServerType(String proxyServerType) {
            this.proxyServerType = StringUtils.isNotEmpty((CharSequence)proxyServerType) ? proxyServerType : "";
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = StringUtils.isNotEmpty((CharSequence)username) ? username : "";
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = StringUtils.isNotEmpty((CharSequence)password) ? password : "";
        }

        public String getProxyServerAddress() {
            return this.proxyServerAddress;
        }

        public void setProxyServerAddress(String proxyServerAddress) {
            this.proxyServerAddress = StringUtils.isNotEmpty((CharSequence)proxyServerAddress) ? proxyServerAddress : "";
        }

        public int getProxyServerPort() {
            return this.proxyServerPort;
        }

        public void setProxyServerPort(int proxyServerPort) {
            this.proxyServerPort = proxyServerPort;
        }

        public void setProxyServerPort(String proxyServerPort) {
            try {
                this.proxyServerPort = Integer.parseInt(StringUtils.isNotEmpty((CharSequence)proxyServerPort) ? proxyServerPort : "-1");
            }
            catch (NumberFormatException ex) {
                this.proxyServerPort = -1;
            }
        }

        public String toString() {
            return "ProxyInformation{proxyOption=" + this.proxyOption + ", proxyServerType=" + this.proxyServerType + ", password=" + this.password + ", proxyServerAddress=" + this.proxyServerAddress + ", proxyServerPort=" + this.proxyServerPort + "}";
        }

        public void setDisableMobBrowserProxy(boolean boolean1) {
            this.disableMobBrowserProxy = boolean1;
        }

        public boolean getDisableMobBroserProxy() {
            return this.disableMobBrowserProxy;
        }
    }

    public static interface ProxyPreferenceConstants {
        public static final String PROXY_OPTION = "proxy.option";
        public static final String PROXY_SERVER_TYPE = "proxy.server.type";
        public static final String PROXY_SERVER_ADDRESS = "proxy.server.address";
        public static final String PROXY_SERVER_PORT = "proxy.server.port";
        public static final String PROXY_USERNAME = "proxy.username";
        public static final String PROXY_PASSWORD = "proxy.password";
        public static final String PROXY_PREFERENCE_SET = "proxy.preferences.set";
        public static final String DISABLE_MOB_BROWSER_PROXY = "proxy.preferences.disableMobRowserProxy";
    }
}

