/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.utils;

import com.kms.katalon.composer.mobile.objectspy.element.Converter;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.BasicMobileElement;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.internal.AndroidProperties;
import com.kms.katalon.core.mobile.keyword.internal.IOSProperties;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MobileElementConverter
implements Converter<MobileElement, WebElementEntity> {
    public WebElementEntity convert(MobileElement element) {
        WebElementEntity newWebElement = new WebElementEntity();
        newWebElement.setName(element.getName());
        ArrayList<WebElementPropertyEntity> webElementProperties = new ArrayList<WebElementPropertyEntity>();
        Map attributes = element.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            WebElementPropertyEntity webElementPropertyEntity = new WebElementPropertyEntity((String)entry.getKey(), (String)entry.getValue());
            webElementProperties.add(webElementPropertyEntity);
        }
        newWebElement.setWebElementProperties(webElementProperties);
        return newWebElement;
    }

    public WebElementEntity convert(MobileElement element, FolderEntity folder, MobileDriverType mobileDriverType) throws Exception {
        WebElementEntity newWebElement = this.convert(element);
        newWebElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(folder, ObjectRepositoryController.toValidFileName((String)StringUtils.trim((String)element.getName()))));
        newWebElement.setParentFolder(folder);
        newWebElement.setProject(folder.getProject());
        this.autoSelectObjectProperties(newWebElement, mobileDriverType);
        return newWebElement;
    }

    public MobileElement revert(WebElementEntity webElement) {
        BasicMobileElement mobileElement = new BasicMobileElement();
        mobileElement.setName(webElement.getName());
        Map attributes = mobileElement.getAttributes();
        for (WebElementPropertyEntity propertyEntity : webElement.getWebElementProperties()) {
            attributes.put(propertyEntity.getName(), propertyEntity.getValue());
        }
        return mobileElement;
    }

    private void autoSelectObjectProperties(WebElementEntity entity, MobileDriverType mobileDriverType) {
        ArrayList<String> typicalProps = new ArrayList<String>();
        if (mobileDriverType == MobileDriverType.ANDROID_DRIVER) {
            typicalProps.addAll(Arrays.asList(AndroidProperties.ANDROID_TYPICAL_PROPERTIES));
        } else if (mobileDriverType == MobileDriverType.IOS_DRIVER) {
            typicalProps.addAll(Arrays.asList(IOSProperties.IOS_TYPICAL_PROPERTIES));
        }
        for (WebElementPropertyEntity prop : entity.getWebElementProperties()) {
            prop.setIsSelected(Boolean.valueOf(typicalProps.contains(prop.getName())));
        }
    }
}

