/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.utils;

import com.kms.katalon.composer.mobile.recorder.actions.IMobileAction;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionParam;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionParamValueType;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.ArrayList;

public class MobileActionUtil {
    public static KeywordClass getMobileKeywordClass() {
        return KeywordController.getInstance().getBuiltInKeywordClassByName(MobileBuiltInKeywords.class.getName());
    }

    public static MobileActionParam[] collectKeywordParam(String keywordClass, String keywordMethodName) {
        KeywordMethod keywordMethod = KeywordController.getInstance().getBuiltInKeywordByName(keywordClass, keywordMethodName);
        if (keywordMethod == null) {
            return new MobileActionParam[0];
        }
        ArrayList<MobileActionParam> paramList = new ArrayList<MobileActionParam>();
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            KeywordParameter parameter = keywordMethod.getParameters()[i];
            if (parameter.isGeneralParam()) {
                paramList.add(new MobileActionParam(parameter.getName(), parameter.getType()));
            }
            ++i;
        }
        return paramList.toArray(new MobileActionParam[paramList.size()]);
    }

    public static boolean hasElement(String keywordClass, String keywordMethodName) {
        KeywordMethod keywordMethod = KeywordController.getInstance().getBuiltInKeywordByName(keywordClass, keywordMethodName);
        if (keywordMethod == null) {
            return false;
        }
        int i = 0;
        while (i < keywordMethod.getParameters().length) {
            if (keywordMethod.getParameters()[i].isTestObjectParam()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static MobileActionParamValueType[] generateParamDatas(IMobileAction action, MobileActionParamValueType[] existingParamDatas) {
        if (action == null || action.getParams() == null) {
            return new MobileActionParamValueType[0];
        }
        MobileActionParamValueType[] newParamDataArray = new MobileActionParamValueType[action.getParams().length];
        int i = 0;
        while (i < action.getParams().length) {
            InputValueType valueType;
            MobileActionParam mobileActionParam;
            MobileActionParamValueType existingParamData = existingParamDatas != null && i < existingParamDatas.length ? existingParamDatas[i] : null;
            if (!MobileActionUtil.isAssignableFromScript(existingParamData, mobileActionParam = action.getParams()[i]) && (valueType = AstInputValueTypeOptionsProvider.getAssignableValueType(mobileActionParam.getClazz())) != null) {
                existingParamData = MobileActionParamValueType.newInstance((InputValueEditorProvider)valueType, mobileActionParam.getName());
            }
            newParamDataArray[i] = existingParamData;
            ++i;
        }
        return newParamDataArray;
    }

    private static boolean isAssignableFromScript(MobileActionParamValueType existingParamData, MobileActionParam param) {
        if (existingParamData == null) {
            return false;
        }
        ExpressionWrapper expression = existingParamData.toExpressionWrapper();
        if (expression == null) {
            return false;
        }
        Class<?> paramClass = param.getClazz();
        ClassNodeWrapper existingParamClassNode = expression.getType();
        if (paramClass.isPrimitive() || existingParamClassNode.getTypeClass() == null) {
            return paramClass.getName().equalsIgnoreCase(existingParamClassNode.getName());
        }
        return paramClass.isAssignableFrom(existingParamClassNode.getTypeClass());
    }

    private static KeywordMethod getMethodInActionMapping(MobileActionMapping actionMapping) throws ClassNotFoundException {
        IMobileAction action = actionMapping.getAction();
        if (action == null) {
            return null;
        }
        KeywordMethod method = null;
        for (KeywordMethod declareMethod : KeywordController.getInstance().getBuiltInKeywords(action.getMappedKeywordClassSimpleName())) {
            if (!declareMethod.getName().equals(action.getMappedKeywordMethod())) continue;
            method = declareMethod;
            break;
        }
        return method;
    }

    public static StatementWrapper generateMobileTestStep(MobileActionMapping actionMapping, WebElementEntity createdTestObject, ASTNodeWrapper parentClassNode) throws ClassNotFoundException {
        KeywordMethod method = MobileActionUtil.getMethodInActionMapping(actionMapping);
        if (method == null) {
            return null;
        }
        int actionDataCount = 0;
        IMobileAction action = actionMapping.getAction();
        MethodCallExpressionWrapper methodCallExpressionWrapper = new MethodCallExpressionWrapper(MobileActionUtil.getMobileKeywordClass().getAliasName(), action.getMappedKeywordMethod(), parentClassNode);
        ArgumentListExpressionWrapper argumentListExpressionWrapper = methodCallExpressionWrapper.getArguments();
        int i = 0;
        while (i < method.getParameters().length) {
            Class argumentClass = method.getParameters()[i].getType();
            MethodCallExpressionWrapper generatedExression = null;
            if (argumentClass.getName().equals(TestObject.class.getName())) {
                generatedExression = AstEntityInputUtil.createNewFindTestObjectMethodCall((String)(createdTestObject != null ? createdTestObject.getIdForDisplay() : null), (ASTNodeWrapper)parentClassNode);
            } else if (argumentClass.getName().equals(FailureHandling.class.getName())) {
                generatedExression = AstKeywordsInputUtil.getNewFailureHandlingPropertyExpression(null);
            } else {
                MobileActionParamValueType paramValueType = actionMapping.getData()[actionDataCount];
                generatedExression = paramValueType.toExpressionWrapper();
                ++actionDataCount;
            }
            argumentListExpressionWrapper.addExpression((ExpressionWrapper)generatedExression);
            ++i;
        }
        return new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpressionWrapper, null);
    }
}

