/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.recorder.components.MobileRecorderDialog;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecorderStringConstants;
import com.kms.katalon.composer.mobile.recorder.utils.MobileActionUtil;
import com.kms.katalon.composer.mobile.recorder.utils.MobileElementConverter;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.handlers.NewTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.control.CompilationFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenMobileRecorderHandler {
    private MobileRecorderDialog recorderDialog;
    private Shell activeShell;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    private static OpenMobileRecorderHandler instance;

    public OpenMobileRecorderHandler() {
        instance = this;
    }

    public static OpenMobileRecorderHandler getInstance() {
        return instance;
    }

    @PostConstruct
    public void registerEvent() {
        this.eventBroker.subscribe("OBJECT_SPY/MOBILE", new EventHandler(){

            public void handleEvent(Event event) {
                if (!OpenMobileRecorderHandler.this.canExecute()) {
                    return;
                }
                OpenMobileRecorderHandler.this.execute(Display.getCurrent().getActiveShell());
            }
        });
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell) {
        MobileUtil.detectAppiumAndNodeJs((Shell)activeShell);
        this.openRecorderDialog(activeShell);
    }

    private boolean openRecorderDialog(Shell activeShell) {
        TestCaseCompositePart testCaseCompositePart;
        block7: {
            block6: {
                try {
                    if (this.activeShell == null) {
                        this.activeShell = activeShell;
                    }
                    if ((testCaseCompositePart = this.getSelectedTestCasePart()) == null || this.verifyTestCase(testCaseCompositePart)) break block6;
                    return false;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    MessageDialog.openError((Shell)activeShell, (String)MobileRecorderStringConstants.ERROR, (String)e.getMessage());
                    return false;
                }
            }
            this.recorderDialog = new MobileRecorderDialog(activeShell);
            Trackings.trackOpenMobileRecord();
            if (this.recorderDialog.open() == 0) break block7;
            return false;
        }
        if (testCaseCompositePart == null) {
            testCaseCompositePart = this.createNewTestCase();
        }
        this.exportRecordedActionsToScripts(this.recorderDialog.getRecordedActions(), this.recorderDialog.getTargetFolderEntity(), this.recorderDialog.getCurrentMobileDriverType(), testCaseCompositePart);
        return true;
    }

    private TestCaseCompositePart createNewTestCase() throws Exception {
        TestCaseEntity testCase = NewTestCaseHandler.doCreateNewTestCase((ITreeEntity)new FolderTreeEntity(FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject()), null), (IEventBroker)EventBrokerSingleton.getInstance().getEventBroker());
        if (testCase == null) {
            return null;
        }
        return this.getTestCasePartByTestCase(testCase);
    }

    private TestCaseCompositePart getTestCasePartByTestCase(TestCaseEntity testCase) throws Exception {
        MPart selectedPart = (MPart)this.modelService.find(EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId()), (MUIElement)this.application);
        if (selectedPart == null || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private TestCaseCompositePart getSelectedTestCasePart() {
        MPart selectedPart = this.getSelectedPart();
        if (selectedPart == null || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)selectedPart.getObject();
        return testCaseCompositePart;
    }

    private void exportRecordedActionsToScripts(final List<MobileActionMapping> recordedActions, final FolderTreeEntity targetFolderTreeEntity, final MobileDriverType mobileDriverType, final TestCaseCompositePart testCaseCompositePart) {
        if (testCaseCompositePart == null) {
            return;
        }
        Job job = new Job(MobileRecoderMessagesConstants.MSG_TASK_GENERATE_SCRIPT){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
                    final List generatedStatementWrappers = OpenMobileRecorderHandler.this.generateStatementWrappersFromRecordedActions(recordedActions, testCasePart, targetFolderTreeEntity, mobileDriverType, monitor);
                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                testCasePart.addDefaultImports();
                                testCasePart.addStatements(generatedStatementWrappers, TestCaseTreeTableInput.NodeAddType.InserAfter);
                                testCaseCompositePart.refreshScript();
                                testCaseCompositePart.save();
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                        }
                    });
                    OpenMobileRecorderHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetFolderTreeEntity.getParent());
                    OpenMobileRecorderHandler.this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)targetFolderTreeEntity);
                    OpenMobileRecorderHandler.this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", (Object)targetFolderTreeEntity);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)MobileRecorderStringConstants.ERROR, (String)MobileRecoderMessagesConstants.MSG_ERR_CANNOT_GENERATE_TEST_STEPS);
                            LoggerSingleton.logError((Throwable)e);
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private boolean verifyTestCase(TestCaseCompositePart testCaseCompositePart) throws Exception {
        if (testCaseCompositePart.getDirty().isDirty()) {
            if (!MessageDialog.openConfirm((Shell)this.activeShell, (String)MobileRecorderStringConstants.WARN, (String)MobileRecoderMessagesConstants.MSG_ERR_TEST_CASE_HAVE_UNSAVE_CHANGES)) {
                return false;
            }
            testCaseCompositePart.save();
        }
        try {
            testCaseCompositePart.getAstNodesFromScript();
        }
        catch (CompilationFailedException compilationFailedException) {
            MessageDialog.openWarning((Shell)this.activeShell, (String)MobileRecorderStringConstants.WARN, (String)MobileRecoderMessagesConstants.MSG_ERR_TEST_CASE_HAVE_ERRORS);
            return false;
        }
        return true;
    }

    private WebElementEntity addRecordedElement(MobileElement element, FolderEntity parentFolder, MobileDriverType mobileDriverType, Map<MobileElement, WebElementEntity> entitySavedMap) throws Exception {
        if (element == null) {
            return null;
        }
        if (entitySavedMap != null && entitySavedMap.get(element) != null) {
            return entitySavedMap.get(element);
        }
        WebElementEntity importedElement = ObjectRepositoryController.getInstance().importWebElement(new MobileElementConverter().convert(element, parentFolder, mobileDriverType), parentFolder);
        entitySavedMap.put(element, importedElement);
        return importedElement;
    }

    private List<StatementWrapper> generateStatementWrappersFromRecordedActions(List<MobileActionMapping> recordedActions, TestCasePart testCasePart, FolderTreeEntity folderSelectionResult, MobileDriverType mobileDriverType, IProgressMonitor monitor) throws Exception {
        HashMap<MobileElement, WebElementEntity> entitySavedMap = new HashMap<MobileElement, WebElementEntity>();
        FolderEntity targetFolder = folderSelectionResult.getObject();
        monitor.beginTask(MobileRecoderMessagesConstants.MSG_TASK_GENERATE_SCRIPT, recordedActions.size());
        ScriptNodeWrapper mainClassNode = testCasePart.getTreeTableInput().getMainClassNode();
        ArrayList<StatementWrapper> resultStatementWrappers = new ArrayList<StatementWrapper>();
        for (MobileActionMapping action : recordedActions) {
            WebElementEntity createdTestObject = this.addRecordedElement(action.getTargetElement(), targetFolder, mobileDriverType, entitySavedMap);
            StatementWrapper generatedStatementWrapper = MobileActionUtil.generateMobileTestStep(action, createdTestObject, (ASTNodeWrapper)mainClassNode);
            monitor.worked(1);
            resultStatementWrappers.add(generatedStatementWrapper);
        }
        return resultStatementWrappers;
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    protected MPart getSelectedPart() {
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (!composerStack.isVisible() || !(composerStack.getSelectedElement() instanceof MPart)) {
            return null;
        }
        return (MPart)composerStack.getSelectedElement();
    }
}

