/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.components;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.mobile.objectspy.components.KobitonAppComposite;
import com.kms.katalon.composer.mobile.objectspy.components.LocalAppComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumStreamHandler;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileDeviceDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.element.MobileDeviceType;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileElementLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileElementTreeContentProvider;
import com.kms.katalon.composer.mobile.objectspy.preferences.MobileObjectSpyPreferencesHelper;
import com.kms.katalon.composer.mobile.objectspy.util.KobitonValidator;
import com.kms.katalon.composer.mobile.objectspy.util.MobileActionHelper;
import com.kms.katalon.composer.mobile.recorder.actions.MobileAction;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionParamValueType;
import com.kms.katalon.composer.mobile.recorder.components.MobileActionButtonWrapper;
import com.kms.katalon.composer.mobile.recorder.components.MobileReadonlyElementPropertiesComposite;
import com.kms.katalon.composer.mobile.recorder.constants.ImageConstants;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecorderImageConstants;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecorderStringConstants;
import com.kms.katalon.composer.mobile.recorder.exceptions.MobileRecordException;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.internal.AndroidProperties;
import com.kms.katalon.core.mobile.keyword.internal.IOSProperties;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.execution.mobile.constants.StringConstants;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.integration.kobiton.entity.KobitonApplication;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class MobileRecorderDialog
extends AbstractDialog
implements MobileElementInspectorDialog,
MobileAppDialog {
    private static final int DIALOG_MARGIN_OFFSET = 5;
    private List<MobileActionMapping> recordedActions = new ArrayList<MobileActionMapping>();
    private FolderTreeEntity targetFolderEntity;
    private List<MobileActionButtonWrapper> actionButtons = new ArrayList<MobileActionButtonWrapper>();
    private ToolItem btnStart;
    private ToolItem btnCapture;
    private ToolItem btnStop;
    private ToolItem tltmDelete;
    private Combo cbbAppType;
    private TableViewer actionTableViewer;
    private TreeViewer allElementTreeViewer;
    private MobileDeviceDialog deviceView;
    private TreeMobileElement appRootElement;
    private MobileInspectorController inspectorController = new MobileInspectorController();
    private MobileObjectSpyPreferencesHelper preferencesHelper = new MobileObjectSpyPreferencesHelper();
    private Composite container;
    private MobileReadonlyElementPropertiesComposite propertiesComposite;
    private LocalAppComposite localAppComposite;
    private KobitonAppComposite kobitonAppComposite;
    private StackLayout stackLayout;
    private Composite appsComposite;

    public MobileRecorderDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1264);
    }

    public boolean close() {
        this.stopObjectInspectorAction();
        try {
            this.preferencesHelper.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        boolean result = super.close();
        Trackings.trackCloseRecord((String)"mobile", (String)"cancel", (int)0);
        return result;
    }

    public void create() {
        super.create();
        this.cbbAppType.select(0);
        this.updateDeviceNames();
        this.validateToEnableStartButton();
        this.targetElementChanged(null);
        this.updateActionButtonsVisibility(null, this.getCurrentMobileDriverType());
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(1000, 800);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x40 | 0x800 | 0x20);
        this.setBlockOnOpen(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MobileRecoderMessagesConstants.DLG_TITLE_MOBILE_RECORDER);
    }

    private boolean isOutOfBound(Rectangle displayBounds, Point dialogSize, int startX) {
        return startX < 0 || startX + dialogSize.x > displayBounds.width + displayBounds.x;
    }

    private int getDeviceViewStartXIfPlaceRight(Rectangle objectSpyViewBounds) {
        return objectSpyViewBounds.x + objectSpyViewBounds.width + 5;
    }

    private int getDeviceViewStartXIfPlaceLeft(Rectangle objectSpyViewBounds, Point dialogSize) {
        return objectSpyViewBounds.x - dialogSize.x - 5;
    }

    private int getDefaultDeviceViewDialogStartX(Rectangle displayBounds, Point dialogSize) {
        return displayBounds.width - dialogSize.x;
    }

    private int calculateDialogStartX(Rectangle displayBounds, Point dialogSize) {
        int dialogsWidth = dialogSize.x + 400;
        int screenRemainer = displayBounds.width - dialogsWidth;
        int startX = screenRemainer + screenRemainer / 2 + displayBounds.x;
        return Math.max(startX, 0);
    }

    private int calculateDialogStartY(Rectangle displayBounds, Point dialogSize) {
        int startY = displayBounds.height - dialogSize.y;
        return Math.max(startY, 0) / 2;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        return new Point(this.calculateDialogStartX(displayBounds, initialSize), this.calculateDialogStartY(displayBounds, initialSize));
    }

    private Point calculateInitPositionForDeviceViewDialog() {
        Rectangle objectSpyViewBounds;
        int startX;
        Point dialogSize;
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        if (this.isOutOfBound(displayBounds, dialogSize = new Point(400, 600), startX = this.getDeviceViewStartXIfPlaceLeft(objectSpyViewBounds = this.getShell().getBounds(), dialogSize)) && this.isOutOfBound(displayBounds, dialogSize, startX = this.getDeviceViewStartXIfPlaceRight(objectSpyViewBounds))) {
            startX = this.getDefaultDeviceViewDialogStartX(displayBounds, dialogSize);
        }
        return new Point(startX, objectSpyViewBounds.y);
    }

    protected Control createDialogContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)this.createNoMarginGridLayout());
        SashForm sashForm = this.createMainSashForm(this.container);
        this.populateSashForm(sashForm);
        sashForm.setWeights(this.getSashFormChildsWeights());
        return this.container;
    }

    protected Control createButtonBar(Composite parent) {
        Control[] children;
        Control buttonBar = super.createButtonBar(parent);
        Control[] controlArray = children = ((Composite)buttonBar).getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof HelpCompositeForDialog) {
                Composite helpComposite = (Composite)child;
                helpComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
                GridLayout layout = (GridLayout)helpComposite.getLayout();
                layout.marginBottom = 0;
                layout.marginRight = 0;
                helpComposite.getParent().layout(true, true);
                break;
            }
            ++n2;
        }
        return buttonBar;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected boolean hasDocumentation() {
        return true;
    }

    protected String getDocumentationUrl() {
        return MobileRecoderMessagesConstants.URL_DOCUMENTATION_MOBILE_RECORD;
    }

    protected void okPressed() {
        AddElementToObjectRepositoryDialog dialog = new AddElementToObjectRepositoryDialog(this.getParentShell());
        if (dialog.open() != 0) {
            return;
        }
        this.targetFolderEntity = dialog.getSelectedFolderTreeEntity();
        int recordedActionCount = this.getRecordedActions().size();
        super.okPressed();
        Trackings.trackCloseRecord((String)"mobile", (String)"ok", (int)recordedActionCount);
    }

    public List<MobileActionMapping> getRecordedActions() {
        return this.recordedActions;
    }

    public FolderTreeEntity getTargetFolderEntity() {
        return this.targetFolderEntity;
    }

    protected GridLayout createNoMarginGridLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected int[] getSashFormChildsWeights() {
        return new int[]{6, 3, 4};
    }

    protected SashForm createMainSashForm(Composite container) {
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setSashWidth(3);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        sashForm.setBackground(sashForm.getDisplay().getSystemColor(15));
        return sashForm;
    }

    protected void populateSashForm(SashForm sashForm) {
        this.createContentComposite(sashForm);
        this.createMiddlePaneComposite(sashForm);
        this.createRecordedActionComposite(sashForm);
    }

    private void createMiddlePaneComposite(SashForm sashForm) {
        Composite middlePane = new Composite((Composite)sashForm, 0);
        middlePane.setLayout((Layout)this.createNoMarginGridLayout());
        SashForm hSashForm = new SashForm(middlePane, 512);
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        hSashForm.setBackground(hSashForm.getDisplay().getSystemColor(15));
        this.createActionListComposite(hSashForm);
        this.propertiesComposite = new MobileReadonlyElementPropertiesComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{3, 7});
    }

    private void createRecordedActionComposite(SashForm sashForm) {
        Composite recordedActionComposite = new Composite((Composite)sashForm, 0);
        recordedActionComposite.setLayout((Layout)new GridLayout());
        Label lblRecordedActions = new Label(recordedActionComposite, 0);
        lblRecordedActions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText(MobileRecoderMessagesConstants.LBL_RECORDED_ACTIONS);
        this.createActionToolbar(recordedActionComposite);
        Composite actionTableComposite = new Composite(recordedActionComposite, 0);
        actionTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        actionTableComposite.setLayout((Layout)new GridLayout());
        this.actionTableViewer = new TableViewer(actionTableComposite, 67586);
        this.actionTableViewer.getTable().setHeaderVisible(true);
        this.actionTableViewer.getTable().setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.actionTableViewer);
        ColumnViewerUtil.setTableActivation((TableViewer)this.actionTableViewer);
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.actionTableViewer, 0);
        TableColumn tableViewerNo = tableViewerColumnNo.getColumn();
        tableViewerNo.setText(MobileRecoderMessagesConstants.COL_HEADER_NO);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MobileActionMapping) {
                    return String.valueOf(MobileRecorderDialog.this.recordedActions.indexOf(element) + 1);
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnAction = new TableViewerColumn(this.actionTableViewer, 0);
        TableColumn tableColumnAction = tableViewerColumnAction.getColumn();
        tableColumnAction.setText(MobileRecoderMessagesConstants.COL_HEADER_ACTION);
        tableViewerColumnAction.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MobileActionMapping) {
                    MobileActionMapping mobileActionMapping = (MobileActionMapping)element;
                    StringBuilder stringBuilder = new StringBuilder(mobileActionMapping.getAction().getReadableName());
                    MobileActionParamValueType[] data = mobileActionMapping.getData();
                    if (data != null && data.length > 0) {
                        String dataString = Arrays.asList(data).stream().map(dataItem -> String.valueOf(dataItem.getParamName()) + ": " + dataItem.getValueToDisplay()).collect(Collectors.joining(", "));
                        stringBuilder.append(" [" + dataString + "]");
                    }
                    return stringBuilder.toString();
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnElement = new TableViewerColumn(this.actionTableViewer, 0);
        TableColumn tableColumnElement = tableViewerColumnElement.getColumn();
        tableColumnElement.setText(MobileRecoderMessagesConstants.COL_HEADER_ELEMENT);
        tableViewerColumnElement.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MobileActionMapping && ((MobileActionMapping)element).getTargetElement() != null) {
                    return ((MobileActionMapping)element).getTargetElement().getName();
                }
                return "";
            }
        });
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tableViewerNo, (ColumnLayoutData)new ColumnWeightData(0, 30));
        tableLayout.setColumnData((Widget)tableColumnAction, (ColumnLayoutData)new ColumnWeightData(25, 100));
        tableLayout.setColumnData((Widget)tableColumnElement, (ColumnLayoutData)new ColumnWeightData(40, 120));
        actionTableComposite.setLayout((Layout)tableLayout);
        this.actionTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.actionTableViewer.setInput(this.recordedActions);
        this.actionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MobileRecorderDialog.this.tltmDelete.setEnabled(this.isAnyTableItemSelected());
            }

            private boolean isAnyTableItemSelected() {
                if (MobileRecorderDialog.this.actionTableViewer == null) {
                    return false;
                }
                ISelection selection = MobileRecorderDialog.this.actionTableViewer.getSelection();
                return selection != null && !selection.isEmpty();
            }
        });
    }

    private void createActionToolbar(Composite parent) {
        ToolBar actionToolBar = new ToolBar(parent, 0x820000);
        actionToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tltmDelete = new ToolItem(actionToolBar, 8);
        this.tltmDelete.setImage(ImageConstants.IMG_16_DELETE);
        this.tltmDelete.setEnabled(false);
        this.tltmDelete.setText(StringConstants.DELETE);
        this.tltmDelete.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!(MobileRecorderDialog.this.actionTableViewer.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)MobileRecorderDialog.this.actionTableViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedObject = objectArray[n2];
                    if (selectedObject instanceof MobileActionMapping) {
                        MobileActionMapping selectedActionMapping = (MobileActionMapping)selectedObject;
                        MobileRecorderDialog.this.recordedActions.remove(selectedActionMapping);
                    }
                    ++n2;
                }
                MobileRecorderDialog.this.actionTableViewer.refresh();
            }
        });
    }

    private void createActionListComposite(SashForm sashForm) {
        Composite actionListComposite = new Composite((Composite)sashForm, 0);
        actionListComposite.setLayout((Layout)new GridLayout());
        Label lblRecordedActions = new Label(actionListComposite, 0);
        lblRecordedActions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblRecordedActions.setFont(this.getFontBold(lblRecordedActions));
        lblRecordedActions.setText(MobileRecoderMessagesConstants.LBL_POSSIBLE_ACTIONS);
        Composite buttonsComposite = new Composite(actionListComposite, 0);
        RowLayout layout = new RowLayout();
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.actionButtons.addAll(Arrays.asList(MobileAction.values()).stream().filter(action -> action.isUserInputAction()).map(action -> new MobileActionButtonWrapper(buttonsComposite, (MobileAction)action, event -> {
            try {
                MobileActionMapping actionMapping = this.performAction((MobileAction)action, this.propertiesComposite.getEditingElement());
                if (actionMapping == null) {
                    return;
                }
                this.recordedActions.add(actionMapping);
                this.actionTableViewer.refresh();
            }
            catch (StepFailedException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)MobileRecorderStringConstants.ERROR, (String)e.getMessage());
            }
            catch (MobileRecordException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)MobileRecorderStringConstants.ERROR, (String)e.getMessage());
                LoggerSingleton.logError((Throwable)e);
            }
        })).collect(Collectors.toList()));
    }

    private TestObject convertMobileElementToTestObject(MobileElement targetElement, MobileDriverType driverType) {
        if (targetElement == null) {
            return null;
        }
        ArrayList<String> typicalProps = new ArrayList<String>();
        if (driverType == MobileDriverType.ANDROID_DRIVER) {
            typicalProps.addAll(Arrays.asList(AndroidProperties.ANDROID_TYPICAL_PROPERTIES));
        } else if (driverType == MobileDriverType.IOS_DRIVER) {
            typicalProps.addAll(Arrays.asList(IOSProperties.IOS_TYPICAL_PROPERTIES));
        }
        TestObject testObject = new TestObject(targetElement.getName());
        testObject.getProperties().addAll(targetElement.getAttributes().entrySet().stream().map(entry -> {
            TestObjectProperty objectProperty = new TestObjectProperty();
            String keyValue = (String)entry.getKey();
            objectProperty.setName(keyValue);
            objectProperty.setValue((String)entry.getValue());
            objectProperty.setCondition(ConditionType.EQUALS);
            objectProperty.setActive(keyValue.equals("xpath"));
            return objectProperty;
        }).collect(Collectors.toList()));
        return testObject;
    }

    private MobileActionMapping performAction(final MobileAction action, MobileElement targetElement) throws MobileRecordException {
        try {
            final TestObject testObject = this.convertMobileElementToTestObject(targetElement, this.getCurrentMobileDriverType());
            final MobileActionMapping mobileActionMapping = new MobileActionMapping(action, targetElement);
            final MobileActionHelper mobileActionHelper = new MobileActionHelper(this.inspectorController.getDriver());
            final ProgressMonitorDialogWithThread progressDlg = new ProgressMonitorDialogWithThread(this.getShell()){

                public void cancelPressed() {
                    super.cancelPressed();
                    this.finishedRun();
                    this.getProgressMonitor().done();
                }
            };
            IRunnableWithProgress processToRun = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MobileRecoderMessagesConstants.MSG_TASK_EXECUTING_COMMAND, -1);
                    progressDlg.runAndWait((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            switch (action) {
                                case ClearText: {
                                    mobileActionHelper.clearText(testObject);
                                    break;
                                }
                                case HideKeyboard: {
                                    mobileActionHelper.hideKeyboard();
                                    break;
                                }
                                case PressBack: {
                                    mobileActionHelper.pressBack();
                                    break;
                                }
                                case SetText: {
                                    final StringBuilder stringBuilder = new StringBuilder();
                                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            InputDialog inputDialog = new InputDialog(MobileRecorderDialog.this.getShell(), MobileRecoderMessagesConstants.DLG_TITLE_TEXT_INPUT, MobileRecoderMessagesConstants.DLG_MSG_TEXT_INPUT, null, null);
                                            if (inputDialog.open() == 0) {
                                                stringBuilder.append(inputDialog.getValue());
                                            }
                                        }
                                    });
                                    String textInput = stringBuilder.toString();
                                    if (textInput.isEmpty()) {
                                        throw new CancellationException();
                                    }
                                    mobileActionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)textInput));
                                    mobileActionHelper.setText(testObject, textInput);
                                    break;
                                }
                                case SwitchToLandscape: {
                                    mobileActionHelper.switchToLandscape();
                                    break;
                                }
                                case SwitchToPortrait: {
                                    mobileActionHelper.switchToPortrait();
                                    break;
                                }
                                case Tap: {
                                    mobileActionHelper.tap(testObject);
                                    break;
                                }
                                case TapAndHold: {
                                    mobileActionHelper.tapAndHold(testObject);
                                    break;
                                }
                            }
                            Thread.sleep(500L);
                            return null;
                        }
                    });
                    MobileRecorderDialog.this.checkMonitorCanceled(monitor);
                    monitor.done();
                }
            };
            progressDlg.run(true, false, processToRun);
            this.captureObjectAction();
            this.targetElementChanged(null);
            this.allElementTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            return mobileActionMapping;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)e.getTargetException();
                Throwable cause = executionException.getCause();
                if (cause instanceof StepFailedException) {
                    throw (StepFailedException)cause;
                }
                if (cause instanceof CancellationException) {
                    return null;
                }
                throw new MobileRecordException(cause);
            }
            throw new MobileRecordException(e.getTargetException());
        }
        catch (Exception e) {
            throw new MobileRecordException(e);
        }
    }

    private void targetElementChanged(MobileElement mobileElement) {
        this.propertiesComposite.setEditingElement(mobileElement);
        this.updateActionButtonsVisibility(mobileElement, this.getCurrentMobileDriverType());
    }

    public MobileDriverType getCurrentMobileDriverType() {
        if (this.stackLayout == null) {
            return null;
        }
        if (this.stackLayout.topControl == this.localAppComposite) {
            return MobileInspectorController.getMobileDriverType((MobileDeviceInfo)this.localAppComposite.getSelectedMobileDeviceInfo());
        }
        if (this.stackLayout.topControl == this.kobitonAppComposite) {
            return MobileInspectorController.getMobileDriverType((KobitonDevice)this.kobitonAppComposite.getSelectedKobitonDevice());
        }
        return null;
    }

    public void updateActionButtonsVisibility(MobileElement mobileElement, MobileDriverType currentMobileDriverType) {
        this.actionButtons.stream().forEach(actionButton -> {
            MobileAction action = actionButton.getMobileAction();
            actionButton.setEnabledButton(this.inspectorController.getDriver() != null && (!action.hasElement() || mobileElement != null) && currentMobileDriverType != null && action.isDriverTypeSupported(currentMobileDriverType));
        });
    }

    private void createContentComposite(SashForm sashForm) {
        Composite contentComposite = new Composite((Composite)sashForm, 0);
        contentComposite.setLayout((Layout)this.createNoMarginGridLayout());
        this.addStartStopToolbar(contentComposite);
        this.createSettingComposite(contentComposite);
        this.createAllObjectsComposite(contentComposite);
    }

    private void createSettingComposite(Composite parent) {
        Composite settingComposite = new Composite(parent, 0);
        settingComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glSettingComposite = new GridLayout(2, false);
        glSettingComposite.horizontalSpacing = 10;
        settingComposite.setLayout((Layout)glSettingComposite);
        Label lblConfiguration = new Label(settingComposite, 0);
        lblConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblConfiguration.setFont(this.getFontBold(lblConfiguration));
        lblConfiguration.setText(MobileRecoderMessagesConstants.LBL_CONFIGURATIONS);
        Label typeLabel = new Label(settingComposite, 0);
        typeLabel.setText("Device Type");
        this.cbbAppType = new Combo(settingComposite, 8);
        this.cbbAppType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbAppType.setItems(this.getAllDeviceTypeStringValues());
        this.cbbAppType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileRecorderDialog.this.changeAppComposite();
                MobileRecorderDialog.this.refreshButtonsState();
            }
        });
        this.appsComposite = new Composite(settingComposite, 0);
        this.stackLayout = new StackLayout();
        this.appsComposite.setLayout((Layout)this.stackLayout);
        this.appsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.localAppComposite = new LocalAppComposite(this.appsComposite, (MobileAppDialog)this, this.preferencesHelper, 0);
        this.kobitonAppComposite = new KobitonAppComposite(this.appsComposite, (MobileAppDialog)this, 0);
        this.changeAppCompositeToLocal();
    }

    private String[] getAllDeviceTypeStringValues() {
        return (String[])Arrays.asList(MobileDeviceType.values()).stream().filter(deviceType -> deviceType.isSupported()).map(deviceType -> deviceType.getDisplayName()).toArray(String[]::new);
    }

    private void changeAppComposite() {
        MobileDeviceType mobileDeviceType = MobileDeviceType.fromDisplayName((String)this.cbbAppType.getText());
        this.changeAppComposite(mobileDeviceType);
    }

    private void changeAppComposite(MobileDeviceType mobileDeviceType) {
        if (mobileDeviceType == MobileDeviceType.Kobiton && this.stackLayout.topControl != this.kobitonAppComposite) {
            this.changeAppCompositeToKobiton();
        } else if (mobileDeviceType == MobileDeviceType.Local && this.stackLayout.topControl != this.localAppComposite) {
            this.changeAppCompositeToLocal();
        }
        this.appsComposite.layout();
    }

    private void changeAppCompositeToLocal() {
        this.stackLayout.topControl = this.localAppComposite;
    }

    private void changeAppCompositeToKobiton() {
        if (!KobitonValidator.validateKobitonIntergration()) {
            this.cbbAppType.select(MobileDeviceType.indexOf((MobileDeviceType)MobileDeviceType.Local));
            return;
        }
        this.stackLayout.topControl = this.kobitonAppComposite;
        this.updateDeviceNames();
        this.updateApps();
    }

    private void updateApps() {
        try {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)false);
            if (this.stackLayout.topControl != this.kobitonAppComposite) {
                return;
            }
            try {
                this.kobitonAppComposite.updateKobitonApps();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable targetException = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Unable to collect apps", (String)targetException.getClass().getSimpleName());
            }
        }
        finally {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)true);
            this.refreshButtonsState();
        }
    }

    public void refreshButtonsState() {
        this.validateToEnableStartButton();
        this.updateActionButtonsVisibility(this.propertiesComposite.getEditingElement(), this.getCurrentMobileDriverType());
    }

    /*
     * Exception decompiling
     */
    public void updateDeviceNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void openDeviceView() {
        if (this.deviceView != null && !this.deviceView.isDisposed()) {
            return;
        }
        this.deviceView = new MobileDeviceDialog(this.getParentShell(), (MobileElementInspectorDialog)this, this.calculateInitPositionForDeviceViewDialog());
        this.deviceView.open();
    }

    private void startObjectInspectorAction() {
        this.btnStart.setEnabled(false);
        AppiumMonitorDialog progressDlg = new AppiumMonitorDialog(this.getShell()){

            public void cancelPressed() {
                super.cancelPressed();
                this.finishedRun();
                this.getProgressMonitor().done();
                MobileRecorderDialog.this.btnStart.setEnabled(true);
                MobileRecorderDialog.this.btnStop.setEnabled(false);
                MobileRecorderDialog.this.btnCapture.setEnabled(false);
            }
        };
        this.inspectorController.setStreamHandler((AppiumStreamHandler)progressDlg);
        try {
            if (this.stackLayout.topControl == this.localAppComposite && !this.localAppComposite.startLocalApp(this.inspectorController, (ProgressMonitorDialogWithThread)progressDlg)) {
                this.btnStart.setEnabled(true);
                return;
            }
            if (this.stackLayout.topControl == this.kobitonAppComposite && !this.kobitonAppComposite.startKobitonApp(this.inspectorController, (ProgressMonitorDialogWithThread)progressDlg)) {
                this.btnStart.setEnabled(true);
                return;
            }
            try {
                this.captureObjectAction();
                this.btnCapture.setEnabled(true);
                this.btnStop.setEnabled(true);
                this.getButton(0).setEnabled(true);
                this.recordedActions.clear();
                this.targetElementChanged(null);
                this.recordedActions.add(this.buildStartAppActionMapping());
                this.actionTableViewer.refresh();
                Trackings.trackRecord((String)"mobile");
            }
            catch (InterruptedException | InvocationTargetException ex) {
                if (ex instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                    String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
                    MessageDialogWithLink.openError((Shell)Display.getCurrent().getActiveShell(), (String)MobileRecorderStringConstants.ERROR, (String)(String.valueOf(MobileRecoderMessagesConstants.MSG_ERR_CANNOT_START_APP) + ": " + message + "\n<a href=\"" + MobileRecorderStringConstants.URL_TROUBLESHOOTING_MOBILE_TESTING + "\">" + MobileRecorderStringConstants.APPIUM_INSTALLATION_GUIDE_MSG + "</a>"));
                }
                this.btnStart.setEnabled(true);
                this.btnStop.setEnabled(false);
                this.btnCapture.setEnabled(false);
            }
        }
        finally {
            this.inspectorController.setStreamHandler(null);
        }
    }

    public MobileActionMapping buildStartAppActionMapping() {
        KobitonApplication kobitonApp;
        MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartApplication, null);
        String appValue = "";
        if (this.stackLayout.topControl == this.localAppComposite) {
            appValue = this.localAppComposite.getAppFile();
        } else if (this.stackLayout.topControl == this.kobitonAppComposite && (kobitonApp = this.kobitonAppComposite.getSelectedKobitonApplication()) != null) {
            appValue = kobitonApp.buildAutomationKey();
        }
        startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
        return startAppAction;
    }

    public String getAppName() {
        if (this.stackLayout.topControl == this.localAppComposite) {
            return this.localAppComposite.getAppName();
        }
        if (this.stackLayout.topControl == this.kobitonAppComposite) {
            return this.kobitonAppComposite.getAppName();
        }
        return "";
    }

    private void captureObjectAction() {
        final String appName = this.getAppName();
        final ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MobileRecoderMessagesConstants.MSG_TASK_CAPTURING_OBJECTS, -1);
                TreeMobileElement newAppRootElement = (TreeMobileElement)dialog.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        TreeMobileElement appRootElement = MobileRecorderDialog.this.inspectorController.getMobileObjectRoot();
                        appRootElement.setName(appName);
                        return appRootElement;
                    }
                });
                MobileRecorderDialog.this.checkMonitorCanceled(monitor);
                this.refreshTreeElements(dialog, newAppRootElement);
                String imgPath = this.captureImage();
                MobileRecorderDialog.this.checkMonitorCanceled(monitor);
                this.refreshDeviceView(imgPath, newAppRootElement);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MobileRecorderDialog.this.deviceView.getShell().forceActive();
                    }
                });
                MobileRecorderDialog.this.appRootElement = newAppRootElement;
                monitor.done();
            }

            private void refreshTreeElements(ProgressMonitorDialogWithThread dialog2, final TreeMobileElement newAppRootElement) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MobileRecorderDialog.this.allElementTreeViewer.setInput((Object)new Object[]{newAppRootElement});
                        MobileRecorderDialog.this.allElementTreeViewer.refresh();
                        MobileRecorderDialog.this.allElementTreeViewer.expandAll();
                    }
                });
            }

            private void refreshDeviceView(String imgPath, TreeMobileElement newAppRootElement) {
                File imgFile = new File(imgPath);
                if (imgFile.exists()) {
                    MobileRecorderDialog.this.deviceView.refreshDialog(imgFile, (MobileElement)newAppRootElement);
                }
            }

            private String captureImage() throws InvocationTargetException {
                try {
                    return MobileRecorderDialog.this.inspectorController.captureScreenshot();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.btnCapture.setEnabled(false);
                this.openDeviceView();
                dialog.run(true, false, runnable);
            }
            catch (InterruptedException interruptedException) {
                this.btnCapture.setEnabled(true);
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable exception = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MobileRecoderMessagesConstants.MSG_ERR_CANNOT_CAPTURE_OBJECTS, (String)exception.getClass().getSimpleName());
                this.btnCapture.setEnabled(true);
            }
        }
        finally {
            this.btnCapture.setEnabled(true);
        }
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(MobileRecoderMessagesConstants.MSG_ERR_OPERATION_CANCELLED);
        }
    }

    private void stopObjectInspectorAction() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (MobileRecorderDialog.this.inspectorController.getDriver() != null) {
                    MobileRecorderDialog.this.addAdditionalActions();
                    MobileRecorderDialog.this.inspectorController.closeApp();
                }
            }
        });
        thread.start();
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
            this.allElementTreeViewer.setInput((Object)new Object[0]);
            this.allElementTreeViewer.refresh();
            this.targetElementChanged(null);
            this.actionTableViewer.refresh();
        }
        if (this.deviceView != null) {
            this.deviceView.closeApp();
        }
    }

    private void addAdditionalActions() {
        MobileActionMapping lastRecordAction;
        if (this.recordedActions.isEmpty() || this.recordedActions.get(0).getAction() != MobileAction.StartApplication) {
            this.recordedActions.add(0, new MobileActionMapping(MobileAction.StartApplication, null));
        }
        if ((lastRecordAction = this.recordedActions.get(this.recordedActions.size() - 1)).getAction() != MobileAction.CloseApplication) {
            this.recordedActions.add(new MobileActionMapping(MobileAction.CloseApplication, null));
        }
    }

    private void validateToEnableStartButton() {
        if (this.cbbAppType.getSelectionIndex() < 0) {
            this.btnStart.setEnabled(false);
            return;
        }
        if (this.stackLayout.topControl == this.localAppComposite) {
            this.btnStart.setEnabled(this.localAppComposite.isAbleToStart());
        } else if (this.stackLayout.topControl == this.kobitonAppComposite) {
            this.btnStart.setEnabled(this.kobitonAppComposite.isAbleToStart());
        }
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = new Composite(contentComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(2, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar contentToolbar = new ToolBar(toolbarComposite, 0x820000);
        contentToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnCapture = new ToolItem(contentToolbar, 0);
        this.btnCapture.setImage(MobileRecorderImageConstants.IMG_24_CAPTURE);
        this.btnCapture.setDisabledImage(MobileRecorderImageConstants.IMG_24_CAPTURE_DISABLED);
        this.btnCapture.setText(MobileRecoderMessagesConstants.BTN_CAPTURE_OBJECT);
        this.btnCapture.setToolTipText(MobileRecoderMessagesConstants.BTN_TOOLTIP_CAPTURE_OBJECT);
        this.btnCapture.setEnabled(false);
        this.btnCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileRecorderDialog.this.captureObjectAction();
            }
        });
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(MobileRecorderImageConstants.IMG_24_START_DEVICE);
        this.btnStart.setDisabledImage(MobileRecorderImageConstants.IMG_24_START_DEVICE_DISABLED);
        this.btnStart.setText(MobileRecoderMessagesConstants.BTN_START);
        this.btnStart.setToolTipText(MobileRecoderMessagesConstants.BTN_TOOLTIP_START);
        this.btnStart.setEnabled(false);
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileRecorderDialog.this.validateAppSetting()) {
                    MobileRecorderDialog.this.startObjectInspectorAction();
                    MobileRecorderDialog.this.updateActionButtonsVisibility(MobileRecorderDialog.this.propertiesComposite.getEditingElement(), MobileRecorderDialog.this.getCurrentMobileDriverType());
                }
            }
        });
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(MobileRecorderImageConstants.IMG_24_STOP_DEVICE);
        this.btnStop.setDisabledImage(MobileRecorderImageConstants.IMG_24_STOP_DEVICE_DISABLED);
        this.btnStop.setText(MobileRecorderStringConstants.STOP);
        this.btnStop.setToolTipText(MobileRecorderStringConstants.STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileRecorderDialog.this.stopObjectInspectorAction();
            }
        });
    }

    private boolean validateAppSetting() {
        if (this.cbbAppType.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)MobileRecorderStringConstants.ERROR, (String)MobileRecoderMessagesConstants.MSG_ERR_NEED_APPLICATION_TYPE_SELECTED);
            return false;
        }
        if (this.stackLayout.topControl == this.localAppComposite) {
            return this.localAppComposite.validateLocalAppSetting();
        }
        if (this.stackLayout.topControl == this.kobitonAppComposite) {
            return this.kobitonAppComposite.validateKobitonAppSetting();
        }
        return false;
    }

    private void createAllObjectsComposite(Composite parentComposite) {
        Composite allObjectsComposite = new Composite(parentComposite, 0);
        allObjectsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        allObjectsComposite.setLayout((Layout)new GridLayout());
        Label lblAllObjects = new Label(allObjectsComposite, 0);
        lblAllObjects.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblAllObjects.setFont(this.getFontBold(lblAllObjects));
        lblAllObjects.setText(MobileRecoderMessagesConstants.LBL_ALL_OBJECTS);
        Composite allObjectsTreeComposite = new Composite(allObjectsComposite, 0);
        allObjectsTreeComposite.setLayoutData((Object)new GridData(1808));
        allObjectsTreeComposite.setLayout((Layout)new GridLayout(1, false));
        this.allElementTreeViewer = new CTreeViewer(allObjectsTreeComposite, 68356);
        this.allElementTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.allElementTreeViewer.setLabelProvider((IBaseLabelProvider)new MobileElementLabelProvider());
        this.allElementTreeViewer.setContentProvider((IContentProvider)new MobileElementTreeContentProvider());
        this.allElementTreeViewer.getTree().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.allElementTreeViewer, (int)2);
        this.allElementTreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TreeItem item = MobileRecorderDialog.this.allElementTreeViewer.getTree().getItem(pt);
                if (item != null) {
                    MobileElement element = (MobileElement)item.getData();
                    MobileRecorderDialog.this.highlightObject(element);
                    MobileRecorderDialog.this.targetElementChanged(element);
                }
            }
        });
        Tree tree = (Tree)this.allElementTreeViewer.getControl();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeColumn[] treeColumnArray = treeColumns;
                        int n = treeColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeColumn = treeColumnArray[n2];
                            treeColumn.pack();
                            ++n2;
                        }
                    }
                });
            }
        };
        tree.addListener(17, listener);
    }

    private void highlightObject(MobileElement selectedElement) {
        if (selectedElement == null || this.deviceView == null || this.deviceView.isDisposed()) {
            return;
        }
        this.deviceView.highlightElement(selectedElement);
    }

    private Font getFontBold(Label label) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        return boldDescriptor.createFont((Device)label.getDisplay());
    }

    public void setSelectedElementByLocation(int x, int y) {
        if (this.appRootElement == null) {
            return;
        }
        final TreeMobileElement foundElement = this.recursivelyFindElementByLocation(this.appRootElement, x, y);
        if (foundElement == null) {
            return;
        }
        this.highlightObject((MobileElement)foundElement);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MobileRecorderDialog.this.getShell().setFocus();
                MobileRecorderDialog.this.allElementTreeViewer.getTree().setFocus();
                MobileRecorderDialog.this.allElementTreeViewer.setSelection((ISelection)new StructuredSelection((Object)foundElement));
                MobileRecorderDialog.this.targetElementChanged((MobileElement)foundElement);
            }
        });
    }

    private TreeMobileElement recursivelyFindElementByLocation(TreeMobileElement currentElement, int x, int y) {
        for (TreeMobileElement childElement : currentElement.getChildrenElement()) {
            Map attributes = childElement.getAttributes();
            Double elementX = Double.parseDouble((String)attributes.get("x"));
            Double elementY = Double.parseDouble((String)attributes.get("y"));
            Double elementWidth = Double.parseDouble((String)attributes.get("width"));
            Double elementHeight = Double.parseDouble((String)attributes.get("height"));
            Rectangle rectangle = new Rectangle(MobileDeviceDialog.safeRoundDouble((double)elementX), MobileDeviceDialog.safeRoundDouble((double)elementY), MobileDeviceDialog.safeRoundDouble((double)elementWidth), MobileDeviceDialog.safeRoundDouble((double)elementHeight));
            if (!rectangle.contains(x, y)) continue;
            return this.recursivelyFindElementByLocation(childElement, x, y);
        }
        return currentElement;
    }
}

