/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.components;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecoderMessagesConstants;
import com.kms.katalon.composer.mobile.recorder.constants.MobileRecorderStringConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MobileReadonlyElementPropertiesComposite {
    private Text txtObjectName;
    private MobileElement editingElement;
    private TableViewer attributesTableViewer;

    public MobileReadonlyElementPropertiesComposite(Composite parent) {
        this.createObjectPropertiesComposite(parent);
    }

    public void setEditingElement(MobileElement editingElement) {
        this.editingElement = editingElement;
        this.refreshAttributesTable();
    }

    public MobileElement getEditingElement() {
        return this.editingElement;
    }

    private void createObjectPropertiesComposite(Composite parent) {
        Composite objectPropertiesComposite = new Composite(parent, 0);
        GridLayout glObjectPropertiesComposite = new GridLayout();
        glObjectPropertiesComposite.horizontalSpacing = 10;
        glObjectPropertiesComposite.numColumns = 2;
        objectPropertiesComposite.setLayout((Layout)glObjectPropertiesComposite);
        Label lblObjectProperties = new Label(objectPropertiesComposite, 0);
        lblObjectProperties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ControlUtils.setFontToBeBold((Control)lblObjectProperties);
        lblObjectProperties.setText(MobileRecoderMessagesConstants.LBL_OBJECT_PROPERTIES);
        Label objectNameLabel = new Label(objectPropertiesComposite, 0);
        GridData gdObjectNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdObjectNameLabel.widthHint = 90;
        objectNameLabel.setLayoutData((Object)gdObjectNameLabel);
        objectNameLabel.setText("Object Name");
        this.txtObjectName = new Text(objectPropertiesComposite, 2056);
        this.txtObjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite attributesTableComposite = new Composite(objectPropertiesComposite, 0);
        attributesTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        attributesTableComposite.setLayout((Layout)tableColumnLayout);
        this.attributesTableViewer = new CTableViewer(attributesTableComposite, 68354);
        this.createColumns(this.attributesTableViewer, tableColumnLayout);
        Table attributesTable = this.attributesTableViewer.getTable();
        attributesTable.setHeaderVisible(true);
        attributesTable.setLinesVisible(true);
        this.attributesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.attributesTableViewer.setInput(Collections.emptyList());
    }

    private void createColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn keyColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        keyColumn.getColumn().setText(MobileRecorderStringConstants.NAME);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return MobileReadonlyElementPropertiesComposite.this.getTextForEntryKey(element);
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        valueColumn.getColumn().setText(MobileRecorderStringConstants.VALUE);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return MobileReadonlyElementPropertiesComposite.this.getTextForEntryValue(element);
            }
        });
        tableColumnLayout.setColumnData((Widget)keyColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 80, true));
        tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 120, true));
    }

    private String getTextForEntryKey(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryKey = (String)entry.getKey();
        if (entryKey != null) {
            return entryKey.toString();
        }
        return "";
    }

    private String getTextForEntryValue(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryValue = (String)entry.getValue();
        if (entryValue != null) {
            return entryValue.toString();
        }
        return "";
    }

    private void refreshAttributesTable() {
        if (this.attributesTableViewer == null || this.attributesTableViewer.getTable().isDisposed()) {
            return;
        }
        if (this.editingElement != null) {
            this.txtObjectName.setText(this.editingElement.getName());
            this.attributesTableViewer.setInput(new ArrayList(this.editingElement.getAttributes().entrySet()));
        } else {
            this.txtObjectName.setText("");
            this.attributesTableViewer.setInput(Collections.emptyList());
        }
        this.attributesTableViewer.refresh();
    }

    void focusAndEditCapturedElementName() {
        this.txtObjectName.setFocus();
        this.txtObjectName.selectAll();
    }
}

