/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.components;

import com.kms.katalon.composer.mobile.recorder.actions.MobileAction;
import com.kms.katalon.composer.mobile.recorder.components.MobileActionButtonSelectionHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class MobileActionButtonWrapper {
    private Button button;
    private MobileAction mobileAction;
    private MobileActionButtonSelectionHandler selectionHandler;

    public MobileActionButtonWrapper(Composite parent, MobileAction mobileAction, MobileActionButtonSelectionHandler selectionHandler) {
        this.selectionHandler = selectionHandler;
        this.mobileAction = mobileAction;
        this.initButton(parent);
    }

    protected void initButton(Composite parent) {
        this.button = new Button(parent, 0);
        this.button.setText(this.mobileAction.getReadableName());
        this.button.setToolTipText(this.mobileAction.getDescription());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MobileActionButtonWrapper.this.selectionHandler != null) {
                    MobileActionButtonWrapper.this.selectionHandler.handleButtonClicked(event);
                }
            }
        });
    }

    public MobileAction getMobileAction() {
        return this.mobileAction;
    }

    public void enableButton() {
        this.button.setEnabled(true);
    }

    public void disableButton() {
        this.button.setEnabled(false);
    }

    public void setEnabledButton(boolean isEnabled) {
        this.button.setEnabled(isEnabled);
    }
}

