/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.actions;

import com.kms.katalon.composer.mobile.recorder.actions.IMobileAction;
import com.kms.katalon.composer.mobile.recorder.actions.MobileActionParam;
import com.kms.katalon.composer.mobile.recorder.utils.MobileActionUtil;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords;
import org.apache.commons.lang3.StringUtils;

public enum MobileAction implements IMobileAction
{
    Tap("tap", "Tap on the given element"),
    TapAndHold("tapAndHold", "Tap and hold on the given element"),
    SetText("setText", "Set text to the given element"),
    ClearText("clearText", "Clear text on the given element"),
    HideKeyboard("hideKeyboard", "Hide the on-screen keyboard"),
    PressBack("pressBack", "Press back button on the mobile device (Android only)", MobileDriverType.ANDROID_DRIVER),
    SwitchToLandscape("switchToLandscape", "Switch the mobile device's orientation to landscape mode"),
    SwitchToPortrait("switchToPortrait", "Switch the mobile device's orientation to portrait mode"),
    StartApplication("startApplication", "Start the application", false),
    CloseApplication("closeApplication", "Close the application", false);

    private String description;
    private String mappedKeywordClassName;
    private String mappedKeywordClassSimpleName;
    private String mappedKeywordMethod;
    protected MobileActionParam[] params;
    private boolean hasElement = false;
    private boolean isUserInputAction = true;
    private MobileDriverType supportedDriverType = null;

    private MobileAction(String mappedKeywordMethod) {
        this(mappedKeywordMethod, "");
    }

    private MobileAction(String mappedKeywordMethod, String description) {
        this(MobileBuiltInKeywords.class.getName(), MobileBuiltInKeywords.class.getSimpleName(), mappedKeywordMethod, description, true, null);
    }

    private MobileAction(String mappedKeywordMethod, String description, boolean isUserInputAction) {
        this(MobileBuiltInKeywords.class.getName(), MobileBuiltInKeywords.class.getSimpleName(), mappedKeywordMethod, description, isUserInputAction, null);
    }

    private MobileAction(String mappedKeywordMethod, String description, MobileDriverType supportedDriverType) {
        this(MobileBuiltInKeywords.class.getName(), MobileBuiltInKeywords.class.getSimpleName(), mappedKeywordMethod, description, true, supportedDriverType);
    }

    private MobileAction(String mappedKeywordClassName, String mappedKeywordSimpleName, String mappedKeywordMethod, String description, boolean isUserInputAction, MobileDriverType supportedDriverType) {
        this.mappedKeywordClassName = mappedKeywordClassName;
        this.mappedKeywordClassSimpleName = mappedKeywordSimpleName;
        this.mappedKeywordMethod = mappedKeywordMethod;
        this.description = description;
        this.isUserInputAction = isUserInputAction;
        this.supportedDriverType = supportedDriverType;
        this.params = MobileActionUtil.collectKeywordParam(mappedKeywordClassName, mappedKeywordMethod);
        this.hasElement = MobileActionUtil.hasElement(mappedKeywordClassName, mappedKeywordMethod);
    }

    @Override
    public String getMappedKeywordClassName() {
        return this.mappedKeywordClassName;
    }

    @Override
    public String getMappedKeywordClassSimpleName() {
        return this.mappedKeywordClassSimpleName;
    }

    @Override
    public String getMappedKeywordMethod() {
        return this.mappedKeywordMethod;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean hasElement() {
        return this.hasElement;
    }

    @Override
    public boolean hasInput() {
        return this.params != null && this.params.length > 0;
    }

    public boolean isUserInputAction() {
        return this.isUserInputAction;
    }

    public boolean isDriverTypeSupported(MobileDriverType driverType) {
        if (this.supportedDriverType == null) {
            return true;
        }
        return this.supportedDriverType == driverType;
    }

    @Override
    public MobileActionParam[] getParams() {
        return this.params;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getReadableName() {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)StringUtils.capitalize((String)this.getName())), (String)" ");
    }
}

