/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.collect.ImmutableList;
import io.appium.java_client.HasSessionDetails;
import io.appium.java_client.MobileElement;
import io.appium.java_client.android.AndroidElement;
import io.appium.java_client.internal.ElementMap;
import io.appium.java_client.ios.IOSElement;
import io.appium.java_client.pagefactory.AppiumElementLocatorFactory;
import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import io.appium.java_client.pagefactory.ElementInterceptor;
import io.appium.java_client.pagefactory.ElementListInterceptor;
import io.appium.java_client.pagefactory.OverrideWidgetReader;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.WidgetByBuilder;
import io.appium.java_client.pagefactory.WidgetConstructorUtil;
import io.appium.java_client.pagefactory.WidgetInterceptor;
import io.appium.java_client.pagefactory.WidgetListInterceptor;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.ProxyFactory;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import io.appium.java_client.windows.WindowsElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class AppiumFieldDecorator
implements FieldDecorator {
    private static final List<Class<? extends WebElement>> availableElementClasses = ImmutableList.of(WebElement.class, RemoteWebElement.class, MobileElement.class, AndroidElement.class, IOSElement.class, WindowsElement.class);
    public static long DEFAULT_TIMEOUT = 1L;
    public static TimeUnit DEFAULT_TIMEUNIT = TimeUnit.SECONDS;
    private final WebDriver originalDriver;
    private final DefaultFieldDecorator defaultElementFieldDecoracor;
    private final AppiumElementLocatorFactory widgetLocatorFactory;
    private final String platform;
    private final String automation;
    private final TimeOutDuration duration;
    private final HasSessionDetails hasSessionDetails;

    public AppiumFieldDecorator(SearchContext context, long timeout, TimeUnit timeUnit) {
        this(context, new TimeOutDuration(timeout, timeUnit));
    }

    public AppiumFieldDecorator(SearchContext context, TimeOutDuration duration) {
        this.originalDriver = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(context);
        if (this.originalDriver == null || !HasSessionDetails.class.isAssignableFrom(this.originalDriver.getClass())) {
            this.hasSessionDetails = null;
            this.platform = null;
            this.automation = null;
        } else {
            this.hasSessionDetails = (HasSessionDetails)HasSessionDetails.class.cast(this.originalDriver);
            this.platform = this.hasSessionDetails.getPlatformName();
            this.automation = this.hasSessionDetails.getAutomationName();
        }
        this.duration = duration;
        this.defaultElementFieldDecoracor = new DefaultFieldDecorator(new AppiumElementLocatorFactory(context, duration, new DefaultElementByBuilder(this.platform, this.automation))){

            protected WebElement proxyForLocator(ClassLoader ignored, ElementLocator locator) {
                return AppiumFieldDecorator.this.proxyForAnElement(locator);
            }

            protected List<WebElement> proxyForListLocator(ClassLoader ignored, ElementLocator locator) {
                ElementListInterceptor elementInterceptor = new ElementListInterceptor(locator);
                return ProxyFactory.getEnhancedProxy(ArrayList.class, elementInterceptor);
            }

            protected boolean isDecoratableList(Field field) {
                if (!List.class.isAssignableFrom(field.getType())) {
                    return false;
                }
                Type genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType)) {
                    return false;
                }
                Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                for (Class webElementClass : availableElementClasses) {
                    if (!webElementClass.equals(listType)) continue;
                    return true;
                }
                return false;
            }
        };
        this.widgetLocatorFactory = new AppiumElementLocatorFactory(context, duration, new WidgetByBuilder(this.platform, this.automation));
    }

    public AppiumFieldDecorator(SearchContext context) {
        this(context, DEFAULT_TIMEOUT, DEFAULT_TIMEUNIT);
    }

    public Object decorate(ClassLoader ignored, Field field) {
        Object result = this.defaultElementFieldDecoracor.decorate(ignored, field);
        if (result != null) {
            return result;
        }
        return this.decorateWidget(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object decorateWidget(Field field) {
        Class widgetType;
        Class<?> type = field.getType();
        if (!Widget.class.isAssignableFrom(type) && !List.class.isAssignableFrom(type)) {
            return null;
        }
        boolean isAlist = false;
        if (List.class.isAssignableFrom(type)) {
            isAlist = true;
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                return null;
            }
            Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (ParameterizedType.class.isAssignableFrom(listType.getClass())) {
                listType = ((ParameterizedType)listType).getRawType();
            }
            if (!(listType instanceof Class)) return null;
            if (!Widget.class.isAssignableFrom((Class)listType)) {
                return null;
            }
            widgetType = (Class)Class.class.cast(listType);
        } else {
            widgetType = field.getType();
        }
        CacheableLocator locator = this.widgetLocatorFactory.createLocator(field);
        Map<ContentType, Constructor<? extends Widget>> map = OverrideWidgetReader.read(widgetType, field, this.platform, this.automation);
        if (isAlist) {
            return ProxyFactory.getEnhancedProxy(ArrayList.class, new WidgetListInterceptor(locator, this.originalDriver, map, widgetType, this.duration));
        }
        Constructor<? extends Widget> constructor = WidgetConstructorUtil.findConvenientConstructor(widgetType);
        return ProxyFactory.getEnhancedProxy(widgetType, new Class[]{constructor.getParameterTypes()[0]}, new Object[]{this.proxyForAnElement(locator)}, new WidgetInterceptor(locator, this.originalDriver, null, map, this.duration));
    }

    private WebElement proxyForAnElement(ElementLocator locator) {
        ElementInterceptor elementInterceptor = new ElementInterceptor(locator, this.originalDriver);
        return (WebElement)ProxyFactory.getEnhancedProxy(ElementMap.getElementClass(this.hasSessionDetails), elementInterceptor);
    }
}

