/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReportController
extends EntityController {
    private static EntityController _instance;
    public static String LOG_FILE_NAME;
    public static String EXECUTION_SETTING_FILE_NAME;
    private static DateFormat dateFormat;
    private static Set<String> REPORT_SUB_FOLDER_NAMES;

    static {
        LOG_FILE_NAME = "execution0.log";
        EXECUTION_SETTING_FILE_NAME = "execution.properties";
        dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        REPORT_SUB_FOLDER_NAMES = Collections.synchronizedSet(new HashSet());
    }

    private ReportController() {
    }

    public static ReportController getInstance() {
        if (_instance == null) {
            _instance = new ReportController();
        }
        return (ReportController)_instance;
    }

    public String getTestCaseLogFolder(TestCaseEntity testCase) throws DALException {
        return ReportController.getDataProviderSetting().getReportDataProvider().getTemporaryLogDirectory((FileEntity)testCase);
    }

    public String generateReportFolder(TestSuiteEntity testSuite) throws Exception {
        String testSuiteRootLogFolder = ReportController.getDataProviderSetting().getReportDataProvider().getLogDirectory(testSuite);
        return this.generateReportFolder(testSuiteRootLogFolder);
    }

    public String generateTemporaryExecutionFolder(FileEntity testCase) throws DALException, InterruptedException {
        String testCaseRootLogFolder = ReportController.getDataProviderSetting().getReportDataProvider().getTemporaryLogDirectory(testCase);
        return this.generateReportFolder(testCaseRootLogFolder);
    }

    private String generateReportFolder(String reportRootFolderPath) throws InterruptedException {
        long current = Calendar.getInstance().getTimeInMillis();
        File reportFolderAtRuntime = new File(reportRootFolderPath, this.getReportSubFolderName());
        while (reportFolderAtRuntime.exists() && Calendar.getInstance().getTimeInMillis() - current < 30000L) {
            Thread.sleep(1000L);
            reportFolderAtRuntime = new File(reportRootFolderPath, this.getReportSubFolderName());
        }
        reportFolderAtRuntime.mkdir();
        return reportFolderAtRuntime.getAbsolutePath();
    }

    private synchronized String getReportSubFolderName() throws InterruptedException {
        long current = Calendar.getInstance().getTimeInMillis();
        String name = dateFormat.format(new Date());
        while (REPORT_SUB_FOLDER_NAMES.contains(name) && Calendar.getInstance().getTimeInMillis() - current < 30000L) {
            Thread.sleep(1000L);
            name = dateFormat.format(new Date());
        }
        REPORT_SUB_FOLDER_NAMES.add(name);
        return name;
    }

    public File getLogFile(TestCaseEntity testCase, String reportFolderName) throws Exception {
        String testCaseRootLogFolder = ReportController.getDataProviderSetting().getReportDataProvider().getTemporaryLogDirectory((FileEntity)testCase);
        File testCaseReportFolderAtRuntime = new File(testCaseRootLogFolder, reportFolderName);
        return new File(testCaseReportFolderAtRuntime, LOG_FILE_NAME);
    }

    public File getLogFile(TestSuiteEntity testSuite, String reportFolderName) throws Exception {
        String testSuiteRootLogFolder = ReportController.getDataProviderSetting().getReportDataProvider().getLogDirectory(testSuite);
        File testSuiteReportFolderAtRuntime = new File(testSuiteRootLogFolder, reportFolderName);
        return new File(testSuiteReportFolderAtRuntime, LOG_FILE_NAME);
    }

    public File getExecutionSettingFile(TestCaseEntity testCase, String reportFolderName) throws Exception {
        String testCaseRootLogFolder = ReportController.getDataProviderSetting().getReportDataProvider().getTemporaryLogDirectory((FileEntity)testCase);
        File testCaseReportFolderAtRuntime = new File(testCaseRootLogFolder, reportFolderName);
        return new File(testCaseReportFolderAtRuntime, EXECUTION_SETTING_FILE_NAME);
    }

    public File getExecutionSettingFile(TestSuiteEntity testSuite, String reportFolderName) throws Exception {
        String testSuiteRootLogFolder = ReportController.getDataProviderSetting().getReportDataProvider().getLogDirectory(testSuite);
        File testSuiteReportFolderAtRuntime = new File(testSuiteRootLogFolder, reportFolderName);
        return new File(testSuiteReportFolderAtRuntime, EXECUTION_SETTING_FILE_NAME);
    }

    public File getExecutionSettingFile(String logFolderPath) {
        return new File(logFolderPath, EXECUTION_SETTING_FILE_NAME);
    }

    public Date getDateFromReportFolderName(String reportFolderName) throws ParseException {
        return dateFormat.parse(reportFolderName);
    }

    public ReportEntity getReportEntity(TestSuiteEntity testSuite, String reportName) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return ReportController.getDataProviderSetting().getReportDataProvider().getReportEntity(project, testSuite, reportName);
    }

    public ReportEntity getLastRunReportEntity(TestSuiteEntity testSuite) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        ReportEntity lastRunReport = null;
        List<ReportEntity> reports = this.listReportEntities(testSuite, project);
        if (reports.size() > 0) {
            lastRunReport = reports.get(0);
            Date lastRunDate = this.parseReportDateFromName(lastRunReport.getName());
            for (ReportEntity report : reports) {
                String reportName = report.getName();
                Date reportDate = this.parseReportDateFromName(reportName);
                if (!reportDate.after(lastRunDate)) continue;
                lastRunDate = reportDate;
                lastRunReport = report;
            }
        }
        return lastRunReport;
    }

    private Date parseReportDateFromName(String reportName) throws ParseException {
        return dateFormat.parse(reportName);
    }

    public Date getReportDate(ReportEntity report) throws Exception {
        return this.parseReportDateFromName(report.getName());
    }

    public void deleteReport(ReportEntity report) throws Exception {
        ReportController.getDataProviderSetting().getReportDataProvider().deleteReport(report);
    }

    public ReportEntity getReportEntity(String reportPk) throws Exception {
        return ReportController.getDataProviderSetting().getReportDataProvider().getReportEntity(reportPk);
    }

    public ReportEntity getReportEntityByDisplayId(String reportDisplayId, ProjectEntity projectEntity) throws ControllerException {
        try {
            String reportPk = String.valueOf(projectEntity.getFolderLocation()) + File.separator + reportDisplayId;
            return ReportController.getDataProviderSetting().getReportDataProvider().getReportEntity(reportPk);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public ReportEntity updateReport(ReportEntity report) throws ControllerException {
        try {
            return ReportController.getDataProviderSetting().getReportDataProvider().updateReport(report);
        }
        catch (Exception e) {
            throw new ControllerException(e.getMessage());
        }
    }

    public TestSuiteEntity getTestSuiteByReport(ReportEntity report) throws Exception {
        if (report == null || report.getParentFolder() == null) {
            return null;
        }
        return this.getTestSuiteByReportParentFolder(report.getParentFolder());
    }

    public List<ReportEntity> listReportEntities(TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) throws Exception {
        return ReportController.getDataProviderSetting().getReportDataProvider().listReportEntities(testSuiteEntity, projectEntity);
    }

    public FolderEntity getReportFolder(TestSuiteEntity testSuiteEntity, ProjectEntity projectEntity) throws Exception {
        return ReportController.getDataProviderSetting().getReportDataProvider().getReportFolder(testSuiteEntity, projectEntity);
    }

    public String getTestSuiteFolderId(String reportFolderId) {
        if (reportFolderId == null) {
            return null;
        }
        return reportFolderId.replaceFirst("Reports", "Test Suites");
    }

    public TestSuiteEntity getTestSuiteByReportParentFolder(FolderEntity parentReportFolder) throws Exception {
        String testSuiteDisplayId = parentReportFolder.getIdForDisplay().replaceFirst("Reports", "Test Suites");
        return TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteDisplayId, parentReportFolder.getProject());
    }

    public ReportEntity reloadReport(ReportEntity report, Entity entity) throws Exception {
        return this.getReportEntity(entity.getId());
    }

    public ReportCollectionEntity newReportCollection(ProjectEntity projectEntity, TestSuiteCollectionEntity entity, String newName) throws DALException {
        return ReportController.getDataProviderSetting().getReportDataProvider().newReportCollectionEntity(projectEntity, entity, newName);
    }

    public void updateReportCollection(ReportCollectionEntity reportCollection) throws DALException {
        ReportController.getDataProviderSetting().getReportDataProvider().updateReportCollectionEntity(reportCollection);
    }

    public void deleteReportCollection(ReportCollectionEntity reportCollection) throws DALException {
        ReportController.getDataProviderSetting().getReportDataProvider().deleteReportCollection(reportCollection);
    }

    public ReportCollectionEntity getReportCollection(String id) throws DALException {
        return ReportController.getDataProviderSetting().getReportDataProvider().getReportCollectionEntity(id);
    }

    public ReportEntity renameReport(ReportEntity report, String newName) throws DALException {
        return ReportController.getDataProviderSetting().getReportDataProvider().renameReport(report, newName);
    }

    public ReportCollectionEntity renameReportCollection(ReportCollectionEntity collectionReport, String newName) throws DALException {
        return ReportController.getDataProviderSetting().getReportDataProvider().renameCollectionReport(collectionReport, newName);
    }
}

