/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.CustomKeywordPluginFactory;
import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.custom.factory.CustomMethodNodeFactory;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ProjectController
extends EntityController {
    private static final short DEFAULT_PAGELOAD_TIMEOUT = 30;
    private static EntityController _instance;
    private static final String RECENT_PROJECT_FILE_LOCATION;
    public static final int NUMBER_OF_RECENT_PROJECTS = 6;

    static {
        RECENT_PROJECT_FILE_LOCATION = String.valueOf(Platform.getLocation().toString()) + File.separator + "recent_projects";
    }

    private ProjectController() {
    }

    public static ProjectController getInstance() {
        if (_instance == null) {
            _instance = new ProjectController();
        }
        return (ProjectController)_instance;
    }

    public ProjectEntity addNewProject(String name, String description, String projectLocation) throws Exception {
        ProjectEntity newProject = ProjectController.getDataProviderSetting().getProjectDataProvider().addNewProject(name, description, (short)30, projectLocation);
        this.addRecentProject(newProject);
        return newProject;
    }

    public ProjectEntity openProjectForUI(String projectPk, IProgressMonitor monitor) throws Exception {
        try {
            ProjectEntity project;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((project = ProjectController.getDataProviderSetting().getProjectDataProvider().openProjectWithoutClasspath(projectPk)) != null) {
                monitor.beginTask("Initialzing project's working space...", 10);
                if (project.getUUID() == null) {
                    project.setUUID(Util.generateGuid());
                    this.updateProject(project);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                DataProviderState.getInstance().setCurrentProject(project);
                GroovyUtil.initGroovyProject((ProjectEntity)project, ProjectController.getInstance().getCustomKeywordPlugins(project), (IProgressMonitor)progress.newChild(40, 1));
                this.addRecentProject(project);
                GlobalVariableController.getInstance().generateGlobalVariableLibFile(project, (IProgressMonitor)progress.newChild(20, 1));
                KeywordController.getInstance().parseAllCustomKeywords(project, (IProgressMonitor)progress.newChild(40, 1));
            }
            ProjectEntity projectEntity = project;
            return projectEntity;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void cleanProjectUISettings(ProjectEntity projectEntity) throws CoreException {
        CustomMethodNodeFactory.getInstance().reset();
        GroovyUtil.emptyProjectClasspath((ProjectEntity)projectEntity);
    }

    public ProjectEntity openProject(String projectPk) throws Exception {
        LogUtil.printOutputLine((String)("Opening project file: " + projectPk));
        ProjectEntity project = ProjectController.getDataProviderSetting().getProjectDataProvider().openProjectWithoutClasspath(projectPk);
        if (project != null) {
            DataProviderState.getInstance().setCurrentProject(project);
            GroovyUtil.initGroovyProject((ProjectEntity)project, ProjectController.getInstance().getCustomKeywordPlugins(project), null);
            this.addRecentProject(project);
            LogUtil.printOutputLine((String)"Generating global variables...");
            GlobalVariableController.getInstance().generateGlobalVariableLibFile(project, null);
            LogUtil.printOutputLine((String)"Parsing custom keywords...");
            KeywordController.getInstance().parseAllCustomKeywords(project, null);
            LogUtil.printOutputLine((String)MessageFormat.format("Project ''{0}'' opened", project.getName()));
        }
        return project;
    }

    public void closeProject(String projectPk, IProgressMonitor monitor) throws Exception {
        ProjectEntity project = ProjectController.getDataProviderSetting().getProjectDataProvider().openProjectWithoutClasspath(projectPk);
        if (project != null) {
            IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
            groovyProject.clearHistory(monitor);
            groovyProject.close(monitor);
        }
        DataProviderState.getInstance().setCurrentProject(null);
    }

    public void updateProject(String name, String description, String projectPk) throws Exception {
        ProjectEntity project = ProjectController.getDataProviderSetting().getProjectDataProvider().updateProject(name, description, projectPk, (short)0);
        if (project != null) {
            this.addRecentProject(project);
            this.validateRecentProjects(this.getRecentProjects());
        }
    }

    public void updateProject(ProjectEntity projectEntity) throws Exception {
        ProjectController.getDataProviderSetting().getProjectDataProvider().updateProject(projectEntity);
    }

    public void addRecentProject(ProjectEntity project) throws Exception {
        List<ProjectEntity> recentProjects = this.getRecentProjects();
        int existedProjectIndex = -1;
        int i = 0;
        while (i < recentProjects.size()) {
            if (ProjectController.getDataProviderSetting().getEntityPk((Entity)project).equals(ProjectController.getDataProviderSetting().getEntityPk((Entity)recentProjects.get(i)))) {
                existedProjectIndex = i;
                break;
            }
            ++i;
        }
        if (existedProjectIndex > -1 && existedProjectIndex < recentProjects.size()) {
            project.setRecentExpandedTreeEntityIds(recentProjects.get(existedProjectIndex).getRecentExpandedTreeEntityIds());
            project.setRecentOpenedTreeEntityIds(recentProjects.get(existedProjectIndex).getRecentOpenedTreeEntityIds());
            recentProjects.remove(existedProjectIndex);
        }
        recentProjects.add(0, project);
        if (recentProjects.size() > 6) {
            recentProjects = recentProjects.subList(0, 6);
        }
        this.saveRecentProjects(new ArrayList<ProjectEntity>(recentProjects));
    }

    private List<ProjectEntity> validateRecentProjects(List<ProjectEntity> recentProjects) throws Exception {
        if (recentProjects != null) {
            ArrayList<ProjectEntity> resultList = new ArrayList<ProjectEntity>();
            for (ProjectEntity recentProject : recentProjects) {
                ProjectEntity project;
                if (recentProject == null) continue;
                File projectFolder = new File(recentProject.getFolderLocation());
                File projectFile = new File(recentProject.getLocation());
                if (!projectFolder.exists() || !projectFolder.isDirectory() || !projectFile.exists() || !projectFile.isFile() || !(project = ProjectController.getDataProviderSetting().getProjectDataProvider().getProject(projectFile.getAbsolutePath())).getName().equals(recentProject.getName())) continue;
                resultList.add(recentProject);
            }
            if (resultList.size() != recentProjects.size()) {
                this.saveRecentProjects(resultList);
            }
            return resultList;
        }
        return new ArrayList<ProjectEntity>();
    }

    public List<ProjectEntity> getRecentProjects() throws Exception {
        List projects;
        block8: {
            ObjectInputStream inputStream = null;
            projects = null;
            try {
                inputStream = new ObjectInputStream(new FileInputStream(RECENT_PROJECT_FILE_LOCATION));
                projects = (List)inputStream.readObject();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block8;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
            }
            if (inputStream == null) break block8;
            inputStream.close();
        }
        return this.validateRecentProjects(projects);
    }

    public void saveRecentProjects(List<ProjectEntity> recentProjects) throws Exception {
        try (ObjectOutputStream outputStream = null;){
            outputStream = new ObjectOutputStream(new FileOutputStream(RECENT_PROJECT_FILE_LOCATION));
            outputStream.writeObject(recentProjects);
        }
    }

    public ProjectEntity getCurrentProject() {
        return DataProviderState.getInstance().getCurrentProject();
    }

    public boolean validateNewProjectName(String projectParentFolderName, String projectName) throws Exception {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().isDuplicationProjectName(projectName, projectParentFolderName) == false;
    }

    public String getTempDir() {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().getSystemTempFolder();
    }

    public String getWebServiceTempDir() {
        return String.valueOf(this.getTempDir()) + File.separator + "Web Services";
    }

    public String getNonremovableTempDir() {
        return new File(ProjectController.getDataProviderSetting().getProjectDataProvider().getSystemTempFolder(), "non-removable").getAbsolutePath();
    }

    public String getInternalSettingDir() {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().getInternalSettingFolder();
    }

    public void clearWorkingStateOfRecentProjects() {
        try {
            List<ProjectEntity> recentProjects = this.getRecentProjects();
            if (recentProjects == null || recentProjects.isEmpty()) {
                return;
            }
            for (ProjectEntity project : recentProjects) {
                project.setRecentExpandedTreeEntityIds(null);
                project.setRecentOpenedTreeEntityIds(null);
            }
            this.saveRecentProjects(recentProjects);
        }
        catch (Exception exception) {}
    }

    public void keepStateOfExpandedTreeEntities(List<String> expandedTreeEntityIds) throws Exception {
        if (this.getCurrentProject() == null) {
            return;
        }
        List<ProjectEntity> recentProjects = this.getRecentProjects();
        if (recentProjects == null || recentProjects.isEmpty()) {
            return;
        }
        recentProjects.get(0).setRecentExpandedTreeEntityIds(expandedTreeEntityIds);
        this.saveRecentProjects(recentProjects);
    }

    public void keepStateOfOpenedEntities(List<String> openedEntityIds) throws Exception {
        if (this.getCurrentProject() == null) {
            return;
        }
        List<ProjectEntity> recentProjects = this.getRecentProjects();
        if (recentProjects == null || recentProjects.isEmpty()) {
            return;
        }
        recentProjects.get(0).setRecentOpenedTreeEntityIds(openedEntityIds);
        this.saveRecentProjects(recentProjects);
    }

    public File getProjectFile(String folderLocation) {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().getProjectFile(folderLocation);
    }

    public ProjectEntity newProjectEntity(String name, String description, String location, boolean legacy) throws DALException {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().newProjectEntity(name, description, location, legacy);
    }

    public ProjectEntity updateProjectInfo(File projectFile, ProjectEntity newInfo) throws DALException {
        return ProjectController.getDataProviderSetting().getProjectDataProvider().updateProjectEntity(projectFile, newInfo);
    }

    public ProjectEntity getProject(String projectFileLocation) throws ControllerException {
        try {
            return ProjectController.getDataProviderSetting().getProjectDataProvider().getProject(projectFileLocation);
        }
        catch (DALException e) {
            throw new ControllerException(e);
        }
    }

    public List<File> getCustomKeywordPlugins(ProjectEntity project) throws ControllerException {
        return CustomKeywordPluginFactory.getInstance().getPluginFiles();
    }
}

