/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.custom.factory.BuiltInMethodNodeFactory;
import com.kms.katalon.custom.factory.CustomMethodNodeFactory;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.parser.CustomKeywordParser;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;

public class KeywordController
extends EntityController {
    private static EntityController _instance;

    private KeywordController() {
    }

    public static KeywordController getInstance() {
        if (_instance == null) {
            _instance = new KeywordController();
        }
        return (KeywordController)_instance;
    }

    public List<KeywordClass> getBuiltInKeywordClasses() {
        return BuiltInMethodNodeFactory.getKeywordClasses();
    }

    public KeywordClass getBuiltInKeywordClassByName(String builtInKeywordClassName) {
        return BuiltInMethodNodeFactory.findClass((String)builtInKeywordClassName);
    }

    public boolean isCustomKeywordClass(String className) {
        if (className == null || className.isEmpty()) {
            return false;
        }
        return CustomMethodNodeFactory.getInstance().isCustomKeywordClass(className);
    }

    public boolean isBuiltinKeywordClassName(String className) {
        if (className == null || className.isEmpty()) {
            return false;
        }
        return BuiltInMethodNodeFactory.findClass((String)className) != null;
    }

    public KeywordMethod getBuiltInKeywordByName(String className, String keywordName, String[] paramTypes) {
        return BuiltInMethodNodeFactory.findMethod((String)className, (String)keywordName, (String[])paramTypes);
    }

    public KeywordMethod getBuiltInKeywordByName(KeywordClass keywordClass, String keywordName) {
        return BuiltInMethodNodeFactory.findMethod((String)keywordClass.getType().getName(), (String)keywordName, null);
    }

    public KeywordMethod getBuiltInKeywordByName(String className, String keywordName) {
        return BuiltInMethodNodeFactory.findMethod((String)className, (String)keywordName, null);
    }

    public List<KeywordMethod> getBuiltInKeywords(String builtInKeywordClassName) {
        return BuiltInMethodNodeFactory.getFilteredMethods((String)builtInKeywordClassName);
    }

    public List<KeywordMethod> getBuiltInKeywords(String builtInKeywordClassName, boolean excludeFlowControl) {
        return BuiltInMethodNodeFactory.getFilteredMethods((String)builtInKeywordClassName, (boolean)excludeFlowControl);
    }

    public List<MethodNode> getCustomKeywords(ProjectEntity project) {
        return CustomKeywordParser.getInstance().getAllMethodNodes(GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project));
    }

    public MethodNode getCustomKeywordByName(String className, String methodName, ProjectEntity project) {
        List<MethodNode> methodNodes = this.getCustomKeywords(project);
        if (methodNodes != null && methodNodes.size() > 0) {
            for (MethodNode methodNode : methodNodes) {
                if (!methodNode.getDeclaringClass().getNameWithoutPackage().equals(className) && !methodNode.getDeclaringClass().getName().equals(className) || !methodNode.getName().equals(this.getRawCustomKeywordName(methodName))) continue;
                return methodNode;
            }
        }
        return null;
    }

    public String getRawCustomKeywordName(String customKeywordName) {
        return customKeywordName.replace("'", "").replace("\"", "");
    }

    public String getCustomKeywordName(String customKeywordName) {
        if (!customKeywordName.startsWith("'") && !customKeywordName.startsWith("\"")) {
            return "'" + customKeywordName + "'";
        }
        return customKeywordName;
    }

    public void parseAllCustomKeywordsWithoutRefreshing(ProjectEntity project) throws Exception {
        IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)project);
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        CustomKeywordParser.getInstance().parseAllCustomKeywords(srcFolder, libFolder);
    }

    public void parseAllCustomKeywords(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        try {
            if (monitor != null) {
                monitor.beginTask("Parsing custom keywords...", 1);
            }
            IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)project);
            IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
            CustomKeywordParser.getInstance().parseAllCustomKeywords(srcFolder, libFolder);
            this.parseCustomKeywordInPluginDirectory(project, libFolder);
            URLClassLoader projectClassLoader = GroovyUtil.getProjectClasLoader((ProjectEntity)project);
            CustomKeywordParser.getInstance().parsePluginKeywords((ClassLoader)projectClassLoader, ProjectController.getInstance().getCustomKeywordPlugins(project), libFolder);
            this.refreshCustomKeywordLibFile(project, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void parseCustomKeywordInPluginDirectory(ProjectEntity project, IFolder libFolder) throws Exception {
        IFolder pluginFolder = GroovyUtil.getPluginsFolder((ProjectEntity)project);
        URLClassLoader projectClassLoader = GroovyUtil.getProjectClasLoader((ProjectEntity)project);
        File pluginDir = pluginFolder.getRawLocation().toFile();
        File[] jarFiles = pluginDir.listFiles();
        File firstJar = Arrays.asList(jarFiles).stream().filter(f -> f.getName().endsWith(".jar")).findFirst().orElse(null);
        if (firstJar != null) {
            CustomKeywordParser.getInstance().parsePluginKeywords((ClassLoader)projectClassLoader, Arrays.asList(firstJar), libFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseCustomKeywordFile(IFile file, ProjectEntity project) throws Exception {
        IFile iFile = file;
        synchronized (iFile) {
            IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
            CustomKeywordParser.getInstance().parseCustomKeywordFile(file, libFolder, true);
            this.refreshCustomKeywordLibFile(project, null);
        }
    }

    public void removeMethodNodesCustomKeywordFile(IFile file, ProjectEntity project) throws Exception {
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        CustomKeywordParser.getInstance().removeMethodNodesCustomKeywordFile(file, libFolder);
        this.refreshCustomKeywordLibFile(project, null);
    }

    public void parseCustomKeywordInPackage(IPackageFragment packageFragment, ProjectEntity project) throws Exception {
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        CustomKeywordParser.getInstance().parseCustomKeywordInPackage(GroovyUtil.getAllGroovyClasses((IPackageFragment)packageFragment), libFolder);
        this.refreshCustomKeywordLibFile(project, null);
    }

    private void refreshCustomKeywordLibFile(ProjectEntity project, IProgressMonitor monitor) throws Exception {
        GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project).refreshLocal(1, monitor);
    }
}

