/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.constants.ControllerMessageConstants;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.dal.exception.DALException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.javalite.http.Get;
import org.javalite.http.Http;
import org.javalite.http.Post;
import org.javalite.http.Request;

public class HttpRequestController {
    private static HttpRequestController instance;

    public static HttpRequestController getInstance() {
        if (instance == null) {
            instance = new HttpRequestController();
        }
        return instance;
    }

    public Get get(String url) throws DALException {
        return this.get(url, null);
    }

    public Get get(String url, HashMap<String, String> headers) throws DALException {
        if (StringUtils.isBlank((String)url)) {
            throw new DALException(ControllerMessageConstants.CTRL_EXC_REQUEST_URL_IS_BLANK);
        }
        try {
            Get get = Http.get((String)url);
            this.addHeaders((Request<?>)get, headers);
            return get;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public Post post(String url, String body) throws DALException {
        return this.post(url, body, null);
    }

    public Post post(String url, String body, HashMap<String, String> headers) throws DALException {
        if (StringUtils.isBlank((String)url)) {
            throw new DALException(ControllerMessageConstants.CTRL_EXC_REQUEST_URL_IS_BLANK);
        }
        if (StringUtils.isBlank((String)body)) {
            throw new DALException(ControllerMessageConstants.CTRL_EXC_REQUEST_BODY_IS_BLANK);
        }
        try {
            Post post = Http.post((String)url, (String)body);
            this.addHeaders((Request<?>)post, headers);
            return post;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    private void addHeaders(Request<?> request, HashMap<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        headers.putIfAbsent("User-Agent", String.valueOf(StringConstants.APP_NAME) + " " + System.getProperty("katalon.versionNumber", StringConstants.EMPTY));
        headers.forEach((name, value) -> {
            Request request2 = request.header(name, value);
        });
    }
}

