/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.entity.file.FileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FilterController {
    private static final List<String> DEFAULT_KEYWORDS = Arrays.asList("ids", "id", "name", "tag", "comment", "description");
    private static final List<String> DEFAULT_KEYWORDS_FOR_INPUTS = Arrays.asList("id", "name", "tag", "comment", "description");
    private static final String CONTENT_DELIMITER = ",";
    private static FilterController instance;

    public static FilterController getInstance() {
        if (instance == null) {
            instance = new FilterController();
        }
        return instance;
    }

    private FilterController() {
    }

    public List<String> getDefaultKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.addAll(DEFAULT_KEYWORDS);
        return keywords;
    }

    public List<String> getDefaultKeywordsForInputs() {
        ArrayList<String> keywordsForInputs = new ArrayList<String>();
        keywordsForInputs.addAll(DEFAULT_KEYWORDS_FOR_INPUTS);
        return keywordsForInputs;
    }

    public boolean isMatched(FileEntity fileEntity, String filteringText) {
        String trimmedText = filteringText.trim();
        if (trimmedText.equals("")) {
            return true;
        }
        List<String> keywordList = this.getDefaultKeywords();
        Map<String, String> tagMap = this.parseSearchedString(keywordList.toArray(new String[0]), trimmedText);
        if (!tagMap.isEmpty()) {
            for (Map.Entry<String, String> entry : tagMap.entrySet()) {
                String keyword = entry.getKey();
                if (!keywordList.contains(keyword) || this.compare(fileEntity, keyword, entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public <T extends FileEntity> List<T> filter(List<T> entities, String filteringText) {
        return entities.stream().filter(e -> this.isMatched((FileEntity)e, filteringText)).collect(Collectors.toList());
    }

    public Map<String, String> parseSearchedString(String[] searchTags, String contentString) {
        if (searchTags != null) {
            HashMap<String, String> tagMap = new HashMap<String, String>();
            int i = 0;
            while (i < searchTags.length) {
                String tagRegex = String.valueOf(searchTags[i]) + "=\\([^\\)]+\\)";
                Matcher m = Pattern.compile(tagRegex).matcher(contentString);
                while (m.find()) {
                    String tagContent = contentString.substring(m.start() + searchTags[i].length() + 2, m.end() - 1);
                    tagMap.put(searchTags[i], tagContent);
                }
                ++i;
            }
            return tagMap;
        }
        return Collections.emptyMap();
    }

    public String getPropertyValue(FileEntity fileEntity, String keyword) {
        switch (keyword) {
            case "id": {
                return fileEntity.getIdForDisplay();
            }
            case "name": {
                return fileEntity.getName();
            }
            case "tag": {
                return fileEntity.getTag();
            }
            case "description": {
                return fileEntity.getDescription();
            }
        }
        return "";
    }

    public boolean compare(FileEntity fileEntity, String keyword, String text) {
        if (fileEntity == null || keyword == null || text == null) {
            return false;
        }
        switch (keyword) {
            case "ids": {
                return this.textContainsEntityId(text.toLowerCase(), fileEntity);
            }
            case "id": {
                return StringUtils.equalsIgnoreCase((String)fileEntity.getIdForDisplay(), (String)text) || StringUtils.startsWithIgnoreCase((String)fileEntity.getIdForDisplay(), (String)(String.valueOf(text) + "/"));
            }
            case "name": {
                return StringUtils.containsIgnoreCase((String)fileEntity.getName(), (String)text);
            }
            case "tag": {
                return StringUtils.containsIgnoreCase((String)fileEntity.getTag(), (String)text);
            }
            case "description": {
                return StringUtils.containsIgnoreCase((String)fileEntity.getDescription(), (String)text);
            }
        }
        return false;
    }

    private boolean textContainsEntityId(String text, FileEntity fileEntity) {
        return Arrays.asList(text.split(CONTENT_DELIMITER)).stream().map(a -> a.trim()).filter(a -> StringUtils.equalsIgnoreCase((String)fileEntity.getIdForDisplay(), (String)a) || StringUtils.startsWithIgnoreCase((String)fileEntity.getIdForDisplay(), (String)(String.valueOf(a) + "/"))).findAny().isPresent();
    }
}

