/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.HookType;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.SnippetsSuggestedEvent;
import cucumber.runner.EventBus;
import cucumber.runner.HookTestStep;
import cucumber.runner.PickleStepTestStep;
import cucumber.runner.TestCase;
import cucumber.runtime.AmbiguousPickleStepDefinitionsMatch;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.Backend;
import cucumber.runtime.FailedPickleStepInstantiationMatch;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.HookDefinitionMatch;
import cucumber.runtime.PickleStepDefinitionMatch;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.UndefinedPickleStepDefinitionMatch;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Runner {
    private final Glue glue;
    private final EventBus bus;
    private final Collection<? extends Backend> backends;
    private final RuntimeOptions runtimeOptions;

    public Runner(Glue glue, EventBus bus, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions) {
        this.glue = glue;
        this.bus = bus;
        this.runtimeOptions = runtimeOptions;
        this.backends = backends;
        for (Backend backend : backends) {
            backend.loadGlue(glue, runtimeOptions.getGlue());
        }
    }

    public void runPickle(PickleEvent pickle) {
        this.buildBackendWorlds();
        TestCase testCase = this.createTestCaseForPickle(pickle);
        testCase.run(this.bus);
        this.disposeBackendWorlds();
    }

    public Glue getGlue() {
        return this.glue;
    }

    public void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        this.glue.reportStepDefinitions(stepDefinitionReporter);
    }

    private TestCase createTestCaseForPickle(PickleEvent pickleEvent) {
        ArrayList<PickleStepTestStep> testSteps = new ArrayList<PickleStepTestStep>();
        ArrayList<HookTestStep> beforeHooks = new ArrayList<HookTestStep>();
        ArrayList<HookTestStep> afterHooks = new ArrayList<HookTestStep>();
        if (!pickleEvent.pickle.getSteps().isEmpty()) {
            this.addTestStepsForBeforeHooks(beforeHooks, pickleEvent.pickle.getTags());
            this.addTestStepsForPickleSteps(testSteps, pickleEvent);
            this.addTestStepsForAfterHooks(afterHooks, pickleEvent.pickle.getTags());
        }
        return new TestCase(testSteps, beforeHooks, afterHooks, pickleEvent, this.runtimeOptions.isDryRun());
    }

    private void addTestStepsForPickleSteps(List<PickleStepTestStep> testSteps, PickleEvent pickleEvent) {
        for (PickleStep step : pickleEvent.pickle.getSteps()) {
            PickleStepDefinitionMatch match;
            try {
                match = this.glue.stepDefinitionMatch(pickleEvent.uri, step);
                if (match == null) {
                    ArrayList<String> snippets = new ArrayList<String>();
                    for (Backend backend : this.backends) {
                        String snippet = backend.getSnippet(step, "**KEYWORD**", this.runtimeOptions.getSnippetType().getFunctionNameGenerator());
                        if (snippet == null) continue;
                        snippets.add(snippet);
                    }
                    if (!snippets.isEmpty()) {
                        this.bus.send(new SnippetsSuggestedEvent(this.bus.getTime(), pickleEvent.uri, step.getLocations(), snippets));
                    }
                    match = new UndefinedPickleStepDefinitionMatch(step);
                }
            }
            catch (AmbiguousStepDefinitionsException e) {
                match = new AmbiguousPickleStepDefinitionsMatch(pickleEvent.uri, step, e);
            }
            catch (Throwable t) {
                match = new FailedPickleStepInstantiationMatch(pickleEvent.uri, step, t);
            }
            List<HookTestStep> afterStepHookSteps = this.getAfterStepHooks(pickleEvent.pickle.getTags());
            List<HookTestStep> beforeStepHookSteps = this.getBeforeStepHooks(pickleEvent.pickle.getTags());
            testSteps.add(new PickleStepTestStep(pickleEvent.uri, step, beforeStepHookSteps, afterStepHookSteps, match));
        }
    }

    private void addTestStepsForBeforeHooks(List<HookTestStep> testSteps, List<PickleTag> tags) {
        this.addTestStepsForHooks(testSteps, tags, this.glue.getBeforeHooks(), HookType.Before);
    }

    private void addTestStepsForAfterHooks(List<HookTestStep> testSteps, List<PickleTag> tags) {
        this.addTestStepsForHooks(testSteps, tags, this.glue.getAfterHooks(), HookType.After);
    }

    private void addTestStepsForHooks(List<HookTestStep> testSteps, List<PickleTag> tags, List<HookDefinition> hooks, HookType hookType) {
        for (HookDefinition hook : hooks) {
            if (!hook.matches(tags)) continue;
            HookTestStep testStep = new HookTestStep(hookType, new HookDefinitionMatch(hook));
            testSteps.add(testStep);
        }
    }

    private List<HookTestStep> getAfterStepHooks(List<PickleTag> tags) {
        ArrayList<HookTestStep> hookSteps = new ArrayList<HookTestStep>();
        this.addTestStepsForHooks(hookSteps, tags, this.glue.getAfterStepHooks(), HookType.AfterStep);
        return hookSteps;
    }

    private List<HookTestStep> getBeforeStepHooks(List<PickleTag> tags) {
        ArrayList<HookTestStep> hookSteps = new ArrayList<HookTestStep>();
        this.addTestStepsForHooks(hookSteps, tags, this.glue.getBeforeStepHooks(), HookType.BeforeStep);
        return hookSteps;
    }

    private void buildBackendWorlds() {
        this.runtimeOptions.getPlugins();
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
    }

    private void disposeBackendWorlds() {
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
    }
}

