/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.execution.testsuite;

import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionDriverEntry;
import com.kms.katalon.composer.execution.util.MapUtil;
import com.kms.katalon.composer.mobile.dialog.AndroidDeviceSelectionDialog;
import com.kms.katalon.composer.mobile.dialog.IosDeviceSelectionDialog;
import com.kms.katalon.composer.mobile.dialog.MobileDeviceSelectionDialog;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class MobileTestExecutionDriverEntry
extends TestExecutionDriverEntry {
    public MobileTestExecutionDriverEntry(DriverType driverType, String groupName, String imageUrl) {
        super(driverType, groupName, imageUrl);
    }

    public RunConfigurationDescription toConfigurationEntity(RunConfigurationDescription previousDescription) {
        HashMap runConfigurationData = new HashMap();
        if (previousDescription != null && previousDescription.getRunConfigurationId() != null && previousDescription.getRunConfigurationId().equals(this.getName())) {
            runConfigurationData.clear();
        }
        return RunConfigurationDescription.from((String)this.groupName, (String)this.getName(), runConfigurationData, (String)(previousDescription == null ? "default" : previousDescription.getProfileName()));
    }

    public CellEditor getRunConfigurationDataCellEditor(Composite parent) {
        return new AbstractDialogCellEditor(parent){

            protected void updateContents(Object value) {
                Map newValueMap = MapUtil.convertObjectToStringMap((Object)value);
                if (newValueMap == null) {
                    super.updateContents(value);
                    return;
                }
                super.updateContents((Object)MapUtil.buildStringForMap((Map)newValueMap));
            }

            protected Object openDialogBox(Control cellEditorWindow) {
                Map newValueMap = MapUtil.convertObjectToStringMap((Object)this.getValue());
                return MobileTestExecutionDriverEntry.this.changeRunConfigurationData(this.getParentShell(), newValueMap);
            }
        };
    }

    public Map<String, String> changeRunConfigurationData(Shell shell, Map<String, String> runConfigurationData) {
        MobileDeviceSelectionDialog deviceSelectionDialog = null;
        switch ((MobileDriverType)this.driverType) {
            case ANDROID_DRIVER: {
                deviceSelectionDialog = new AndroidDeviceSelectionDialog(shell);
                break;
            }
            case IOS_DRIVER: {
                deviceSelectionDialog = new IosDeviceSelectionDialog(shell);
            }
        }
        if (deviceSelectionDialog.open() != 0) {
            return runConfigurationData;
        }
        HashMap<String, String> newValueMap = new HashMap<String, String>(runConfigurationData);
        MobileDeviceInfo device = deviceSelectionDialog.getDevice();
        newValueMap.put("deviceName", device.getDisplayName());
        newValueMap.put("deviceId", device.getDeviceId());
        return newValueMap;
    }

    public boolean requiresExtraConfiguration() {
        return true;
    }
}

