/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.dialog;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.constants.ComposerMobileMessageConstants;
import com.kms.katalon.composer.mobile.constants.ImageConstants;
import com.kms.katalon.composer.mobile.dialog.provider.MobileDeviceColumnLabelProvider;
import com.kms.katalon.execution.mobile.constants.StringConstants;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class MobileDeviceSelectionDialog
extends AbstractDialog {
    private List<? extends MobileDeviceInfo> devicesList;
    private MobileDeviceInfo selectedDevice;
    private TableViewer deviceTableViewer;
    private Thread thread;
    private boolean interrupted = false;
    private Composite deviceMainComposite;
    private StackLayout stackLayout;
    private Composite noDeviceComposite;
    private Composite tableComposite;
    private Composite loadingDeviceComposite;
    private Composite notificationComposite;
    private GifCLabel connectingLabel;
    private InputStream loadingImgInputStream;

    public MobileDeviceSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void registerControlModifyListeners() {
        this.deviceTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MobileDeviceSelectionDialog.this.selectedDevice = (MobileDeviceInfo)MobileDeviceSelectionDialog.this.deviceTableViewer.getStructuredSelection().getFirstElement();
                MobileDeviceSelectionDialog.this.getButton(0).setEnabled(MobileDeviceSelectionDialog.this.selectedDevice != null);
            }
        });
        this.deviceTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MobileDeviceSelectionDialog.this.okPressed();
            }
        });
        this.connectingLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    MobileDeviceSelectionDialog.this.loadingImgInputStream.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    private boolean devicesChanged(List<? extends MobileDeviceInfo> newDevices, List<? extends MobileDeviceInfo> oldDevices) {
        if (newDevices == null || oldDevices == null) {
            return true;
        }
        if (newDevices.size() != oldDevices.size()) {
            return true;
        }
        return newDevices.parallelStream().filter(d -> !oldDevices.contains(d)).findAny().isPresent();
    }

    protected void setInput() {
        this.getButton(0).setEnabled(false);
        this.stackLayout.topControl = this.loadingDeviceComposite;
        this.deviceMainComposite.layout();
        this.thread = new Thread(() -> {
            try {
                while (!this.interrupted) {
                    List<? extends MobileDeviceInfo> newDeviceList = this.getMobileDevices();
                    boolean devicesChanged = this.devicesChanged(newDeviceList, this.devicesList);
                    if (this.interrupted) {
                        return;
                    }
                    if (devicesChanged) {
                        this.devicesList = newDeviceList;
                        this.devicesList.sort(new RealDevicePriority());
                        UISynchronizeService.syncExec(() -> {
                            if (this.deviceMainComposite.isDisposed()) {
                                return;
                            }
                            this.notificationComposite.getParent().setRedraw(false);
                            this.deviceTableViewer.setInput(this.devicesList);
                            if (this.devicesList.isEmpty()) {
                                this.stackLayout.topControl = this.noDeviceComposite;
                            } else {
                                this.stackLayout.topControl = this.tableComposite;
                                if (this.selectedDevice == null) {
                                    this.deviceTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.devicesList.get(0)));
                                }
                            }
                            this.deviceMainComposite.layout();
                            this.cleanNotifications();
                            if (this.devicesList.isEmpty()) {
                                this.addNoDeviceNotification();
                            }
                            this.notificationComposite.getParent().setRedraw(true);
                            this.notificationComposite.getParent().layout(true, true);
                        });
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (MobileSetupException | InterruptedException throwable) {
            }
            catch (IOException e) {
                UISynchronizeService.syncExec(() -> MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR, (String)e.getMessage()));
            }
        });
        this.thread.start();
    }

    protected abstract List<? extends MobileDeviceInfo> getMobileDevices() throws MobileSetupException, IOException, InterruptedException;

    private void cleanNotifications() {
        while (this.notificationComposite.getChildren() != null && this.notificationComposite.getChildren().length > 0) {
            this.notificationComposite.getChildren()[0].dispose();
        }
    }

    private void addNoDeviceNotification() {
        Composite noDeviceNotificationComposite = new Composite(this.notificationComposite, 0);
        noDeviceNotificationComposite.setLayout((Layout)new GridLayout(2, false));
        noDeviceNotificationComposite.setBackground(ColorUtil.getWarningLogBackgroundColor());
        noDeviceNotificationComposite.setBackgroundMode(2);
        Label lblNoDeviceNotification = new Label(noDeviceNotificationComposite, 0);
        lblNoDeviceNotification.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        lblNoDeviceNotification.setText(ComposerMobileMessageConstants.DIA_LBL_TROUBLESHOOT);
        Link lnkNoDeviceTroubleshoot = new Link(noDeviceNotificationComposite, 0);
        lnkNoDeviceTroubleshoot.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        lnkNoDeviceTroubleshoot.setText(String.format("<a>%s</a>", ComposerMobileMessageConstants.DIA_LNK_TROUBLESHOOT));
        lnkNoDeviceTroubleshoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)MobileDeviceSelectionDialog.this.getTroubleshootLink());
            }
        });
    }

    protected abstract String getTroubleshootLink();

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.notificationComposite = new Composite(container, 0);
        this.notificationComposite.setLayout((Layout)new FillLayout(512));
        this.notificationComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.deviceMainComposite = new Composite(container, 0);
        this.deviceMainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.deviceMainComposite.setLayout((Layout)this.stackLayout);
        this.loadingDeviceComposite = new Composite(this.deviceMainComposite, 0);
        this.loadingDeviceComposite.setLayout((Layout)new GridLayout(2, false));
        this.connectingLabel = new GifCLabel(this.loadingDeviceComposite, 0x20000000);
        this.connectingLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        try {
            this.loadingImgInputStream = ImageConstants.URL_16_LOADING.openStream();
            this.connectingLabel.setGifImage(this.loadingImgInputStream);
        }
        catch (IOException iOException) {}
        Label lblLoadingDevice = new Label(this.loadingDeviceComposite, 0);
        lblLoadingDevice.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblLoadingDevice.setText(ComposerMobileMessageConstants.DIA_LBL_LOADING_DEVICES);
        this.noDeviceComposite = new Composite(this.deviceMainComposite, 0);
        this.noDeviceComposite.setLayout((Layout)new GridLayout());
        Label lblNoDeviceConnected = new Label(this.noDeviceComposite, 0);
        lblNoDeviceConnected.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblNoDeviceConnected.setText(ComposerMobileMessageConstants.DIA_MSG_NO_DEVICES_CONNECTED);
        this.tableComposite = new Composite(this.deviceMainComposite, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)tableLayout);
        this.deviceTableViewer = new CTableViewer(this.tableComposite, 2048);
        this.deviceTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn deviceColumnViewer = new TableViewerColumn(this.deviceTableViewer, 0);
        tableLayout.setColumnData((Widget)deviceColumnViewer.getColumn(), (ColumnLayoutData)new ColumnWeightData(98, 300));
        deviceColumnViewer.setLabelProvider((CellLabelProvider)new MobileDeviceColumnLabelProvider(0));
        this.stackLayout.topControl = this.tableComposite;
        this.deviceMainComposite.layout();
        return this.deviceMainComposite;
    }

    protected Point getInitialSize() {
        return new Point(450, 350);
    }

    public MobileDeviceInfo getDevice() {
        return this.selectedDevice;
    }

    public boolean close() {
        this.interrupted = true;
        return super.close();
    }

    private final class RealDevicePriority
    implements Comparator<MobileDeviceInfo> {
        private RealDevicePriority() {
        }

        @Override
        public int compare(MobileDeviceInfo deviceA, MobileDeviceInfo deviceB) {
            if (!deviceA.isEmulator()) {
                return -1;
            }
            if (!deviceB.isEmulator()) {
                return 1;
            }
            return 0;
        }
    }
}

