/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.dialog;

import com.kms.katalon.composer.mobile.constants.StringConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MixedModeSelectionDialog
extends TitleAreaDialog {
    private String mobileDeviceName;
    private Combo cbbDevices;
    private String browserName;
    private Combo cbbBrowsers;
    private Composite container;
    private Map<String, String> devicesList = new LinkedHashMap<String, String>();

    public MixedModeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.container = new Composite(area, 0);
        this.container.setLayoutData((Object)new GridData(1808));
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        this.container.setLayout((Layout)glContainer);
        try {
            this.devicesList.clear();
            this.getAndroidDevices();
            this.getIosDevices();
        }
        catch (Exception exception) {}
        Label theLabel = new Label(this.container, 0);
        theLabel.setText(StringConstants.DIA_DEVICE_NAME);
        this.cbbDevices = new Combo(this.container, 8);
        this.cbbDevices.setLayoutData((Object)new GridData(768));
        this.cbbDevices.setItems(this.devicesList.values().toArray(new String[0]));
        this.cbbDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MixedModeSelectionDialog.this.updateStatus();
            }
        });
        theLabel = new Label(this.container, 0);
        theLabel.setText(StringConstants.DIA_BROWSER_NAME);
        this.cbbBrowsers = new Combo(this.container, 8);
        this.cbbBrowsers.setLayoutData((Object)new GridData(768));
        this.cbbBrowsers.setItems(WebUIDriverType.stringValues());
        this.cbbBrowsers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MixedModeSelectionDialog.this.updateStatus();
            }
        });
        return area;
    }

    private void updateStatus() {
        if (this.cbbDevices.getSelectionIndex() < 0 && this.cbbBrowsers.getSelectionIndex() < 0) {
            super.getButton(0).setEnabled(false);
        } else {
            super.getButton(0).setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateStatus();
    }

    public void create() {
        super.create();
        this.setTitle("Select your Browser, Device");
        this.setMessage(StringConstants.DIA_SELECT_MIXED_MODE_MSG, 1);
    }

    protected Point getInitialSize() {
        return new Point(400, 220);
    }

    protected void okPressed() {
        this.mobileDeviceName = this.cbbDevices.getText();
        this.browserName = this.cbbBrowsers.getText();
        super.okPressed();
    }

    public String getDeviceName() {
        return this.mobileDeviceName;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    private void getIosDevices() throws Exception {
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            ArrayList<String> deviceIds = new ArrayList<String>();
            String[] cmd = new String[]{"idevice_id", "-l"};
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process p = pb.start();
            p.waitFor();
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                deviceIds.add(line);
            }
            for (String deviceId : deviceIds) {
                cmd = new String[]{"ideviceinfo", "-u", deviceId};
                pb.command(cmd);
                p = pb.start();
                p.waitFor();
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String deviceInfo = "";
                while ((line = br.readLine()) != null) {
                    if (line.contains("DeviceClass:")) {
                        deviceInfo = line.substring("DeviceClass:".length(), line.length()).trim();
                        continue;
                    }
                    if (line.contains("DeviceName:")) {
                        deviceInfo = String.valueOf(deviceInfo) + " " + line.substring("DeviceName:".length(), line.length()).trim();
                        continue;
                    }
                    if (!line.contains("ProductVersion:")) continue;
                    deviceInfo = String.valueOf(deviceInfo) + " " + line.substring("ProductVersion:".length(), line.length()).trim();
                }
                deviceInfo = String.valueOf(deviceInfo) + " (iOS)";
                this.devicesList.put(deviceId, deviceInfo);
            }
        }
    }

    private void getAndroidDevices() throws Exception {
        String adbPath = System.getenv("ANDROID_HOME");
        if (adbPath != null) {
            String line;
            ArrayList<String> deviceIds = new ArrayList<String>();
            adbPath = String.valueOf(adbPath) + File.separator + "platform-tools" + File.separator + "adb";
            String[] cmd = new String[]{adbPath, "devices"};
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = pb.start();
            process.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (line.toLowerCase().trim().contains("list of devices") || !line.toLowerCase().trim().contains("device")) continue;
                String deviceId = line.split("\\s")[0];
                deviceIds.add(deviceId);
            }
            br.close();
            for (String id : deviceIds) {
                cmd = new String[]{adbPath, "-s", id, "shell", "getprop", "ro.product.manufacturer"};
                pb.command(cmd);
                process = pb.start();
                process.waitFor();
                br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String deviceName = br.readLine();
                br.close();
                cmd = new String[]{adbPath, "-s", id, "shell", "getprop", "ro.product.model"};
                pb.command(cmd);
                process = pb.start();
                process.waitFor();
                br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                deviceName = String.valueOf(deviceName) + " " + br.readLine();
                br.close();
                cmd = new String[]{adbPath, "-s", id, "shell", "getprop", "ro.build.version.release"};
                pb.command(cmd);
                process = pb.start();
                process.waitFor();
                br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                deviceName = String.valueOf(deviceName) + " " + br.readLine();
                br.close();
                deviceName = String.valueOf(deviceName) + " (Android)";
                this.devicesList.put(id, deviceName);
            }
        }
    }
}

