/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.setting;

import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsSettingStore
extends BundleSettingStore {
    public AnalyticsSettingStore(String projectDir) {
        super(projectDir, "com.kms.katalon.integration.analytics", false);
    }

    public boolean isIntegrationEnabled() throws IOException {
        return this.getBoolean("analytics.integration.enable", false);
    }

    public void enableIntegration(boolean enabled) throws IOException {
        this.setProperty("analytics.integration.enable", enabled);
    }

    public String getServerEndpoint(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("analytics.server.endpoint", "https://analytics.katalon.com", encryptionEnabled);
    }

    public void setServerEndPoint(String serverEndpoint, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("analytics.server.endpoint", serverEndpoint, encryptionEnabled);
    }

    public String getEmail(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("analytics.authentication.email", "", encryptionEnabled);
    }

    public void setEmail(String email, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("analytics.authentication.email", email, encryptionEnabled);
    }

    public String getPassword(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("analytics.authentication.password", "", encryptionEnabled);
    }

    public void setPassword(String rawPassword, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("analytics.authentication.password", rawPassword, encryptionEnabled);
    }

    public boolean isEncryptionEnabled() throws IOException {
        return this.getBoolean("analytics.authentication.encryptionEnabled", false);
    }

    public void enableEncryption(boolean enabled) throws IOException {
        this.setProperty("analytics.authentication.encryptionEnabled", enabled);
    }

    public AnalyticsProject getProject() throws IOException {
        AnalyticsProject project = new AnalyticsProject();
        String projectJson = this.getString("analytics.project", "");
        if (StringUtils.isNotBlank((CharSequence)projectJson)) {
            try {
                project = (AnalyticsProject)JsonUtil.fromJson((String)projectJson, AnalyticsProject.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return project;
    }

    public void setProject(AnalyticsProject project) throws IOException {
        this.setProperty("analytics.project", JsonUtil.toJson((Object)project));
    }

    public AnalyticsTeam getTeam() throws IOException {
        AnalyticsTeam team = new AnalyticsTeam();
        String teamJson = this.getString("analytics.team", "");
        if (StringUtils.isNotBlank((CharSequence)teamJson)) {
            try {
                team = (AnalyticsTeam)JsonUtil.fromJson((String)teamJson, AnalyticsTeam.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return team;
    }

    public void setTeam(AnalyticsTeam team) throws IOException {
        this.setProperty("analytics.team", JsonUtil.toJson((Object)team));
    }

    public String getToken(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("analytics.authentication.token", "", encryptionEnabled);
    }

    public void setToken(String token, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("analytics.authentication.token", token, encryptionEnabled);
    }

    public boolean isAutoSubmit() throws IOException {
        return this.getBoolean("analytics.testresult.autosubmit", false);
    }

    public void setAutoSubmit(boolean autoSubmit) throws IOException {
        this.setProperty("analytics.testresult.autosubmit", autoSubmit);
    }

    public boolean isAttachScreenshot() throws IOException {
        return this.getBoolean("analytics.testresult.attach.screenshot", false);
    }

    public void setAttachScreenshot(boolean attachScreenshot) throws IOException {
        this.setProperty("analytics.testresult.attach.screenshot", attachScreenshot);
    }

    public boolean isAttachLog() throws IOException {
        return this.getBoolean("analytics.testresult.attach.log", false);
    }

    public void setAttachLog(boolean attachLog) throws IOException {
        this.setProperty("analytics.testresult.attach.log", attachLog);
    }

    public boolean isAttachCapturedVideos() throws IOException {
        return this.getBoolean("analytics.testresult.attach.capturedvideos", false);
    }

    public void setAttachCapturedVideos(boolean capturedVideos) throws IOException {
        this.setProperty("analytics.testresult.attach.capturedvideos", capturedVideos);
    }
}

