/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.report;

import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.AnalyticsComponent;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestRun;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsUploadInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiExeception;
import com.kms.katalon.integration.analytics.providers.AnalyticsApiProvider;
import com.kms.katalon.integration.analytics.util.FileUtils;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsReportService
implements AnalyticsComponent {
    public boolean isIntegrationEnabled() {
        boolean isIntegrationEnabled = false;
        try {
            isIntegrationEnabled = this.getSettingStore().isIntegrationEnabled();
        }
        catch (IOException iOException) {}
        return isIntegrationEnabled;
    }

    private boolean isEncryptionEnabled() {
        boolean isEncryptionEnabled = false;
        try {
            isEncryptionEnabled = this.getSettingStore().isEncryptionEnabled();
        }
        catch (IOException iOException) {}
        return isEncryptionEnabled;
    }

    public void upload(String folderPath) throws AnalyticsApiExeception {
        if (this.isIntegrationEnabled()) {
            LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_SEND_TEST_RESULT_START);
            try {
                AnalyticsTokenInfo token = this.getKAToken();
                if (token != null) {
                    this.perform(token.getAccess_token(), folderPath);
                } else {
                    LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_REQUEST_TOKEN_ERROR);
                }
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
                throw new AnalyticsApiExeception(e);
            }
            LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_SEND_TEST_RESULT_END);
        }
    }

    private AnalyticsTokenInfo getKAToken() throws IOException, GeneralSecurityException, AnalyticsApiExeception {
        String serverUrl = this.getSettingStore().getServerEndpoint(this.isEncryptionEnabled());
        String email = this.getSettingStore().getEmail(this.isEncryptionEnabled());
        String password = this.getSettingStore().getPassword(this.getSettingStore().isEncryptionEnabled());
        AnalyticsTokenInfo token = AnalyticsApiProvider.requestToken(serverUrl, email, password);
        return token;
    }

    private void perform(String token, String path) throws Exception {
        LogUtil.printOutputLine((String)("Uploading log files in folder path: " + path));
        String serverUrl = this.getSettingStore().getServerEndpoint(this.isEncryptionEnabled());
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        Long projectId = this.getSettingStore().getProject().getId();
        List<Path> files = this.scanFiles(path);
        long timestamp = System.currentTimeMillis();
        Path reportFolder = Paths.get(FolderController.getInstance().getReportRoot(project).getLocation(), new String[0]);
        int i = 0;
        while (i < files.size()) {
            Path filePath = files.get(i);
            String folderPath = reportFolder.relativize(filePath.getParent()).toString();
            boolean isEnd = i == files.size() - 1;
            LogUtil.printOutputLine((String)("Sending file: " + filePath.toAbsolutePath()));
            if ("s3".equalsIgnoreCase("s3")) {
                File file = filePath.toFile();
                AnalyticsUploadInfo uploadInfo = AnalyticsApiProvider.getUploadInfo(serverUrl, token, projectId);
                AnalyticsApiProvider.uploadFile(uploadInfo.getUploadUrl(), file);
                AnalyticsApiProvider.uploadFileInfo(serverUrl, projectId, timestamp, folderPath, file.getName(), uploadInfo.getPath(), isEnd, token);
            } else {
                AnalyticsApiProvider.sendLog(serverUrl, projectId, timestamp, folderPath, filePath.toFile(), isEnd, token);
            }
            ++i;
        }
    }

    private List<Path> scanFiles(String path) {
        ArrayList<Path> files = new ArrayList<Path>();
        try {
            this.addToList(files, this.scanFilesWithFilter(path, true, "([^\\s]+(\\.(?i)(uuid))$)"));
            this.addToList(files, this.scanFilesWithFilter(path, true, "([^\\s]+(\\.(?i)(log))$)"));
            this.addToList(files, this.scanFilesWithFilter(path, this.getSettingStore().isAttachScreenshot(), "([^\\s]+(\\.(?i)(png|jpg))$)"));
            this.addToList(files, this.scanFilesWithFilter(path, this.getSettingStore().isAttachLog(), "([^\\s]+(\\.(?i)(properties|xml|json))$)"));
            this.addToList(files, this.scanFilesWithFilter(path, this.getSettingStore().isAttachCapturedVideos(), "([^\\s]+(\\.(?i)(avi|mov))$)"));
            this.addToList(files, this.scanHarFiles(path));
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
        }
        return files;
    }

    private List<Path> scanHarFiles(String path) {
        List<Path> harFiles = this.scanFilesWithFilter(path, true, "([^\\s]+(\\.(?i)(har))$)");
        if (harFiles == null || harFiles.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Path zipFile = FileUtils.createTemporaryFile(String.valueOf(StringUtils.appendIfMissing((String)path, (CharSequence)File.separator, (CharSequence[])new CharSequence[0])) + "katalon-analitics-tmp", "hars-", ".zip");
            Path harsZipFile = ZipUtil.compress(harFiles, (Path)zipFile);
            return Arrays.asList(harsZipFile);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e, (String)"Could not compress har files");
            return harFiles;
        }
    }

    private void addToList(List<Path> files, List<Path> other) {
        if (!other.isEmpty()) {
            files.addAll(other);
        }
    }

    private List<Path> scanFilesWithFilter(String path, boolean isScan, String pattern) {
        if (isScan) {
            return FileUtils.scanFiles(path, pattern);
        }
        return new ArrayList<Path>();
    }

    private String getFolderPath(Path filePath) {
        String folderPath;
        try {
            folderPath = String.valueOf(filePath.getParent().getParent().toFile().getName()) + File.separator + filePath.getParent().toFile().getName();
        }
        catch (Exception exception) {
            folderPath = filePath.getParent().toFile().getName();
        }
        return folderPath;
    }

    public void updateExecutionProccess(AnalyticsTestRun testRun) throws AnalyticsApiExeception {
        try {
            AnalyticsTokenInfo token = this.getKAToken();
            if (token != null) {
                String serverUrl = this.getSettingStore().getServerEndpoint(this.isEncryptionEnabled());
                long projectId = this.getSettingStore().getProject().getId();
                AnalyticsApiProvider.updateTestRunResult(serverUrl, projectId, token.getAccess_token(), testRun);
            } else {
                LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_REQUEST_TOKEN_ERROR);
            }
        }
        catch (AnalyticsApiExeception | IOException | GeneralSecurityException e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
            throw new AnalyticsApiExeception(e);
        }
    }
}

