/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.report;

import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.integration.analytics.AnalyticsComponent;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestRun;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class AnalyticsReportIntegration
implements ReportIntegrationContribution,
AnalyticsComponent {
    private AnalyticsReportService reportService = new AnalyticsReportService();

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Collections.emptyList();
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        try {
            return this.getSettingStore().isIntegrationEnabled() && this.getSettingStore().isAutoSubmit();
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void uploadTestSuiteResult(TestSuiteEntity testSuite, TestSuiteLogRecord suiteLog) throws Exception {
        this.reportService.upload(suiteLog.getLogFolder());
    }

    public void notifyProccess(Object event, ExecutionEntityResult result) {
        try {
            boolean integrationActive;
            boolean bl = integrationActive = this.getSettingStore().isIntegrationEnabled() && this.getSettingStore().isAutoSubmit();
            if (integrationActive) {
                IExecutedEntity executedEntity = result.getExecutedEntity();
                if (executedEntity instanceof TestSuiteExecutedEntity) {
                    AnalyticsTestRun testRun = new AnalyticsTestRun();
                    testRun.setName(result.getName());
                    testRun.setSessionId(result.getSessionId());
                    if (result.getTestStatusValue() != null) {
                        testRun.setStatus(result.getTestStatusValue().name());
                    }
                    testRun.setTestSuiteId(executedEntity.getSourceName());
                    testRun.setEnd(result.isEnd());
                    this.reportService.updateExecutionProccess(testRun);
                } else if (executedEntity instanceof TestSuiteCollectionExecutedEntity) {
                    AnalyticsTestRun testRun = new AnalyticsTestRun();
                    testRun.setSessionId(result.getSessionId());
                    testRun.setEnd(result.isEnd());
                    this.reportService.updateExecutionProccess(testRun);
                }
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }
}

