/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsProjectPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeamPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestRun;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsUploadInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiExeception;
import com.kms.katalon.integration.analytics.providers.HttpClientProxyBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class AnalyticsApiProvider {
    private static final String HEADER_VALUE_AUTHORIZATION_PREFIX = "Bearer ";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_AUTHORIZATION_PREFIX = "Basic ";
    private static final String LOGIN_PARAM_PASSWORD = "password";
    private static final String LOGIN_PARAM_USERNAME = "username";
    private static final String LOGIN_PARAM_GRANT_TYPE_NAME = "grant_type";
    private static final String LOGIN_PARAM_GRANT_TYPE_VALUE = "password";
    private static final String OAUTH2_CLIENT_ID = "kit_uploader";
    private static final String OAUTH2_CLIENT_SECRET = "kit_uploader";

    public static AnalyticsTokenInfo requestToken(String serverUrl, String email, String password) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/oauth/token");
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.setParameter(LOGIN_PARAM_USERNAME, email);
            uriBuilder.setParameter("password", password);
            uriBuilder.setParameter(LOGIN_PARAM_GRANT_TYPE_NAME, "password");
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            String clientCredentials = "kit_uploader:kit_uploader";
            httpPost.setHeader(HEADER_AUTHORIZATION, HEADER_AUTHORIZATION_PREFIX + Base64.getEncoder().encodeToString(clientCredentials.getBytes()));
            return AnalyticsApiProvider.executeRequest((HttpUriRequest)httpPost, AnalyticsTokenInfo.class);
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static List<AnalyticsTeam> getTeams(String serverUrl, String accessToken) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/users/me");
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            httpGet.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + accessToken);
            AnalyticsTeamPage teamPage = AnalyticsApiProvider.executeRequest((HttpUriRequest)httpGet, AnalyticsTeamPage.class);
            return teamPage.getTeams();
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static List<AnalyticsProject> getProjects(String serverUrl, AnalyticsTeam team, String accessToken) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/projects");
            URIBuilder uriBuilder = new URIBuilder(uri);
            if (team != null && team.getId() != 0L) {
                uriBuilder.setParameter("teamId", "" + team.getId());
                uriBuilder.setParameter("sort", "name,asc");
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            httpGet.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + accessToken);
            AnalyticsProjectPage projectPage = AnalyticsApiProvider.executeRequest((HttpUriRequest)httpGet, AnalyticsProjectPage.class);
            return projectPage.getContent();
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static AnalyticsProject createProject(String serverUrl, String projectName, AnalyticsTeam team, String accessToken) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/projects");
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + accessToken);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", projectName);
            if (team != null && team.getId() != null) {
                map.put("teamId", "" + team.getId());
            }
            Gson gson = new Gson();
            StringEntity entity = new StringEntity(gson.toJson(map));
            httpPost.setEntity((HttpEntity)entity);
            return AnalyticsApiProvider.executeRequest((HttpUriRequest)httpPost, AnalyticsProject.class);
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static void sendLog(String serverUrl, long projectId, long timestamp, String folderName, File file, boolean isEnd, String token) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/katalon-test-reports");
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + token);
            StringBody projectIdPart = new StringBody(String.valueOf(projectId), ContentType.MULTIPART_FORM_DATA);
            StringBody batchPart = new StringBody(String.valueOf(timestamp), ContentType.MULTIPART_FORM_DATA);
            StringBody isEndPart = new StringBody(String.valueOf(isEnd), ContentType.MULTIPART_FORM_DATA);
            StringBody folderPathPart = new StringBody(folderName, ContentType.MULTIPART_FORM_DATA);
            FileBody fileBodyPart = new FileBody(file, ContentType.DEFAULT_BINARY);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart("projectId", (ContentBody)projectIdPart);
            builder.addPart("batch", (ContentBody)batchPart);
            builder.addPart("folderPath", (ContentBody)folderPathPart);
            builder.addPart("isEnd", (ContentBody)isEndPart);
            builder.addPart("file", (ContentBody)fileBodyPart);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            AnalyticsApiProvider.executeRequest((HttpUriRequest)httpPost, Object.class);
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static AnalyticsUploadInfo getUploadInfo(String serverUrl, String token, long projectId) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/files/upload-url");
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + token);
            return AnalyticsApiProvider.executeRequest((HttpUriRequest)httpGet, AnalyticsUploadInfo.class);
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static void uploadFile(String url, File file) throws AnalyticsApiExeception {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream content = new FileInputStream(file);){
                InputStreamEntity entity = new InputStreamEntity((InputStream)content, file.length());
                HttpPut httpPut = new HttpPut(url);
                httpPut.setEntity((HttpEntity)entity);
                AnalyticsApiProvider.executeRequest((HttpUriRequest)httpPut, Object.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    public static void uploadFileInfo(String serverUrl, long projectId, long timestamp, String folderName, String fileName, String uploadedPath, boolean isEnd, String token) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/katalon-test-reports");
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            uriBuilder.setParameter("batch", String.valueOf(timestamp));
            uriBuilder.setParameter("folderPath", folderName);
            uriBuilder.setParameter("isEnd", String.valueOf(isEnd));
            uriBuilder.setParameter("fileName", fileName);
            uriBuilder.setParameter("uploadedPath", uploadedPath);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + token);
            AnalyticsApiProvider.executeRequest((HttpUriRequest)httpPost, Object.class);
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }

    private static <T> T executeRequest(HttpUriRequest httpRequest, Class<T> returnType) throws Exception {
        HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create(ProxyPreferences.getProxyInformation());
        CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new AnalyticsApiExeception(new Throwable(responseString));
        }
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, returnType);
    }

    private static URI getApiURI(String host, String path) throws URISyntaxException {
        return new URIBuilder().setPath(String.valueOf(host) + path).build();
    }

    public static void updateTestRunResult(String serverUrl, long projectId, String token, AnalyticsTestRun testRun) throws AnalyticsApiExeception {
        try {
            URI uri = AnalyticsApiProvider.getApiURI(serverUrl, "/api/v1/katalon/test-reports/update-result");
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + token);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            Gson gson = new GsonBuilder().create();
            StringEntity entity = new StringEntity(gson.toJson((Object)testRun));
            httpPost.setEntity((HttpEntity)entity);
            AnalyticsApiProvider.executeRequest((HttpUriRequest)httpPost, Object.class);
        }
        catch (Exception e) {
            throw new AnalyticsApiExeception(e);
        }
    }
}

