/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.ITestSuiteDataProvider;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ReportFileServiceManager {
    private static Comparator<FileEntity> comparator;

    public static void initReportFolder(String path) throws IOException {
        File reportRootPath = new File(path, FileServiceConstant.REPORT_ROOT_FOLDER_NAME);
        if (!reportRootPath.exists()) {
            reportRootPath.mkdir();
        }
    }

    public static void ensureFolderExist(File folder) throws Exception {
        if (folder.exists()) {
            return;
        }
        if (!folder.getParentFile().exists()) {
            ReportFileServiceManager.ensureFolderExist(folder.getParentFile());
        }
        folder.mkdirs();
    }

    public static String getReportFolderOfTestSuite(ProjectEntity project, TestSuiteEntity testSuite) throws Exception {
        ITestSuiteDataProvider testSuiteProvider = new FileServiceDataProviderSetting().getTestSuiteDataProvider();
        String testSuiteIdWithoutRoot = testSuiteProvider.getIdForDisplay(testSuite).substring(FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME.length() + 1);
        String reportRootFolderPath = FileServiceConstant.getReportRootFolderLocation(project.getFolderLocation());
        return String.valueOf(reportRootFolderPath) + File.separator + testSuiteIdWithoutRoot;
    }

    public static void deleteReport(ReportEntity report) throws Exception {
        EntityFileServiceManager.delete((FileEntity)report);
    }

    public static ReportEntity getReportEntity(String path) throws Exception {
        File folderMetaDataFile = new File(new File(path), FolderEntity.getMetaDataFileExtension());
        Object entity = null;
        File reportFile = new File(path);
        entity = folderMetaDataFile.exists() ? EntityService.getInstance().loadEntityFromFile(folderMetaDataFile.getAbsolutePath()) : new ReportEntity();
        entity.setParentFolder(FolderFileServiceManager.getFolder(reportFile.getParent()));
        entity.setProject(DataProviderState.getInstance().getCurrentProject());
        entity.setName(FilenameUtils.getBaseName((String)path));
        if (entity != null && entity instanceof ReportEntity) {
            return entity;
        }
        return null;
    }

    public static ReportEntity createReportEntity(String reportName, FolderEntity parentFolder) throws Exception {
        ReportEntity report = new ReportEntity();
        report.setName(reportName);
        report.setParentFolder(parentFolder);
        report.setProject(parentFolder.getProject());
        Path filePath = Paths.get(String.valueOf(parentFolder.getLocation()) + File.separator + reportName, new String[0]);
        BasicFileAttributeView basicView = Files.getFileAttributeView(filePath, BasicFileAttributeView.class, new LinkOption[0]);
        BasicFileAttributes basicAttr = basicView.readAttributes();
        FileTime createdDate = basicAttr.creationTime();
        FileTime modifiedDate = basicAttr.creationTime();
        report.setDateCreated(new Date(createdDate.toMillis()));
        report.setDateModified(new Date(modifiedDate.toMillis()));
        if (!EntityService.getInstance().getEntityCache().contains(report.getLocation())) {
            EntityService.getInstance().getEntityCache().put(report.getLocation(), (FileEntity)report);
        }
        return report;
    }

    public static void sortListByCreatedDate(List<FileEntity> list, final boolean desc) {
        if (comparator == null) {
            comparator = new Comparator<FileEntity>(){

                @Override
                public int compare(FileEntity e1, FileEntity e2) {
                    if (this.canCompareUsingDisplayName(e1, e2)) {
                        return this.compareUsingDisplayName(desc, e1, e2);
                    }
                    if (e1 != null && e2 != null && e1.getDateCreated() != null && e2.getDateCreated() != null) {
                        return desc ? e2.getDateCreated().compareTo(e1.getDateCreated()) : e1.getDateCreated().compareTo(e2.getDateCreated());
                    }
                    return desc ? e2.getName().compareTo(e1.getName()) : e1.getName().compareTo(e2.getName());
                }

                private int compareUsingDisplayName(boolean desc2, FileEntity e1, FileEntity e2) {
                    return desc2 ? ((ReportEntity)e2).getDisplayName().compareTo(((ReportEntity)e1).getDisplayName()) : ((ReportEntity)e1).getDisplayName().compareTo(((ReportEntity)e2).getDisplayName());
                }

                private boolean canCompareUsingDisplayName(FileEntity e1, FileEntity e2) {
                    return e1 instanceof ReportEntity && e2 instanceof ReportEntity && ((ReportEntity)e1).getDisplayName() != null && ((ReportEntity)e2).getDisplayName() != null;
                }
            };
        }
        if (list != null && list.size() > 0) {
            Collections.sort(list, comparator);
        }
    }

    private static void validateRenameReport(FileEntity fileEntity, String newName) throws Exception {
        EntityService.getInstance().validateName(newName);
        String newLocation = String.valueOf(fileEntity.getParentFolder().getLocation()) + File.separator + newName;
        if (newLocation.length() > 255) {
            throw new FilePathTooLongException(newLocation.length(), 255);
        }
    }

    public static ReportEntity renameReport(ReportEntity report, String newName) throws Exception {
        if (report == null || report.getProject() == null) {
            return null;
        }
        ReportFileServiceManager.validateRenameReport((FileEntity)report, newName);
        report.setDisplayName(newName);
        EntityService.getInstance().saveFolderMetadataEntity((FileEntity)report);
        FolderFileServiceManager.refreshFolder(report.getParentFolder());
        return report;
    }

    public static ReportCollectionEntity renameReportCollection(ReportCollectionEntity reportCollection, String newName) throws Exception {
        if (reportCollection == null || reportCollection.getProject() == null) {
            return null;
        }
        ReportFileServiceManager.validateRenameReport((FileEntity)reportCollection, newName);
        reportCollection.setDisplayName(newName);
        EntityService.getInstance().saveEntity((FileEntity)reportCollection, reportCollection.getLocation());
        FolderFileServiceManager.refreshFolder(reportCollection.getParentFolder());
        return reportCollection;
    }
}

