/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.GlobalVariableFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.SourceFolderConfiguration;
import com.kms.katalon.entity.project.SystemFolderConfiguration;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.util.VersionUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ProjectFileServiceManager {
    private static final String MIGRATE_LEGACY_GLOBALVARIABLE_VS = "5.4.0";
    private static final String MIGRATE_SOURCE_CONTENT_VS = "5.7.0";
    private static final String MIGRATE_INTERNAL_LOGGING_VS = "5.9.0";

    public static ProjectEntity addNewProject(String name, String description, short pageLoadTimeout, String projectLocation) throws Exception {
        File projectFolder;
        if (projectLocation.endsWith(File.separator)) {
            projectLocation = projectLocation.substring(0, projectLocation.length() - 1);
        }
        if (!(projectFolder = new File(String.valueOf(projectLocation) + File.separator + name)).exists()) {
            projectFolder.mkdirs();
        }
        ProjectEntity project = ProjectFileServiceManager.newProjectEntity(name, description, projectLocation, false);
        FolderFileServiceManager.initRootEntityFolders(project);
        ProjectFileServiceManager.createSettingFolder(project);
        GlobalVariableFileServiceManager.newProfile("default", true, Collections.emptyList(), project);
        ProjectFileServiceManager.migrateNewIncludeFolder(project);
        ProjectFileServiceManager.migrateNewConfigFolder(project);
        return project;
    }

    public static ProjectEntity getProject(String projectFileLocation) throws Exception {
        File projectFile = new File(projectFileLocation);
        if (projectFile.isFile() && projectFile.exists()) {
            ProjectEntity project = (ProjectEntity)EntityService.getInstance().getEntityByPath(projectFileLocation);
            project.setFolderLocation(projectFile.getParent());
            ProjectFileServiceManager.createSettingFolder(project);
            return project;
        }
        return null;
    }

    public static ProjectEntity openProjectWithoutClasspath(String projectFileLocation) throws Exception {
        File projectFile = new File(projectFileLocation);
        if (projectFile.isFile() && projectFile.exists()) {
            ProjectEntity project = (ProjectEntity)EntityService.getInstance().getEntityByPath(projectFileLocation);
            project.setFolderLocation(projectFile.getParent());
            ProjectFileServiceManager.createSettingFolder(project);
            FolderFileServiceManager.initRootEntityFolders(project);
            String migratedVersion = project.getMigratedVersion();
            if (StringUtils.isEmpty((String)migratedVersion) || VersionUtil.isNewer((String)MIGRATE_LEGACY_GLOBALVARIABLE_VS, (String)migratedVersion)) {
                ProjectFileServiceManager.migrateLegacyGlobalVariable(project);
                project.setMigratedVersion(MIGRATE_LEGACY_GLOBALVARIABLE_VS);
                EntityService.getInstance().saveEntity((FileEntity)project);
            }
            if (StringUtils.isEmpty((String)migratedVersion) || VersionUtil.isNewer((String)MIGRATE_SOURCE_CONTENT_VS, (String)migratedVersion)) {
                ProjectFileServiceManager.migrateNewIncludeFolder(project);
            }
            if (StringUtils.isEmpty((String)migratedVersion) || VersionUtil.isNewer((String)MIGRATE_INTERNAL_LOGGING_VS, (String)migratedVersion)) {
                ProjectFileServiceManager.migrateNewConfigFolder(project);
            }
            if (GlobalVariableFileServiceManager.getAll(project).isEmpty()) {
                GlobalVariableFileServiceManager.newProfile("default", true, Collections.emptyList(), project);
            }
            return project;
        }
        return null;
    }

    private static void migrateNewIncludeFolder(ProjectEntity project) throws Exception {
        project.getSourceContent().addSourceFolder(new SourceFolderConfiguration(FileServiceConstant.GROOVY_SCRIPTS_INCLUDE_FOLDER));
        project.getSourceContent().addSystemFolder(new SystemFolderConfiguration(FileServiceConstant.GROOVY_SCRIPTS_INCLUDE_FOLDER));
        project.getSourceContent().addSystemFolder(new SystemFolderConfiguration(FileServiceConstant.FEATURES_INCLUDE_FOLDER));
        project.setMigratedVersion(MIGRATE_SOURCE_CONTENT_VS);
        EntityService.getInstance().saveEntity((FileEntity)project);
    }

    private static void migrateNewConfigFolder(ProjectEntity project) throws Exception {
        project.getSourceContent().addSystemFolder(new SystemFolderConfiguration(FileServiceConstant.CONFIG_INCLUDE_FOLDER));
        String projectLocation = project.getFolderLocation();
        File configFolder = new File(FileServiceConstant.getConfigFolderLocation(projectLocation));
        ProjectFileServiceManager.createDefaultLogConfigFile(configFolder);
        project.setMigratedVersion(MIGRATE_INTERNAL_LOGGING_VS);
        EntityService.getInstance().saveEntity((FileEntity)project);
    }

    private static void createDefaultLogConfigFile(File configFolder) {
        if (configFolder == null || !configFolder.exists()) {
            return;
        }
        try {
            File configFile = new File(configFolder, "log.properties");
            if (!configFile.exists()) {
                configFile.createNewFile();
                Bundle bundle = FrameworkUtil.getBundle(ProjectFileServiceManager.class);
                Path templateFilePath = new Path("/res/config/log.properties");
                URL templateFileUrl = FileLocator.find((Bundle)bundle, (IPath)templateFilePath, null);
                FileUtils.copyURLToFile((URL)FileLocator.toFileURL((URL)templateFileUrl), (File)configFile);
            }
        }
        catch (IOException iOException) {}
    }

    private static void migrateLegacyGlobalVariable(ProjectEntity project) throws Exception {
        ExecutionProfileEntity legacyGlobalVariable = (ExecutionProfileEntity)EntityService.getInstance().getEntityByPath(FileServiceConstant.getLegacyGlobalVariableFileLocation(project.getFolderLocation()));
        if (legacyGlobalVariable == null) {
            return;
        }
        GlobalVariableFileServiceManager.newProfile("default", true, legacyGlobalVariable.getGlobalVariableEntities(), project);
    }

    public static ProjectEntity updateProject(String name, String description, String projectFileLocation, short pageLoadTimeout) throws Exception {
        ProjectEntity project = ProjectFileServiceManager.getProject(projectFileLocation);
        IProject oldGroovyProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
        project.setName(name);
        project.setDescription(description);
        project.setPageLoadTimeout(pageLoadTimeout);
        if (!project.getLocation().equals(projectFileLocation)) {
            EntityService.getInstance().getEntityCache().remove((FileEntity)project, true);
            try {
                GroovyUtil.updateGroovyProject((ProjectEntity)project, (IProject)oldGroovyProject);
            }
            catch (CoreException coreException) {
                throw new DALException(StringConstants.MNG_EXC_FAILED_TO_UPDATE_PROJ);
            }
        }
        EntityService.getInstance().saveEntity((FileEntity)project);
        return project;
    }

    public static boolean isDuplicationProjectName(String name, String projectFolderLocation) throws Exception {
        EntityService.getInstance().validateName(name);
        return ProjectFileServiceManager.getProject(String.valueOf(projectFolderLocation) + File.separator + name + File.separator + name + ProjectEntity.getProjectFileExtension()) != null;
    }

    private static void createSettingFolder(ProjectEntity project) throws IOException {
        File internalSettingFolder;
        File externalSettingFolder;
        File settingFolder = new File(String.valueOf(project.getFolderLocation()) + File.separator + "settings");
        if (!settingFolder.exists()) {
            settingFolder.mkdir();
        }
        if (!(externalSettingFolder = new File(String.valueOf(project.getFolderLocation()) + File.separator + FileServiceConstant.EXTERNAL_SETTING_DIR)).exists()) {
            externalSettingFolder.mkdir();
        }
        if (!(internalSettingFolder = new File(String.valueOf(project.getFolderLocation()) + File.separator + FileServiceConstant.INTERNAL_SETTING_DIR)).exists()) {
            internalSettingFolder.mkdir();
        }
    }

    public static ProjectEntity newProjectEntity(String name, String description, String projectLocation, boolean legacy) throws DALException {
        File projectFolder;
        if (projectLocation.endsWith(File.separator)) {
            projectLocation = projectLocation.substring(0, projectLocation.length() - 1);
        }
        if (!(projectFolder = new File(String.valueOf(projectLocation) + File.separator + name)).exists()) {
            projectFolder.mkdirs();
        }
        ProjectEntity project = new ProjectEntity();
        project.setUUID(Util.generateGuid());
        project.setFolderLocation(projectFolder.getAbsolutePath());
        project.setName(name);
        project.setDescription(description);
        if (!legacy) {
            project.setMigratedVersion(MIGRATE_LEGACY_GLOBALVARIABLE_VS);
        }
        try {
            EntityService.getInstance().saveEntity((FileEntity)project);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
        return project;
    }
}

