/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.core.ast.RequireAstTestStepTransformation;
import com.kms.katalon.core.export.ExportTestCaseHelper;
import com.kms.katalon.core.export.ExportTestCaseScript;
import com.kms.katalon.dal.exception.TaskCancelledException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.execution.webui.driver.SeleniumWebDriverProvider;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExportFileServiceManager {
    private int progress;
    private boolean isCancelled;
    List<String> exportedTestCaseLocations;
    Queue<String> logs;
    private static final String TEST_SCRIPT_SOURCE_FOLDER_NAME = "Scripts";
    private static final String TEST_CASE_ROOT_FOLDER_NAME = "Test Cases";
    private static final String LIB_FOLDER_NAME = "Libs";
    private static final String CLASSPATH_FILE_NAME = ".classpath";

    public boolean exportProject(ProjectEntity project, String destination) throws Exception {
        try {
            this.progress = 0;
            this.isCancelled = false;
            File currentProjectLocation = new File(project.getFolderLocation());
            File exportProjectLocation = new File(destination);
            FileUtils.copyDirectory((File)currentProjectLocation, (File)exportProjectLocation);
            this.validateProgress(1);
            this.copyResourcesToExportedProject(exportProjectLocation);
            this.validateProgress(1);
            this.convertScriptFile(new File(String.valueOf(exportProjectLocation.getAbsolutePath()) + File.separator + TEST_SCRIPT_SOURCE_FOLDER_NAME), exportProjectLocation);
            this.validateProgress(1);
            this.copyLibrariesToExportedProject(project, destination);
            this.validateProgress(1);
        }
        catch (Exception e) {
            File destinationFolder = new File(destination);
            if (destinationFolder.exists() && destinationFolder.isDirectory()) {
                FileUtils.deleteDirectory((File)destinationFolder);
            }
            throw e;
        }
        return true;
    }

    private void copyResourcesToExportedProject(File exportProjectFolder) throws IOException {
        FileUtils.copyDirectory((File)SeleniumWebDriverProvider.getDriverDirectory(), (File)new File(String.valueOf(exportProjectFolder.getAbsolutePath()) + File.separator + "resources" + File.separator + "drivers"));
    }

    private void copyLibrariesToExportedProject(ProjectEntity project, String destination) throws JavaModelException, IOException, ParserConfigurationException, SAXException, TransformerException {
        HashMap<String, String> libsChangedLocation = new HashMap<String, String>();
        File libFolder = new File(String.valueOf(destination) + File.separator + LIB_FOLDER_NAME);
        IProject iProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
        IJavaProject javaProject = JavaCore.create((IProject)iProject);
        for (IClasspathEntry entry : Arrays.asList(javaProject.getRawClasspath())) {
            File libFile;
            if (entry.getEntryKind() != 1 || !(libFile = new File(entry.getPath().toOSString())).exists() || !libFile.isFile()) continue;
            FileUtils.copyFileToDirectory((File)libFile, (File)libFolder);
            libsChangedLocation.put(libFile.getAbsolutePath().replace(File.separator, "/"), (String.valueOf(libFolder.getAbsolutePath()) + File.separator + libFile.getName()).replace(File.separator, "/"));
        }
        File classPathFile = new File(String.valueOf(project.getFolderLocation()) + File.separator + CLASSPATH_FILE_NAME);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(classPathFile);
        NodeList classPathEntryNodeList = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < classPathEntryNodeList.getLength()) {
            Node pathAttributeNode;
            Node kindAttributeNode;
            Node classPathEntry = classPathEntryNodeList.item(i);
            if (classPathEntry.getAttributes() != null && (kindAttributeNode = classPathEntry.getAttributes().getNamedItem("kind")) != null && kindAttributeNode.getNodeValue().equals("lib") && (pathAttributeNode = classPathEntry.getAttributes().getNamedItem("path")) != null && libsChangedLocation.get(pathAttributeNode.getNodeValue()) != null && !((String)libsChangedLocation.get(pathAttributeNode.getNodeValue())).isEmpty()) {
                pathAttributeNode.setNodeValue((String)libsChangedLocation.get(pathAttributeNode.getNodeValue()));
            }
            ++i;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(String.valueOf(destination) + File.separator + CLASSPATH_FILE_NAME));
        transformer.transform(source, result);
    }

    public void convertGroovyScriptIntoExportScript(List<ASTNode> astNodes, String testCaseId, File exportProjectFolder) throws IOException {
        ClassNode mainClass = null;
        for (ASTNode astNode : astNodes) {
            if (!(astNode instanceof ClassNode)) continue;
            mainClass = (ClassNode)astNode;
            break;
        }
        if (mainClass != null) {
            mainClass.setSuperClass(new ClassNode(ExportTestCaseScript.class));
            mainClass.addAnnotation(new AnnotationNode(new ClassNode(RequireAstTestStepTransformation.class)));
            MethodNode method = (MethodNode)mainClass.getMethods("main").get(0);
            this.convertMainMethod(testCaseId, exportProjectFolder, method);
            mainClass.getModule().addImport("ExportTestCaseHelper", new ClassNode(ExportTestCaseHelper.class));
        }
    }

    protected void convertMainMethod(String testCaseId, File exportProjectFolder, MethodNode method) throws IOException {
        BlockStatement blockStatement = new BlockStatement();
        ArrayList<Object> argumentList = new ArrayList<Object>();
        argumentList.add(new VariableExpression("this"));
        argumentList.add(new ConstantExpression((Object)testCaseId));
        argumentList.add(new ConstantExpression((Object)exportProjectFolder.getAbsolutePath()));
        argumentList.add(new ConstantExpression((Object)this.getDefaultDriver()));
        switch (this.getDefaultDriver()) {
            case "Chrome": {
                argumentList.add(new ConstantExpression((Object)this.getDriverNewLocation(SeleniumWebDriverProvider.getChromeDriverPath(), exportProjectFolder)));
                break;
            }
            case "IE": {
                argumentList.add(new ConstantExpression((Object)this.getDriverNewLocation(SeleniumWebDriverProvider.getIEDriverPath(), exportProjectFolder)));
                break;
            }
            default: {
                argumentList.add(new ConstantExpression(null));
            }
        }
        argumentList.add(new ConstantExpression((Object)ExportFileServiceManager.getDefaultPageLoadTimeout()));
        blockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression("super"), "main", (Expression)new ArgumentListExpression(argumentList))));
        method.setCode((Statement)blockStatement);
        method.setLineNumber(1);
        method.setModifiers(8);
    }

    protected String getDriverNewLocation(String oldLocation, File exportProjectLocation) {
        String driverPath = oldLocation.substring(oldLocation.lastIndexOf("resources"), oldLocation.length());
        return String.valueOf(exportProjectLocation.getAbsolutePath()) + File.separator + driverPath;
    }

    private String getDefaultDriver() {
        return "Firefox";
    }

    public static int getDefaultPageLoadTimeout() {
        return 30;
    }

    public void convertScriptFile(File file, File exportProjectFolder) throws IOException, Exception {
        if (file.exists() && file.isFile() && file.getName().endsWith(".groovy")) {
            String script = FileUtils.readFileToString((File)file);
            script = script.replaceAll(".*.callTestCase", "ExportTestCaseHelper.callTestCase");
            List groovyAst = GroovyParser.parseGroovyScriptIntoAstNodes((String)script);
            this.convertGroovyScriptIntoExportScript(groovyAst, this.getTestCaseIdFromScriptFile(file, exportProjectFolder), exportProjectFolder);
            StringBuilder stringBuilder = new StringBuilder();
            GroovyParser parser = new GroovyParser(stringBuilder);
            parser.parseGroovyAstIntoClass(groovyAst);
            FileUtils.writeStringToFile((File)file, (String)stringBuilder.toString());
        } else if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.convertScriptFile(childFile, exportProjectFolder);
                ++n2;
            }
        }
    }

    private String getTestCaseIdFromScriptFile(File scriptFile, File exportProjectFolder) {
        String testCaseRelativeId = scriptFile.getAbsolutePath().replace(String.valueOf(exportProjectFolder.getAbsolutePath()) + File.separator, "").replace(TEST_SCRIPT_SOURCE_FOLDER_NAME + File.separator, "").replace(String.valueOf(File.separator) + scriptFile.getName(), "");
        return TEST_CASE_ROOT_FOLDER_NAME + File.separator + testCaseRelativeId;
    }

    public boolean exportSeletectTestCases(List<TestCaseEntity> testCases, ProjectEntity project, String destination) throws Exception {
        try {
            this.progress = 0;
            this.isCancelled = false;
            this.logs = new LinkedList<String>();
            this.exportedTestCaseLocations = new ArrayList<String>();
            for (TestCaseEntity testCase : testCases) {
                this.exportSelectedTestCase(testCase, project, destination);
                this.exportedTestCaseLocations.add(testCase.getLocation());
            }
            this.exportProjectEntity(project, destination);
            this.validateProgress(1);
            this.validateProgress(2);
        }
        catch (Exception e) {
            File destinationFolder = new File(destination);
            if (destinationFolder.exists() && destinationFolder.isDirectory()) {
                FileUtils.deleteDirectory((File)destinationFolder);
            }
            throw e;
        }
        return true;
    }

    private void exportSelectedTestCase(TestCaseEntity testCase, ProjectEntity project, String destination) throws Exception {
        this.exportTestCase(testCase, destination);
        this.validateProgress(4);
        for (DataFileEntity dataFile : testCase.getDataFiles()) {
            this.exportDataFile(dataFile, destination);
        }
        this.validateProgress(4);
    }

    private void exportEntity(FileEntity entity, String destination) throws IOException {
        File entityFile = new File(entity.getLocation());
        File destinationFolder = new File(destination);
        if (entityFile.exists() && entityFile.isFile()) {
            if (!destinationFolder.exists()) {
                destinationFolder.mkdirs();
            }
            FileUtils.copyFileToDirectory((File)entityFile, (File)destinationFolder);
        }
    }

    private void exportProjectEntity(ProjectEntity project, String destination) throws Exception {
        File destinationFolder = new File(destination);
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        EntityService.getInstance().saveEntity((FileEntity)project, String.valueOf(destination) + File.separator + project.getName() + ProjectEntity.getProjectFileExtension());
    }

    private void exportTestCase(TestCaseEntity testCase, String destination) throws Exception {
        this.exportEntity((FileEntity)testCase, String.valueOf(destination) + File.separator + this.getRelativePath(testCase));
    }

    private void exportDataFile(DataFileEntity dataFile, String destination) throws Exception {
        this.exportEntity((FileEntity)dataFile, String.valueOf(destination) + File.separator + this.getRelativePath(dataFile));
    }

    private String getRelativePath(FolderEntity folder) {
        return folder.getParentFolder() == null ? folder.getName() : String.valueOf(this.getRelativePath(folder.getParentFolder())) + File.separator + folder.getName();
    }

    private String getRelativePath(TestCaseEntity testCase) {
        return this.getRelativePath(testCase.getParentFolder());
    }

    private String getRelativePath(DataFileEntity dataFile) {
        return this.getRelativePath(dataFile.getParentFolder());
    }

    private boolean checkCancel() {
        return this.isCancelled;
    }

    public void cancelExport() {
        this.isCancelled = false;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    private void validateProgress(int progressIncrease) throws TaskCancelledException {
        this.progress += progressIncrease;
        if (this.checkCancel()) {
            throw new TaskCancelledException();
        }
    }
}

