/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.exception.NullAttributeException;
import com.kms.katalon.dal.fileservice.EntityCache;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.NullArgumentException;
import org.eclipse.core.runtime.CoreException;

public class CheckpointFileServiceManager {
    public static CheckpointEntity getById(String id) throws DALException {
        try {
            FileEntity entity = EntityFileServiceManager.get(new File(id));
            if (entity instanceof CheckpointEntity) {
                return (CheckpointEntity)entity;
            }
            return null;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static CheckpointEntity create(CheckpointEntity checkpoint) throws DALException {
        CheckpointFileServiceManager.validateCheckpoint(checkpoint);
        try {
            CheckpointFileServiceManager.getEntityService().validateName(checkpoint.getName());
            CheckpointFileServiceManager.getEntityService().saveEntity((FileEntity)checkpoint);
            FolderFileServiceManager.refreshFolder(checkpoint.getParentFolder());
            return checkpoint;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static CheckpointEntity update(CheckpointEntity checkpoint) throws DALException {
        CheckpointFileServiceManager.validateCheckpoint(checkpoint);
        try {
            CheckpointFileServiceManager.getEntityService().validateName(checkpoint.getName());
            EntityCache entityCache = CheckpointFileServiceManager.getEntityService().getEntityCache();
            String oldLocation = entityCache.getKey((FileEntity)checkpoint);
            if (entityCache.contains((FileEntity)checkpoint) && !checkpoint.getLocation().equals(oldLocation)) {
                entityCache.remove((FileEntity)checkpoint, true);
                ProjectEntity project = checkpoint.getProject();
                String oldRelativeLocation = oldLocation.substring(new File(project.getLocation()).getParent().length() + 1);
                String oldCheckpointId = FilenameUtils.removeExtension((String)oldRelativeLocation).replace(File.separator, "/");
                TestArtifactScriptRefactor.createForCheckpointEntity((String)oldCheckpointId).updateReferenceForProject(checkpoint.getIdForDisplay(), project);
            }
            CheckpointFileServiceManager.getEntityService().saveEntity((FileEntity)checkpoint);
            FolderFileServiceManager.refreshFolder(checkpoint.getParentFolder());
            return checkpoint;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static void delete(CheckpointEntity checkpoint) throws DALException {
        if (checkpoint == null) {
            return;
        }
        try {
            EntityFileServiceManager.delete((FileEntity)checkpoint);
            FolderFileServiceManager.refreshFolder(checkpoint.getParentFolder());
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static CheckpointEntity copy(CheckpointEntity checkpoint, FolderEntity destinationFolder) throws DALException {
        try {
            CheckpointEntity copiedCheckpoint = EntityFileServiceManager.copy(checkpoint, destinationFolder);
            FolderFileServiceManager.refreshFolder(destinationFolder);
            return copiedCheckpoint;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static CheckpointEntity move(CheckpointEntity checkpoint, FolderEntity destinationFolder) throws DALException {
        try {
            String oldCheckpointId = checkpoint.getIdForDisplay();
            FolderEntity originParentFolder = checkpoint.getParentFolder();
            CheckpointEntity movedCheckpoint = EntityFileServiceManager.move(checkpoint, destinationFolder);
            FolderFileServiceManager.refreshFolder(originParentFolder);
            FolderFileServiceManager.refreshFolder(destinationFolder);
            if (movedCheckpoint != null) {
                TestArtifactScriptRefactor.createForCheckpointEntity((String)oldCheckpointId).updateReferenceForProject(movedCheckpoint.getIdForDisplay(), movedCheckpoint.getProject());
            }
            return movedCheckpoint;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public static void updateFolderCheckpointReferences(FolderEntity checkpointFolder, String oldDisplayedId) throws CoreException, IOException {
        TestArtifactScriptRefactor.createForCheckpointEntity((String)oldDisplayedId).updateReferenceForProject(checkpointFolder.getIdForDisplay(), checkpointFolder.getProject());
    }

    private static EntityService getEntityService() throws Exception {
        return EntityService.getInstance();
    }

    private static void validateCheckpoint(CheckpointEntity checkpoint) throws DALException {
        try {
            if (checkpoint == null) {
                throw new NullArgumentException(StringConstants.MNG_EXC_CHECKPOINT_IS_NULL);
            }
            if (checkpoint.getProject() == null) {
                throw new NullAttributeException(StringConstants.MNG_EXC_PROJECT_IS_NULL);
            }
            if (checkpoint.getParentFolder() == null) {
                throw new NullAttributeException(StringConstants.MNG_EXC_PARENT_FOLDER_IS_NULL);
            }
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

