/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IReportDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.ReportFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ReportFileServiceDataProvider
implements IReportDataProvider {
    public String getTemporaryLogDirectory(FileEntity systemFileEntity) throws DALException {
        File systemFileLogDir = new File(FileServiceConstant.TEMP_DIR, systemFileEntity.getIdForDisplay());
        try {
            ReportFileServiceManager.ensureFolderExist(systemFileLogDir);
            return systemFileLogDir.getAbsolutePath();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public String getLogDirectory(TestSuiteEntity testSuite) throws Exception {
        File testSuiteLogDir = new File(ReportFileServiceManager.getReportFolderOfTestSuite(testSuite.getProject(), testSuite));
        ReportFileServiceManager.ensureFolderExist(testSuiteLogDir);
        return testSuiteLogDir.getAbsolutePath();
    }

    public ReportEntity getReportEntity(ProjectEntity project, TestSuiteEntity testSuite, String reportName) throws Exception {
        File reportFile;
        String testSuiteReportFolderPath = ReportFileServiceManager.getReportFolderOfTestSuite(project, testSuite);
        FolderEntity parentFolder = FolderFileServiceManager.getFolder(testSuiteReportFolderPath);
        ReportEntity report = ReportFileServiceManager.getReportEntity(String.valueOf(testSuiteReportFolderPath) + File.separator + reportName);
        if (report == null) {
            report = ReportFileServiceManager.createReportEntity(reportName, parentFolder);
        }
        if ((reportFile = new File(report.getId())).exists()) {
            return report;
        }
        return null;
    }

    public List<ReportEntity> listReportEntities(TestSuiteEntity testSuite, ProjectEntity project) throws Exception {
        String testSuiteReportFolderPath = ReportFileServiceManager.getReportFolderOfTestSuite(project, testSuite);
        File testSuiteReportFolder = new File(testSuiteReportFolderPath);
        ArrayList<ReportEntity> lstReport = new ArrayList<ReportEntity>();
        if (testSuiteReportFolder.exists() && testSuiteReportFolder.isDirectory()) {
            File[] fileArray = testSuiteReportFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childReportFolder = fileArray[n2];
                if (childReportFolder.exists() && childReportFolder.isDirectory()) {
                    lstReport.add(ReportFileServiceManager.getReportEntity(childReportFolder.getAbsolutePath()));
                }
                ++n2;
            }
        }
        return lstReport;
    }

    public String getEntityPk(ReportEntity report) {
        return report.getLocation();
    }

    public void deleteReport(ReportEntity report) throws Exception {
        FileUtils.deleteDirectory((File)new File(report.getLocation()));
    }

    public ReportEntity getReportEntity(String reportPk) throws Exception {
        return ReportFileServiceManager.getReportEntity(reportPk);
    }

    public ReportEntity updateReport(ReportEntity report) throws Exception {
        EntityService.getInstance().saveIntergratedFolderMetadataEntity((IntegratedFileEntity)report);
        return report;
    }

    public FolderEntity getReportFolder(TestSuiteEntity testSuite, ProjectEntity project) throws Exception {
        return FolderFileServiceManager.getFolder(ReportFileServiceManager.getReportFolderOfTestSuite(project, testSuite));
    }

    private String getReportCollectionEntityLocation(ProjectEntity project, TestSuiteCollectionEntity entity) throws DALException {
        try {
            return String.valueOf(project.getFolderLocation()) + File.separator + entity.getIdForDisplay().replaceFirst(FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME, FileServiceConstant.REPORT_ROOT_FOLDER_NAME).replace("/", File.separator);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity newReportCollectionEntity(ProjectEntity project, TestSuiteCollectionEntity tsEntity, String newName) throws DALException {
        try {
            File folder = new File(this.getReportCollectionEntityLocation(project, tsEntity), newName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            FolderEntity parentFolder = FolderFileServiceManager.getFolder(folder.getAbsolutePath());
            ReportCollectionEntity reportCollection = new ReportCollectionEntity();
            reportCollection.setName(newName);
            reportCollection.setParentFolder(parentFolder);
            reportCollection.setProject(parentFolder.getProject());
            return reportCollection;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity getReportCollectionEntity(ProjectEntity project, TestSuiteCollectionEntity entity, String reportName) throws DALException {
        try {
            FolderEntity parentFolder = FolderFileServiceManager.getFolder(String.valueOf(this.getReportCollectionEntityLocation(project, entity)) + File.separator + reportName);
            return this.getReportCollectionEntity(String.valueOf(parentFolder.getId()) + File.separator + reportName + ".rp");
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity getReportCollectionEntity(String id) throws DALException {
        try {
            ReportCollectionEntity reportCollection = (ReportCollectionEntity)this.getEntityService().getEntityByPath(id);
            FolderEntity parentFolder = FolderFileServiceManager.getFolder(new File(id).getParent());
            reportCollection.setParentFolder(parentFolder);
            reportCollection.setProject(parentFolder.getProject());
            return reportCollection;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    private EntityService getEntityService() throws DALException {
        try {
            return EntityService.getInstance();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void updateReportCollectionEntity(ReportCollectionEntity collectionReport) throws DALException {
        try {
            this.getEntityService().saveEntity((FileEntity)collectionReport, collectionReport.getId());
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void deleteReportCollection(ReportCollectionEntity reportCollection) throws DALException {
        try {
            EntityService.getInstance().deleteEntity((FileEntity)reportCollection);
            FolderFileServiceManager.deleteFolder(reportCollection.getParentFolder());
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportEntity renameReport(ReportEntity report, String newName) throws DALException {
        try {
            return ReportFileServiceManager.renameReport(report, newName);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity renameCollectionReport(ReportCollectionEntity collectionReport, String newName) throws DALException {
        try {
            return ReportFileServiceManager.renameReportCollection(collectionReport, newName);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

