/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IDataFileDataProvider;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.manager.DataFileFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.DataFilePropertyInputEntity;
import com.kms.katalon.entity.testdata.InternalDataFilePropertyEntity;
import java.io.File;
import java.util.List;
import java.util.Map;

public class DataFileFileServiceDataProvider
implements IDataFileDataProvider {
    public DataFileEntity saveNewTestData(DataFileEntity newTestData) throws Exception {
        return DataFileFileServiceManager.saveNewTestData(newTestData);
    }

    public String getAvailableDataFileName(FolderEntity parentFolder, String name) throws Exception {
        return DataFileFileServiceManager.getAvailableDataFileName(parentFolder, name);
    }

    public DataFileEntity getDataFile(String dataFilePk) throws Exception {
        return DataFileFileServiceManager.getDataFile(dataFilePk);
    }

    public List<DataFileEntity> getDataFileByFolder(FolderEntity parentFolder) throws Exception {
        return FolderFileServiceManager.getChildDataFilesOfFolder(parentFolder);
    }

    public DataFileEntity updateInternalDataFileProperty(InternalDataFilePropertyEntity internalData) throws Exception {
        return DataFileFileServiceManager.updateInternalDataFileProperty(internalData, DataProviderState.getInstance().getCurrentProject());
    }

    public DataFileEntity updateDataFileProperty(DataFilePropertyInputEntity dataFilePropertyInput) throws Exception {
        return DataFileFileServiceManager.updateDataFileProperty(dataFilePropertyInput, DataProviderState.getInstance().getCurrentProject());
    }

    public void deleteDataFile(DataFileEntity dataFile) throws Exception {
        DataFileFileServiceManager.deleteDataFile(dataFile);
    }

    public DataFileEntity updateTestData(DataFileEntity newDataFile) throws Exception {
        return DataFileFileServiceManager.updateTestData(newDataFile);
    }

    public DataFileEntity copyDataFile(DataFileEntity dataFile, FolderEntity destinationFolder) throws Exception {
        return DataFileFileServiceManager.copyDataFile(dataFile, destinationFolder);
    }

    public DataFileEntity moveDataFile(DataFileEntity dataFile, FolderEntity destinationFolder) throws Exception {
        return DataFileFileServiceManager.moveDataFile(dataFile, destinationFolder);
    }

    public String getIdForDisplay(DataFileEntity entity) throws Exception {
        return entity.getRelativePathForUI();
    }

    public boolean validateDataFileName(FolderEntity parentFolder, String name) throws Exception {
        if (name == null || name.isEmpty()) {
            throw new InvalidNameException(StringConstants.DP_EXC_NAME_CANNOT_BE_NULL_OR_EMPTY);
        }
        if (!EntityService.getInstance().getAvailableName(parentFolder.getLocation(), name, true).equalsIgnoreCase(name)) {
            throw new InvalidNameException(StringConstants.DP_EXC_NAME_ALREADY_EXISTED);
        }
        EntityService.getInstance().validateName(name);
        return true;
    }

    public DataFileEntity getDataFileByDisplayId(String dataFileId) throws Exception {
        ProjectEntity project = DataProviderState.getInstance().getCurrentProject();
        String projectLocation = project.getFolderLocation();
        String dataFileValue = String.valueOf(projectLocation) + File.separator + dataFileId + DataFileEntity.getTestDataFileExtension();
        return this.getDataFile(dataFileValue);
    }

    public Map<String, List<TestSuiteTestCaseLink>> getTestDataReferences(DataFileEntity dataFileEntity) throws Exception {
        return DataFileFileServiceManager.getTestDataReferences(dataFileEntity);
    }
}

