/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice;

import com.kms.katalon.entity.file.FileEntity;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EntityCache {
    private Map<String, FileEntity> entities = new ConcurrentHashMap<String, FileEntity>();

    public FileEntity get(String pk) {
        return this.entities.get(pk.trim());
    }

    public void put(String pk, FileEntity entity) {
        if (pk != null) {
            this.entities.put(pk.trim(), entity);
        }
    }

    public void remove(FileEntity entity, boolean deteleFile) {
        for (String key : this.entities.keySet()) {
            FileEntity ent = this.entities.get(key);
            if (ent != entity) continue;
            this.entities.remove(key);
            if (!deteleFile) break;
            File file = new File(key);
            file.delete();
            break;
        }
    }

    public void remove(String key) {
        this.entities.remove(key.trim());
    }

    public boolean contains(String pk) {
        return this.entities.containsKey(pk.trim());
    }

    public boolean contains(FileEntity entity) {
        return this.entities.values().contains(entity);
    }

    public String getKey(FileEntity entity) {
        for (String key : this.entities.keySet()) {
            FileEntity ent = this.entities.get(key);
            if (ent != entity) continue;
            return key;
        }
        return null;
    }

    public void replaceKeys(String oldKey, String newKey) {
        FileEntity value = this.entities.get(oldKey);
        if (value != null) {
            this.entities.remove(oldKey);
            this.entities.put(newKey, value);
        }
        for (String key : this.entities.keySet()) {
            if (!key.startsWith(String.valueOf(oldKey) + File.separator)) continue;
            FileEntity childValue = this.entities.get(key);
            this.entities.remove(key);
            this.entities.put(String.valueOf(newKey) + File.separator + key.substring((String.valueOf(oldKey) + File.separator).length()), childValue);
        }
    }

    public void saveCache() {
    }

    public void loadCacheFromFile(String filePath) {
    }

    public void clear() {
        this.entities.clear();
    }
}

