/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webservice;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.execution.configuration.WSVerificationRunConfiguration;
import com.kms.katalon.execution.entity.WSVerificationTestCaseExecutedEntity;
import com.kms.katalon.execution.launcher.VerificationScriptLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.util.ExecutionProfileStore;
import org.eclipse.e4.core.services.events.IEventBroker;

public class VerificationScriptExecutor {
    private static final String WS_VERIFICATION = "WSVerification_";
    private String executorId = String.valueOf(System.currentTimeMillis());
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private VerificationScriptLauncher launcher;
    private WSVerificationTestCaseEntity testCaseEntity;

    public void execute(final String requestObjectId, String script, ResponseObject responseObject) throws Exception {
        this.testCaseEntity = this.createTestCaseEntity(script, responseObject);
        WSVerificationRunConfiguration runConfig = new WSVerificationRunConfiguration(requestObjectId, responseObject);
        runConfig.setExecutionProfile(ExecutionProfileStore.getInstance().getSelectedProfile());
        runConfig.build((FileEntity)this.testCaseEntity, new WSVerificationTestCaseExecutedEntity(this.testCaseEntity));
        LauncherManager launcherManager = LauncherManager.getInstance();
        this.launcher = new VerificationScriptLauncher(requestObjectId, launcherManager, runConfig, new Runnable(){

            @Override
            public void run() {
                ILauncherResult result = VerificationScriptExecutor.this.launcher.getResult();
                TestStatus.TestStatusValue[] statusValues = result.getResultValues();
                VerificationScriptExecutor.this.eventBroker.post("WS_VERIFICATION/EXECUTION_FINISHED", (Object)new Object[]{requestObjectId, statusValues[0]});
            }
        });
        launcherManager.addLauncher(this.launcher);
    }

    public String getExecutorId() {
        return this.executorId;
    }

    private WSVerificationTestCaseEntity createTestCaseEntity(String script, ResponseObject responseObject) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        WSVerificationTestCaseEntity testCaseEntity = new WSVerificationTestCaseEntity();
        testCaseEntity.setId(WS_VERIFICATION + System.currentTimeMillis());
        testCaseEntity.setProject(project);
        testCaseEntity.setScript(script);
        return testCaseEntity;
    }
}

