/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webservice;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.configuration.ExistingRunConfiguration;
import com.kms.katalon.execution.entity.WSVerificationTestCaseExecutedEntity;
import com.kms.katalon.execution.launcher.RecordingScriptLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.util.ExecutionProfileStore;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RecordingScriptGenerator {
    private static final String WEBUI_VERIFICATION = "WebUIVerifition_";
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private RecordingScriptLauncher launcher;
    private String capturedTestObjectsCacheFile;

    public RecordingScriptGenerator(String recordSessionFolder) {
        this.capturedTestObjectsCacheFile = recordSessionFolder;
    }

    public void execute(String script, List<VariableEntity> variables, WebDriver webDriver, WebUIDriverType driverType, ProjectEntity project) throws Exception {
        WSVerificationTestCaseEntity testCaseEntity = this.createTestCaseEntity(script, variables);
        RecodingRunConfiguration runConfig = new RecodingRunConfiguration(project.getFolderLocation(), ((RemoteWebDriver)webDriver).getSessionId().toString(), DriverFactory.getWebDriverServerUrl((RemoteWebDriver)((RemoteWebDriver)webDriver)), driverType.getName());
        runConfig.setExecutionProfile(ExecutionProfileStore.getInstance().getSelectedProfile());
        runConfig.build((FileEntity)testCaseEntity, new WSVerificationTestCaseExecutedEntity(testCaseEntity));
        LauncherManager launcherManager = LauncherManager.getInstance();
        this.launcher = new RecordingScriptLauncher(launcherManager, runConfig, new Runnable(){

            @Override
            public void run() {
                ILauncherResult result = RecordingScriptGenerator.this.launcher.getResult();
                TestStatus.TestStatusValue[] statusValues = result.getResultValues();
                RecordingScriptGenerator.this.eventBroker.post("WEBUI_VERIFICATION/EXECUTION_FINISHED", (Object)statusValues[0]);
            }
        }){

            @Override
            protected void onStartExecutionComplete() {
                super.onStartExecutionComplete();
                RecordingScriptGenerator.this.eventBroker.post("WEBUI_VERIFICATION/START_EXECUTION", null);
            }
        };
        launcherManager.addLauncher(this.launcher);
    }

    private WSVerificationTestCaseEntity createTestCaseEntity(String script, List<VariableEntity> variables) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        WSVerificationTestCaseEntity testCaseEntity = new WSVerificationTestCaseEntity();
        testCaseEntity.setId(WEBUI_VERIFICATION + System.currentTimeMillis());
        testCaseEntity.setVariables(variables);
        testCaseEntity.setProject(project);
        testCaseEntity.setScript(script);
        return testCaseEntity;
    }

    public void stopLauncher() {
        LauncherManager.getInstance().stopLauncher(this.launcher);
    }

    private class RecodingRunConfiguration
    extends ExistingRunConfiguration {
        public RecodingRunConfiguration(String projectDir, String sessionId, String remoteUrl, String driverName) {
            super(projectDir, sessionId, remoteUrl, driverName);
        }

        @Override
        public Map<String, Object> getProperties() {
            Map<String, Object> properties = super.getProperties();
            properties.put("recordCapturedObjectsCache", RecordingScriptGenerator.this.capturedTestObjectsCacheFile);
            return properties;
        }
    }
}

