/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.setting.EmailSettingStore;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.jasper.pdf.TestSuitePdfGenerator;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class MailUtil {
    private static final long EMAIL_WARNING_SIZE = 0xA00000L;
    private static final int EMAIL_TIMEOUT = 600000;
    public static final String EMAIL_SEPARATOR = ";";

    public static String[][] getMailSecurityProtocolTypeArrayValues() {
        MailSecurityProtocolType[] allSecurityProtocolTypes = MailSecurityProtocolType.values();
        String[][] arrayValues = new String[allSecurityProtocolTypes.length][2];
        int i = 0;
        while (i < allSecurityProtocolTypes.length) {
            arrayValues[i][0] = allSecurityProtocolTypes[i].toString();
            arrayValues[i][1] = allSecurityProtocolTypes[i].toString();
            ++i;
        }
        return arrayValues;
    }

    public static void sendTestMail(EmailConfig conf) throws Exception {
        HtmlEmail email = MailUtil.initEmail(conf);
        email.setHtmlMsg("<html>" + GroovyStringUtil.evaluate((String)conf.getHtmlMessage(), EmailVariableBinding.getTestEmailVariables()) + "</html>");
        email.send();
    }

    private static HtmlEmail initEmail(EmailConfig conf) throws EmailException {
        String bcc;
        HtmlEmail email = new HtmlEmail();
        email.setCharset("utf-8");
        email.setHostName(conf.getHost());
        email.setFrom(conf.getFrom(), "");
        email.setSubject(conf.getSubject());
        String cc = conf.getCc();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cc)) {
            email.addCc(org.apache.commons.lang3.StringUtils.split((String)cc, (String)EMAIL_SEPARATOR));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(bcc = conf.getBcc()))) {
            email.addBcc(org.apache.commons.lang3.StringUtils.split((String)bcc, (String)EMAIL_SEPARATOR));
        }
        email.addTo(conf.getTos());
        email.setSubject(conf.getSubject());
        email.setSocketConnectionTimeout(600000);
        email.setSocketTimeout(600000);
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(conf.getUsername(), conf.getPassword()));
        switch (conf.getSecurityProtocol()) {
            case SSL: {
                email.setSSLOnConnect(true);
                email.setSslSmtpPort(conf.getPort());
                break;
            }
            case TLS: {
                email.setStartTLSEnabled(true);
                break;
            }
        }
        return email;
    }

    public static void sendSummaryMail(EmailConfig conf, TestSuiteLogRecord suiteLogRecord, EmailVariableBinding variableBinding) throws Exception {
        if (conf == null || !conf.canSend()) {
            return;
        }
        HtmlEmail email = MailUtil.initEmail(conf);
        EmailAttachment attachment = null;
        File attachedFile = null;
        if (conf.isSendAttachmentEnable()) {
            attachment = MailUtil.attach(conf.getAttachmentOptions(), suiteLogRecord);
            attachedFile = new File(attachment.getURL().toURI());
            email.attach((DataSource)new FileDataSource(attachedFile), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        email.setHtmlMsg("<html>" + GroovyStringUtil.evaluate((String)conf.getHtmlMessage(), variableBinding.getVariables()) + "</html>");
        try {
            email.send();
        }
        finally {
            if (attachment != null) {
                try {
                    FileUtils.forceDelete((File)attachedFile);
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e);
                }
            }
        }
    }

    private static EmailAttachment attach(List<ReportFormatType> attachmentOptions, TestSuiteLogRecord suiteLogRecord) throws Exception {
        File zipFile;
        File logFolder = new File(suiteLogRecord.getLogFolder());
        File tmpReportDir = new File(System.getProperty("java.io.tmpdir"), String.valueOf(logFolder.getName()) + "_" + System.currentTimeMillis());
        if (tmpReportDir.exists()) {
            tmpReportDir.delete();
        }
        tmpReportDir.mkdir();
        File[] fileArray = logFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String fileName = f.getName();
            if (fileName.endsWith(".html") && attachmentOptions.contains(ReportFormatType.HTML) || fileName.endsWith(".csv") && attachmentOptions.contains(ReportFormatType.CSV) || (fileName.endsWith(".log") || fileName.endsWith(".meta") || fileName.endsWith("execution.properties")) && attachmentOptions.contains(ReportFormatType.LOG)) {
                FileUtils.copyFileToDirectory((File)f, (File)tmpReportDir);
            }
            ++n2;
        }
        if (attachmentOptions.contains(ReportFormatType.PDF)) {
            TestSuitePdfGenerator generator = new TestSuitePdfGenerator(suiteLogRecord);
            generator.exportToPDF(new File(tmpReportDir, String.valueOf(logFolder.getName()) + ".pdf").getAbsolutePath());
        }
        if ((zipFile = MailUtil.zip(tmpReportDir.getAbsolutePath(), tmpReportDir.getName())).length() > 0xA00000L) {
            LogUtil.printOutputLine((String)ExecutionMessageConstants.MSG_EMAIL_ATTACHMENT_EXCEEDS_SIZE);
        }
        EmailAttachment attachment = new EmailAttachment();
        attachment.setName(zipFile.getName());
        attachment.setURL(zipFile.toURI().toURL());
        attachment.setDisposition("attachment");
        return attachment;
    }

    private static File zip(String directory, String zipName) throws Exception {
        File folder = new File(directory);
        if (folder.isDirectory()) {
            File file = new File(String.valueOf(folder.getParent()) + File.separator + zipName + ".zip");
            if (file.exists()) {
                file.delete();
            }
            ZipFile zipFile = new ZipFile(String.valueOf(folder.getParent()) + File.separator + zipName + ".zip");
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            zipFile.addFolder(directory, parameters);
            return new File(String.valueOf(folder.getParent()) + File.separator + zipName + ".zip");
        }
        return null;
    }

    public static List<String> splitRecipientsString(String recipients) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)recipients)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)org.apache.commons.lang3.StringUtils.deleteWhitespace((String)recipients), (String)EMAIL_SEPARATOR));
    }

    public static Set<String> getDistinctRecipients(String ... recipientsList) {
        if (recipientsList == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> recipientCollector = new LinkedHashSet<String>();
        String[] stringArray = recipientsList;
        int n = recipientsList.length;
        int n2 = 0;
        while (n2 < n) {
            String recipients = stringArray[n2];
            recipientCollector.addAll(MailUtil.splitRecipientsString(recipients));
            ++n2;
        }
        return recipientCollector;
    }

    public static EmailConfig getDefaultEmailConfig(ProjectEntity project) {
        if (project == null) {
            return null;
        }
        EmailSettingStore store = new EmailSettingStore(project);
        try {
            boolean encryptionEnabled = store.isEncryptionEnabled();
            EmailConfig conf = new EmailConfig();
            conf.setHost(store.getHost(encryptionEnabled));
            conf.setPort(store.getPort(encryptionEnabled));
            conf.setFrom(store.getUsername(encryptionEnabled));
            conf.setSecurityProtocol(MailSecurityProtocolType.valueOf(store.getProtocol(encryptionEnabled)));
            conf.setUsername(store.getUsername(encryptionEnabled));
            conf.setPassword(store.getPassword(encryptionEnabled));
            conf.setSignature(store.getSignature());
            conf.setSendAttachment(store.isAddAttachment());
            conf.setCc(store.getEmailCc());
            conf.setBcc(store.getEmailBcc());
            conf.addRecipients(MailUtil.splitRecipientsString(store.getRecipients(encryptionEnabled)));
            conf.setSubject(store.getEmailSubject());
            conf.setHtmlMessage(store.getEmailHTMLTemplate());
            conf.setAttachmentOptions(store.getReportFormatOptions());
            conf.setSendEmailTestFailedOnly(store.isSendEmailTestFailedOnly());
            return conf;
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public static enum MailSecurityProtocolType {
        None,
        SSL,
        TLS;


        public static String[] getStringValues() {
            MailSecurityProtocolType[] allSecurityProtocolTypes = MailSecurityProtocolType.values();
            String[] stringValues = new String[allSecurityProtocolTypes.length];
            int index = 0;
            while (index < allSecurityProtocolTypes.length) {
                stringValues[index] = allSecurityProtocolTypes[index].toString();
                ++index;
            }
            return stringValues;
        }
    }
}

