/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import com.google.gson.Gson;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

public class ExecutionUtil {
    private static final String BIT = "bit";
    private static final String OS_ARCHITECTURE_PROPERTY = "sun.arch.data.model";
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String UNKNOW_HOST = "Unknow host";

    public static String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public static String getLocalHostName() {
        try {
            return String.valueOf(System.getProperty("user.name")) + " - " + InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return UNKNOW_HOST;
        }
    }

    public static String getLocalOS() {
        return String.valueOf(System.getProperty(OS_NAME_PROPERTY)) + " " + System.getProperty(OS_ARCHITECTURE_PROPERTY) + BIT;
    }

    private static ExecutionDefaultSettingStore getStore() {
        return ExecutionDefaultSettingStore.getStore();
    }

    public static IRunConfigurationContributor getDefaultExecutionConfiguration() {
        IRunConfigurationContributor[] allBuiltinRunConfigurationContributor;
        String selectedRunConfiguration = ExecutionUtil.getStore().getExecutionConfiguration();
        IRunConfigurationContributor[] iRunConfigurationContributorArray = allBuiltinRunConfigurationContributor = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        int n = allBuiltinRunConfigurationContributor.length;
        int n2 = 0;
        while (n2 < n) {
            IRunConfigurationContributor runConfigurationContributor = iRunConfigurationContributorArray[n2];
            if (runConfigurationContributor.getId().equals(selectedRunConfiguration)) {
                return runConfigurationContributor;
            }
            ++n2;
        }
        return null;
    }

    public static Boolean getAutoApplyNeighborXpaths() {
        return ExecutionUtil.getStore().isAutoApplyNeighborXpathsEnabled();
    }

    public static int getDefaultImplicitTimeout() {
        return ExecutionUtil.getStore().getElementTimeout();
    }

    public static boolean openReportAfterExecuting() {
        return ExecutionUtil.getStore().isPostExecOpenReport();
    }

    public static boolean isQuitDriversAfterExecutingTestCase() {
        return ExecutionUtil.getStore().isPostTestCaseExecQuitDriver();
    }

    public static boolean isQuitDriversAfterExecutingTestSuite() {
        return ExecutionUtil.getStore().isPostTestSuiteExecQuitDriver();
    }

    public static Map<String, Object> escapeGroovy(Map<String, Object> propertiesMap) {
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            entry.setValue(GroovyStringUtil.escapeGroovy((String)((String)entry.getValue())));
        }
        return propertiesMap;
    }

    public static Map<String, Object> getExecutionProperties(IExecutionSetting executionSetting, Map<String, IDriverConnector> driverConnectors, ExecutionProfileEntity executionProfile) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> executionProperties = new LinkedHashMap<String, Map<String, Object>>();
        Map<String, Object> generalProperties = executionSetting.getGeneralProperties();
        if (executionProfile != null) {
            generalProperties.put("executionProfile", executionProfile.getName());
        }
        executionProperties.put("general", generalProperties);
        executionProperties.put("drivers", ExecutionUtil.getDriverExecutionProperties(driverConnectors));
        propertyMap.put("execution", executionProperties);
        return propertyMap;
    }

    private static Map<String, Object> getDriverExecutionProperties(Map<String, IDriverConnector> driverConnectors) {
        LinkedHashMap<String, Object> driverProperties = new LinkedHashMap<String, Object>();
        HashMap<String, Map<String, Object>> driverSystemProperties = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> driverPerferencesProperties = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, IDriverConnector> kwDriverConnector : driverConnectors.entrySet()) {
            if (kwDriverConnector == null) continue;
            driverSystemProperties.put(kwDriverConnector.getKey(), kwDriverConnector.getValue().getSystemProperties());
            driverPerferencesProperties.put(kwDriverConnector.getKey(), kwDriverConnector.getValue().getUserConfigProperties());
        }
        driverProperties.put("system", driverSystemProperties);
        driverProperties.put("preferences", driverPerferencesProperties);
        return driverProperties;
    }

    public static File writeRunConfigToFile(IRunConfiguration runConfig) throws IOException {
        IExecutionSetting setting = runConfig.getExecutionSetting();
        File executionFile = new File(setting.getSettingFilePath());
        if (!executionFile.exists()) {
            executionFile.createNewFile();
        }
        Gson gsonObj = new Gson();
        String strJson = gsonObj.toJson(setting.getGeneralProperties());
        FileUtils.writeStringToFile((File)executionFile, (String)strJson);
        return executionFile;
    }

    public static Map<String, Object> readRunConfigSettingFromFile(String executionConfigFilePath) throws IOException {
        Map preferenceProps;
        RunConfiguration.setExecutionSettingFile((String)executionConfigFilePath);
        LinkedHashMap<String, Object> executionProps = new LinkedHashMap<String, Object>();
        Map generalProps = RunConfiguration.getExecutionGeneralProperties();
        if (generalProps != null && !generalProps.values().isEmpty()) {
            executionProps.putAll(RunConfiguration.getExecutionGeneralProperties());
        }
        if ((preferenceProps = RunConfiguration.getDriverPreferencesProperties()) != null && !preferenceProps.values().isEmpty()) {
            executionProps.putAll(RunConfiguration.getDriverPreferencesProperties());
        }
        return executionProps;
    }

    public static TestSuiteExecutedEntity getRerunExecutedEntity(TestSuiteExecutedEntity prevExecuted, ILauncherResult prevResult) throws IOException, Exception {
        TestSuiteEntity testSuite = null;
        try {
            testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(prevExecuted.getSourceId(), ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
        DefaultRerunSetting rerunSetting = new DefaultRerunSetting(prevExecuted.getPreviousRerunTimes() + 1, prevExecuted.getRemainingRerunTimes() - 1, prevExecuted.isRerunFailedTestCasesOnly());
        TestSuiteExecutedEntity newExecutedEntity = new TestSuiteExecutedEntity(testSuite, rerunSetting);
        newExecutedEntity.setReportLocation(prevExecuted.getReportLocationSetting());
        newExecutedEntity.setTestDataMap(prevExecuted.getTestDataMap());
        List<IExecutedEntity> prevTestCaseExecutedEntities = prevExecuted.getExecutedItems();
        ArrayList<IExecutedEntity> newTestCaseExecutedEntities = new ArrayList<IExecutedEntity>();
        if (prevExecuted.isRerunFailedTestCasesOnly()) {
            TestStatus.TestStatusValue[] prevResultValues = prevResult.getResultValues();
            int rsIdx = 0;
            for (IExecutedEntity prevExecutedItem : prevTestCaseExecutedEntities) {
                TestCaseExecutedEntity prevExecutedTC = (TestCaseExecutedEntity)prevExecutedItem;
                int i = rsIdx;
                while (i < rsIdx + prevExecutedTC.getLoopTimes()) {
                    if (prevResultValues[i] == TestStatus.TestStatusValue.FAILED || prevResultValues[i] == TestStatus.TestStatusValue.ERROR) {
                        newTestCaseExecutedEntities.add(prevExecutedTC);
                        break;
                    }
                    ++i;
                }
                rsIdx += prevExecutedTC.getLoopTimes();
            }
            newExecutedEntity.setTestCaseExecutedEntities(newTestCaseExecutedEntities);
        } else {
            newExecutedEntity.setTestCaseExecutedEntities(prevTestCaseExecutedEntities);
        }
        return newExecutedEntity;
    }

    public static void savePropertiesFile(Map<String, String> propertiesMap, String fileLocation) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream output = new FileOutputStream(fileLocation);){
            Properties prop = new Properties(){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
            for (Map.Entry<String, String> propertyEntry : propertiesMap.entrySet()) {
                prop.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            prop.store(output, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

