/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.util.internal.JarUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.FrameworkUtil;

public class EmailSettingStore
extends BundleSettingStore {
    private static final String KATALON_STUDIO_EMAIL_SIGNATURE = "Katalon Studio";
    private static final String RESOURCES_TEMPLATE_EMAIL_FOLDER = "resources/template/email";
    private static final String EMAIL_TEMPLATE_HTML = "default_template.html";
    private ScopedPreferenceStore mailPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.execution");

    public EmailSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(EmailSettingStore.class).getSymbolicName(), false);
    }

    private String getStringFromSettingOrPrefs(String mailConfigSettingName) throws IOException {
        return this.getString(mailConfigSettingName, this.mailPreferenceStore.getString(mailConfigSettingName));
    }

    private boolean getBooleanFromSettingOrPrefs(String mailConfigSettingName) throws IOException {
        return this.getBoolean(mailConfigSettingName, this.mailPreferenceStore.getBoolean(mailConfigSettingName));
    }

    public boolean isEncryptionEnabled() throws IOException {
        return this.getBoolean("mailConfig.encryptionEnabled", false);
    }

    public void enableAuthenticationEncryption(boolean enabled) throws IOException {
        this.setProperty("mailConfig.encryptionEnabled", enabled);
    }

    public String getHost(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.host", "", encryptionEnabled);
    }

    public void setHost(String hostName, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.host", hostName, encryptionEnabled);
    }

    public String getPort(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.port", "", encryptionEnabled);
    }

    public void setPort(String port, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.port", port, encryptionEnabled);
    }

    public boolean isAddAttachment() throws IOException {
        return this.getBooleanFromSettingOrPrefs("mailConfig.attachment");
    }

    public void setIsAddAttachment(boolean isAddAttachment) throws IOException {
        this.setProperty("mailConfig.attachment", isAddAttachment);
    }

    public String getUsername(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.username", "", encryptionEnabled);
    }

    public void setUsername(String username, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.username", username, encryptionEnabled);
    }

    public String getPassword(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.password", "", encryptionEnabled);
    }

    public void setPassword(String password, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.password", password, encryptionEnabled);
    }

    public String getProtocol(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.securityProtocol", MailUtil.MailSecurityProtocolType.None.toString(), encryptionEnabled);
    }

    public void setProtocol(String protocol, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.securityProtocol", protocol, encryptionEnabled);
    }

    public String getRecipients(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.reportRecipients", "", encryptionEnabled);
    }

    public void setRecipients(String recipients, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.reportRecipients", recipients, encryptionEnabled);
    }

    public String getSignature() throws IOException {
        return this.getStringFromSettingOrPrefs("mailConfig.signature");
    }

    public void setSignature(String signature) throws IOException {
        this.setProperty("mailConfig.signature", signature);
    }

    public String getEmailHTMLTemplate() throws IOException, URISyntaxException {
        return this.getString("mailConfig.htmlTemplate", this.getDefaultEmailHTMLTemplate());
    }

    public String getDefaultEmailHTMLTemplate() throws IOException, URISyntaxException {
        String emailHtmlTemplate = FileUtils.readFileToString((File)new File(this.getTemplateFolder(), EMAIL_TEMPLATE_HTML));
        return emailHtmlTemplate.replace(KATALON_STUDIO_EMAIL_SIGNATURE, StringUtils.defaultIfEmpty((CharSequence)this.getSignature(), (CharSequence)KATALON_STUDIO_EMAIL_SIGNATURE));
    }

    public File getTemplateFolder() throws IOException, URISyntaxException {
        File emailTempFolderRoot = ClassPathResolver.getConfigurationFolder();
        File emailTemplateFolder = new File(emailTempFolderRoot, RESOURCES_TEMPLATE_EMAIL_FOLDER);
        if (!emailTemplateFolder.exists()) {
            JarUtil.getFiles(((Object)((Object)this)).getClass(), (String)RESOURCES_TEMPLATE_EMAIL_FOLDER, (File)emailTemplateFolder);
        }
        return emailTemplateFolder;
    }

    public void setHTMLTemplate(String htmlTemplate) throws IOException {
        this.setProperty("mailConfig.htmlTemplate", htmlTemplate);
    }

    public String getEmailSubject() throws IOException {
        return this.getString("mailConfig.subject", ExecutionMessageConstants.PREF_DEFAULT_EMAIL_SUBJECT);
    }

    public void setEmailSubject(String subject) throws IOException {
        this.setProperty("mailConfig.subject", subject);
    }

    public String getEmailCc() throws IOException {
        return this.getStringFromSettingOrPrefs("mailConfig.cc");
    }

    public void setEmailCc(String cc) throws IOException {
        this.setProperty("mailConfig.cc", StringUtils.defaultString((String)cc));
    }

    public String getEmailBcc() throws IOException {
        return this.getStringFromSettingOrPrefs("mailConfig.bcc");
    }

    public void setEmailBcc(String bcc) throws IOException {
        this.setProperty("mailConfig.bcc", StringUtils.defaultString((String)bcc));
    }

    public List<ReportFormatType> getReportFormatOptions() throws IOException {
        String reportFormatOptAsJson = this.getString("mailConfig.reportFormat", "");
        if (StringUtils.isEmpty((CharSequence)reportFormatOptAsJson)) {
            return Arrays.asList(ReportFormatType.HTML, ReportFormatType.CSV);
        }
        return Arrays.asList((ReportFormatType[])JsonUtil.fromJson((String)reportFormatOptAsJson, ReportFormatType[].class));
    }

    public void setReportFormatOptions(List<ReportFormatType> reportFormatOptions) throws IOException {
        String reportFormatOptAsJson = JsonUtil.toJson((Object)reportFormatOptions.toArray(new ReportFormatType[0]));
        this.setProperty("mailConfig.reportFormat", reportFormatOptAsJson);
    }

    public boolean isSendEmailTestFailedOnly() throws IOException {
        return this.getBoolean("mailConfig.sendReportTestFailedOnly", false);
    }

    public void setSendEmailTestFailedOnly(boolean enabled) throws IOException {
        this.setProperty("mailConfig.sendReportTestFailedOnly", enabled);
    }
}

