/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.session;

import com.kms.katalon.core.appium.driver.ExistingAndroidDriver;
import com.kms.katalon.core.appium.driver.ExistingIosDriver;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.session.ExecutionSession;
import io.appium.java_client.AppiumDriver;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriverException;

public class MobileExecutionSession
extends ExecutionSession {
    public MobileExecutionSession(String title, String sessionId, String remoteUrl, String driverTypeName, String logFolderPath) {
        super(sessionId, remoteUrl, driverTypeName, logFolderPath);
        this.title = title;
    }

    @Override
    public void startWatcher() throws MalformedURLException {
        new Thread(new MobileExecutionSessionWatcher()).start();
    }

    protected class MobileExecutionSessionWatcher
    extends ExecutionSession.ExecutionSessionWatcher {
        private AppiumDriver<?> existingMobileDriver;

        protected MobileExecutionSessionWatcher() {
            super(MobileExecutionSession.this);
        }

        protected AppiumDriver<?> getExistingDriver() throws MalformedURLException {
            if (this.existingMobileDriver != null) {
                return this.existingMobileDriver;
            }
            if (MobileDriverType.ANDROID_DRIVER.toString().equals(MobileExecutionSession.this.driverTypeName)) {
                this.existingMobileDriver = new ExistingAndroidDriver(new URL(MobileExecutionSession.this.remoteUrl), MobileExecutionSession.this.sessionId);
            } else if (MobileDriverType.IOS_DRIVER.toString().equals(MobileExecutionSession.this.driverTypeName)) {
                this.existingMobileDriver = new ExistingIosDriver(new URL(MobileExecutionSession.this.remoteUrl), MobileExecutionSession.this.sessionId);
            }
            return this.existingMobileDriver;
        }

        @Override
        protected void checkStatusAndUpdateTitle() throws MalformedURLException, WebDriverException {
            this.getExistingDriver().findElementsById("id");
        }
    }
}

