/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.session;

import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionServiceRunnable;
import com.kms.katalon.execution.session.RemoteMobileExecutionSession;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class ExecutionSessionSocketServer
implements Runnable {
    private static final String LOCAL_HOST_MAC = "localhost";
    private static ExecutionSessionSocketServer instance;
    private ServerSocket serverSocket = new ServerSocket(0);
    private List<ExecutionSession> executionSessions;
    private int localPort = this.serverSocket.getLocalPort();
    private String hostAddress = this.serverSocket.getInetAddress().getHostAddress();

    public static ExecutionSessionSocketServer getInstance() {
        if (instance == null) {
            try {
                instance = new ExecutionSessionSocketServer();
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
            }
        }
        return instance;
    }

    private ExecutionSessionSocketServer() throws IOException {
        if (Platform.getOS().equals("macosx")) {
            this.hostAddress = LOCAL_HOST_MAC;
        }
        this.executionSessions = new ArrayList<ExecutionSession>();
    }

    public int getServerPort() {
        return this.localPort;
    }

    public String getServerHost() {
        return this.hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionSession(ExecutionSession executionSession) {
        List<ExecutionSession> list = this.executionSessions;
        synchronized (list) {
            this.executionSessions.add(executionSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionSession(ExecutionSession executionSession) {
        List<ExecutionSession> list = this.executionSessions;
        synchronized (list) {
            this.executionSessions.remove(executionSession);
        }
    }

    public List<ExecutionSession> getAllAvailableExecutionSessionByDriverTypeName(String driverTypeName) {
        ArrayList<ExecutionSession> executionSessions = new ArrayList<ExecutionSession>();
        for (ExecutionSession executionSession : this.getAllExecutionSession()) {
            if (!driverTypeName.equals(executionSession.getDriverTypeName()) || !executionSession.isAvailable() || executionSession instanceof RemoteMobileExecutionSession) continue;
            executionSessions.add(executionSession);
        }
        return executionSessions;
    }

    public ExecutionSession getExecutionSessionBySessionAndRemoteURL(String sessionId, String remoteServerUrl) {
        for (ExecutionSession executionSession : this.getAllExecutionSession()) {
            if (!executionSession.getSessionId().equals(sessionId) || !executionSession.getRemoteUrl().equals(remoteServerUrl)) continue;
            return executionSession;
        }
        return null;
    }

    public ExecutionSession getExecutionSessionByLogFolderPath(String logFolderPath) {
        for (ExecutionSession executionSession : this.getAllExecutionSession()) {
            if (!logFolderPath.equals(executionSession.getLogFolderPath())) continue;
            return executionSession;
        }
        return null;
    }

    public List<ExecutionSession> getAllAvailableExecutionSessions() {
        ArrayList<ExecutionSession> executionSessions = new ArrayList<ExecutionSession>();
        for (ExecutionSession executionSession : this.getAllExecutionSession()) {
            if (!executionSession.isAvailable()) continue;
            executionSessions.add(executionSession);
        }
        return executionSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutionSession> getAllExecutionSession() {
        List<ExecutionSession> list = this.executionSessions;
        synchronized (list) {
            return new ArrayList<ExecutionSession>(this.executionSessions);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket clientSocket = this.serverSocket.accept();
                    ExecutionSessionServiceRunnable clientThread = new ExecutionSessionServiceRunnable(clientSocket, this);
                    new Thread(clientThread).start();
                }
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
                continue;
            }
            break;
        }
    }
}

