/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.session;

import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.session.MobileExecutionSession;
import com.kms.katalon.execution.session.RemoteMobileExecutionSession;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;

public class ExecutionSessionServiceRunnable
implements Runnable {
    private Socket clientSocket;
    private ExecutionSessionSocketServer sessionServer;

    public ExecutionSessionServiceRunnable(Socket clientSocket, ExecutionSessionSocketServer sessionServer) throws IOException {
        this.clientSocket = clientSocket;
        this.sessionServer = sessionServer;
    }

    @Override
    public void run() {
        try {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader input = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));){
                    String sessionId = input.readLine();
                    String remoteUrl = input.readLine();
                    String driverTypeName = input.readLine();
                    String logFolderPath = input.readLine();
                    ExecutionSession executionSession = null;
                    if (MobileDriverType.IOS_DRIVER.toString().equals(driverTypeName) || MobileDriverType.ANDROID_DRIVER.toString().equals(driverTypeName)) {
                        String remoteType = input.readLine();
                        String title = input.readLine();
                        executionSession = StringUtils.isEmpty((CharSequence)remoteType) ? new MobileExecutionSession(title, sessionId, remoteUrl, driverTypeName, logFolderPath) : new RemoteMobileExecutionSession(title, sessionId, remoteUrl, driverTypeName, logFolderPath, remoteType);
                    } else {
                        executionSession = new ExecutionSession(sessionId, remoteUrl, driverTypeName, logFolderPath);
                    }
                    this.sessionServer.addExecutionSession(executionSession);
                    executionSession.startWatcher();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                LogUtil.printAndLogError((Throwable)e);
                if (this.clientSocket == null) {
                    return;
                }
                try {
                    this.clientSocket.close();
                }
                catch (IOException e2) {
                    LogUtil.logError((Throwable)e2);
                }
            }
        }
        finally {
            if (this.clientSocket == null) {
                return;
            }
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
            }
        }
    }
}

