/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.session;

import com.kms.katalon.core.webui.driver.ExistingRemoteWebDriver;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ExecutionSession {
    protected String sessionId;
    protected String remoteUrl;
    protected String driverTypeName;
    protected String logFolderPath;
    protected String title;
    protected boolean isAlive;
    protected boolean isAvailable;

    public ExecutionSession(String sessionId, String remoteUrl, String driverTypeName, String logFolderPath) {
        this.sessionId = sessionId;
        this.remoteUrl = remoteUrl;
        this.driverTypeName = driverTypeName;
        this.logFolderPath = logFolderPath;
        this.isAlive = true;
        this.isAvailable = false;
    }

    public void startWatcher() throws MalformedURLException {
        new Thread(new ExecutionSessionWatcher()).start();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getDriverTypeName() {
        return this.driverTypeName;
    }

    public String getLogFolderPath() {
        return this.logFolderPath;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.driverTypeName;
        }
        return this.title;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    private ExecutionSession geExecutionSession() {
        return this;
    }

    public void stop() {
        this.isAlive = false;
    }

    public void pause() {
        this.isAvailable = false;
    }

    public void resume() {
        this.isAvailable = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExecutionSession)) {
            return false;
        }
        ExecutionSession other = (ExecutionSession)object;
        return new EqualsBuilder().append((Object)this.sessionId, (Object)other.sessionId).append((Object)this.remoteUrl, (Object)other.remoteUrl).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.sessionId).append((Object)this.remoteUrl).toHashCode();
    }

    protected class ExecutionSessionWatcher
    implements Runnable {
        private static final int DEFAULT_LOOP_INTERVAL = 1000;
        protected RemoteWebDriver existingDriver;

        protected ExecutionSessionWatcher() {
        }

        protected RemoteWebDriver getExistingDriver() throws MalformedURLException, ConnectException {
            if (this.existingDriver == null) {
                this.existingDriver = new ExistingRemoteWebDriver(new URL(ExecutionSession.this.remoteUrl), ExecutionSession.this.sessionId);
            }
            return this.existingDriver;
        }

        @Override
        public void run() {
            while (ExecutionSession.this.isAlive) {
                try {
                    Thread.sleep(1000L);
                    if (!ExecutionSession.this.isAvailable) continue;
                    this.checkStatusAndUpdateTitle();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    ExecutionSession.this.isAlive = false;
                }
            }
            ExecutionSessionSocketServer.getInstance().removeExecutionSession(ExecutionSession.this.geExecutionSession());
        }

        protected void checkStatusAndUpdateTitle() throws MalformedURLException, WebDriverException, ConnectException {
            ExecutionSession.this.title = this.getExistingDriver().getTitle();
        }
    }
}

