/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.preferences;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.network.ProxyServerType;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ProxyPreferences {
    public static boolean isProxyPreferencesSet() {
        ScopedPreferenceStore store = ProxyPreferences.getPreferenceStore();
        return store.getBoolean("proxy.preferences.set");
    }

    public static ProxyInformation getProxyInformation() {
        ScopedPreferenceStore store = ProxyPreferences.getPreferenceStore();
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.option"), (CharSequence)ProxyOption.NO_PROXY.name()));
        proxyInfo.setProxyServerType((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.server.type"), (CharSequence)ProxyServerType.HTTP.name()));
        proxyInfo.setProxyServerAddress(store.getString("proxy.server.address"));
        proxyInfo.setProxyServerPort(store.getInt("proxy.server.port"));
        proxyInfo.setUsername(store.getString("proxy.username"));
        proxyInfo.setPassword(store.getString("proxy.password"));
        proxyInfo.setDisableMobBrowserProxy(store.getBoolean("proxy.preferences.disableMobRowserProxy"));
        return proxyInfo;
    }

    public static void saveProxyInformation(ProxyInformation proxyInfo) throws IOException {
        ScopedPreferenceStore store = ProxyPreferences.getPreferenceStore();
        store.setValue("proxy.option", proxyInfo.getProxyOption());
        store.setValue("proxy.server.type", proxyInfo.getProxyServerType());
        store.setValue("proxy.server.address", proxyInfo.getProxyServerAddress());
        store.setValue("proxy.server.port", proxyInfo.getProxyServerPort());
        store.setValue("proxy.username", proxyInfo.getUsername());
        store.setValue("proxy.password", proxyInfo.getPassword());
        store.setValue("proxy.preferences.set", true);
        store.setValue("proxy.preferences.disableMobRowserProxy", proxyInfo.getDisableMobBroserProxy());
        store.save();
    }

    private static ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.execution");
    }
}

