/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.platform;

import com.katalon.platform.api.execution.TestCaseExecutionContext;
import com.katalon.platform.api.execution.TestSuiteExecutionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestSuiteExecutionContextImpl
implements TestSuiteExecutionContext {
    private final Builder builder;

    private TestSuiteExecutionContextImpl(Builder builder) {
        this.builder = builder;
    }

    public String getId() {
        return this.builder.id;
    }

    public String getSourceId() {
        return this.builder.sourceId;
    }

    public long getStartTime() {
        return this.builder.startTime;
    }

    public long getEndTime() {
        return this.builder.endTime;
    }

    public String getReportId() {
        return this.builder.reportId;
    }

    public List<TestCaseExecutionContext> getTestCaseContexts() {
        return Collections.unmodifiableList(this.builder.testCaseContexts);
    }

    public String toString() {
        return this.builder.toString();
    }

    /* synthetic */ TestSuiteExecutionContextImpl(Builder builder, TestSuiteExecutionContextImpl testSuiteExecutionContextImpl) {
        this(builder);
    }

    public static class Builder {
        private String id;
        private String sourceId;
        private long startTime;
        private long endTime;
        private String reportId;
        private List<TestCaseExecutionContext> testCaseContexts = new ArrayList<TestCaseExecutionContext>();

        private Builder(String id, String sourceId) {
            this.id = id;
            this.sourceId = sourceId;
        }

        public static Builder create(String id, String sourceId) {
            return new Builder(id, sourceId);
        }

        public Builder withStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withReportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public Builder withTestCaseContext(List<TestCaseExecutionContext> testCaseContexts) {
            this.testCaseContexts = testCaseContexts;
            return this;
        }

        public TestSuiteExecutionContextImpl build() {
            return new TestSuiteExecutionContextImpl(this, null);
        }
    }
}

