/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.result;

import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LauncherResult
implements ILauncherResult {
    public static final int RETURN_CODE_PASSED = 0;
    public static final int RETURN_CODE_FAILED = 1;
    public static final int RETURN_CODE_ERROR = 2;
    public static final int RETURN_CODE_FAILED_AND_ERROR = 3;
    public static final int RETURN_CODE_INVALID_ARGUMENT = 4;
    private int totalTestCases;
    private int numPasses;
    private int numFailures;
    private int numErrors;
    private int numIncomplete;
    private List<TestStatus> statuses;

    public LauncherResult(int totalTestCases) {
        this.setTotalTestCases(totalTestCases);
        this.setNumPasses(0);
        this.setNumFailures(0);
        this.setNumErrors(0);
        this.setNumIncomplete(0);
        this.statuses = new ArrayList<TestStatus>(totalTestCases);
        int i = 0;
        while (i < totalTestCases) {
            TestStatus testStatus = new TestStatus();
            testStatus.setStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
            this.statuses.add(testStatus);
            ++i;
        }
    }

    @Override
    public int getTotalTestCases() {
        return this.totalTestCases;
    }

    private void setTotalTestCases(int totalTestCases) {
        this.totalTestCases = totalTestCases;
    }

    @Override
    public int getNumPasses() {
        return this.numPasses;
    }

    public void setNumPasses(int numPasses) {
        this.numPasses = numPasses;
    }

    @Override
    public int getNumFailures() {
        return this.numFailures;
    }

    public void setNumFailures(int numFailures) {
        this.numFailures = numFailures;
    }

    @Override
    public int getNumErrors() {
        return this.numErrors;
    }

    public void setNumErrors(int numErrors) {
        this.numErrors = numErrors;
    }

    public void setNumIncomplete(int numIncomplete) {
        this.numIncomplete = numIncomplete;
    }

    @Override
    public int getExecutedTestCases() {
        return this.getNumPasses() + this.getNumFailures() + this.getNumErrors();
    }

    public void increasePasses() {
        this.statuses.get(this.getExecutedTestCases()).setStatusValue(TestStatus.TestStatusValue.PASSED);
        ++this.numPasses;
    }

    public void increaseFailures() {
        this.statuses.get(this.getExecutedTestCases()).setStatusValue(TestStatus.TestStatusValue.FAILED);
        ++this.numFailures;
    }

    public void increaseErrors() {
        this.statuses.get(this.getExecutedTestCases()).setStatusValue(TestStatus.TestStatusValue.ERROR);
        ++this.numErrors;
    }

    public boolean isNotPassed() {
        return this.numErrors + this.numFailures > 0;
    }

    public boolean hasErrors() {
        return this.numErrors > 0;
    }

    public boolean hasFailures() {
        return this.numFailures > 0;
    }

    @Override
    public int getReturnCode() {
        if (!this.isNotPassed()) {
            return 0;
        }
        if (this.hasErrors() && this.hasFailures()) {
            return 3;
        }
        if (this.hasErrors()) {
            return 2;
        }
        return 1;
    }

    public String toString() {
        return MessageFormat.format(StringConstants.MODEL_TOTAL_PASSED_FAILED_ERRORS, Integer.toString(this.getTotalTestCases()), Integer.toString(this.getNumPasses()), Integer.toString(this.getNumFailures()), Integer.toString(this.getNumErrors()));
    }

    @Override
    public int getNumIncomplete() {
        return this.numIncomplete;
    }

    @Override
    public TestStatus.TestStatusValue[] getResultValues() {
        return this.statuses.stream().map(s -> s.getStatusValue()).collect(Collectors.toList()).toArray(new TestStatus.TestStatusValue[0]);
    }

    @Override
    public TestStatus[] getStatuses() {
        return this.statuses.toArray(new TestStatus[0]);
    }
}

