/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.process;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.launcher.ILaunchProcessor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class LaunchProcessor
implements ILaunchProcessor {
    private static final String[] CANDIDATES_JAVA_FILES = new String[]{"java", "java.exe"};
    private static final String[] CANDIDATE_JAVA_LOCATIONS = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};
    private static final String STARTER_CLASS = "org.codehaus.groovy.tools.GroovyStarter";
    private static final String MAIN_CLASS = "groovy.ui.GroovyMain";
    private static final String GROOVY_BUNDLE_NAME = "org.codehaus.groovy";
    private String[] fClasspaths;
    private Map<String, String> environmentVariables;

    public LaunchProcessor(String[] classPaths) {
        this(classPaths, new HashMap<String, String>());
    }

    public LaunchProcessor(String[] classPaths, Map<String, String> environmentVariables) {
        this.fClasspaths = classPaths;
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Process execute(File scripFile) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(this.getInstalledJRE(), "-cp", String.valueOf(File.pathSeparator) + FilenameUtils.separatorsToSystem((String)this.getGroovyLibs()) + File.pathSeparator + this.getClasspaths(), STARTER_CLASS, "--main", MAIN_CLASS, FilenameUtils.separatorsToSystem((String)scripFile.getAbsolutePath()));
        pb.environment().putAll(this.getEnviromentVariables());
        pb.directory(new File(ProjectController.getInstance().getCurrentProject().getFolderLocation()));
        return pb.start();
    }

    private String getInstalledJRE() {
        File vmInstallLocation = JavaRuntime.getDefaultVMInstall().getInstallLocation();
        int i = 0;
        while (i < CANDIDATES_JAVA_FILES.length) {
            int j = 0;
            while (j < CANDIDATE_JAVA_LOCATIONS.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(CANDIDATE_JAVA_LOCATIONS[j]) + CANDIDATES_JAVA_FILES[i]);
                if (javaFile.isFile()) {
                    return javaFile.getAbsolutePath();
                }
                ++j;
            }
            ++i;
        }
        return "java";
    }

    @Override
    public String[] getClasspath() {
        return this.fClasspaths;
    }

    @Override
    public Map<String, String> getEnviromentVariables() throws IOException {
        return this.environmentVariables;
    }

    private String getGroovyHome() throws IOException {
        return FileLocator.getBundleFile((Bundle)Platform.getBundle((String)GROOVY_BUNDLE_NAME)).getAbsolutePath();
    }

    private String getGroovyLibs() throws IOException {
        return String.valueOf(this.getGroovyHome()) + "/lib/*";
    }

    private String getClasspaths() {
        StringBuilder cpBuilder = new StringBuilder();
        String[] stringArray = this.getClasspath();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cp = stringArray[n2];
            cpBuilder.append(FilenameUtils.separatorsToSystem((String)cp)).append(File.pathSeparator);
            ++n2;
        }
        return cpBuilder.toString();
    }
}

