/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.process;

import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.logging.IOutputStream;
import com.kms.katalon.execution.logging.LaunchOutputStreamHandler;

public class ConsoleProcess
implements ILaunchProcess {
    private Process fSystemProcess;
    protected LaunchOutputStreamHandler fOutputStreamHandler;
    protected LaunchOutputStreamHandler fErrorStreamHandler;

    public ConsoleProcess(Process systemProcess) {
        this.fSystemProcess = systemProcess;
        this.buildStreamHandler(systemProcess);
    }

    protected void buildStreamHandler(Process systemProcess) {
        this.fOutputStreamHandler = LaunchOutputStreamHandler.outputHandlerFrom(systemProcess.getInputStream());
        this.fOutputStreamHandler.start();
        this.fErrorStreamHandler = LaunchOutputStreamHandler.errorHandlerFrom(systemProcess.getErrorStream());
        this.fErrorStreamHandler.start();
    }

    @Override
    public int getExitValue() {
        return this.fSystemProcess.exitValue();
    }

    @Override
    public void terminate() {
        this.fSystemProcess.destroy();
    }

    @Override
    public boolean isTerminated() {
        try {
            this.getExitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    @Override
    public IOutputStream getOutputStreamHandler() {
        return this.fOutputStreamHandler;
    }

    @Override
    public IOutputStream getErrorStreamHandler() {
        return this.fErrorStreamHandler;
    }
}

