/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.launcher.BasicLauncher;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.SubLauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.List;

public class TestSuiteCollectionLauncher
extends BasicLauncher
implements LauncherListener {
    public static final int MAX_NUMBER_INSTANCES_IN_PARALLEL_MODE = 8;
    protected List<ReportableLauncher> subLaunchers;
    private LauncherResult result;
    protected TestSuiteCollectionLauncherManager subLauncherManager = new TestSuiteCollectionLauncherManager();
    private LauncherManager parentManager;
    private Thread watchDog;
    private TestSuiteCollectionExecutedEntity executedEntity;
    private TestSuiteCollectionEntity.ExecutionMode executionMode;
    private ReportCollectionEntity reportCollection;

    public TestSuiteCollectionLauncher(TestSuiteCollectionExecutedEntity executedEntity, LauncherManager parentManager, List<ReportableLauncher> subLaunchers, TestSuiteCollectionEntity.ExecutionMode executionMode, ReportCollectionEntity reportCollection) {
        this.subLaunchers = subLaunchers;
        for (ReportableLauncher subLauncher : subLaunchers) {
            subLauncher.setExecutionUUID(super.getExecutionUUID());
        }
        this.result = new LauncherResult(executedEntity.getTotalTestCases());
        this.parentManager = parentManager;
        this.executedEntity = executedEntity;
        this.executionMode = executionMode;
        this.reportCollection = reportCollection;
        this.addListenerForChildren(subLaunchers);
    }

    private void addListenerForChildren(List<? extends ReportableLauncher> subLaunchers) {
        for (ReportableLauncher reportableLauncher : subLaunchers) {
            reportableLauncher.addListener(this);
            reportableLauncher.setParentLauncher(this);
        }
    }

    @Override
    public void start() throws IOException {
        this.setStatus(LauncherStatus.RUNNING);
        this.preStarting();
        this.scheduleSubLaunchers();
        this.startWatchDog();
    }

    private void scheduleSubLaunchers() {
        for (ReportableLauncher launcher : this.subLaunchers) {
            this.subLauncherManager.addLauncher(launcher);
            launcher.setManager(this.subLauncherManager);
        }
    }

    protected void preStarting() {
    }

    private void startWatchDog() {
        this.watchDog = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TestSuiteCollectionLauncher.this.subLauncherManager.isAnyLauncherRunning()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                TestSuiteCollectionLauncher.this.setStatus(LauncherStatus.DONE);
                TestSuiteCollectionLauncher.this.postExecution();
            }
        });
        this.watchDog.start();
    }

    protected void postExecution() {
        this.schedule();
    }

    protected void schedule() {
        try {
            this.parentManager.stopRunningAndSchedule(this);
        }
        catch (InterruptedException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    @Override
    public void setStatus(LauncherStatus status) {
        super.setStatus(status);
        if (LauncherStatus.DONE == status || LauncherStatus.TERMINATED == status) {
            ExecutionEntityResult executionResult = new ExecutionEntityResult();
            executionResult.setEnd(true);
            this.notifyProccess((Object)status, this.executedEntity, executionResult);
        }
    }

    @Override
    public void stop() {
        this.setStatus(LauncherStatus.TERMINATED);
        if (this.watchDog != null && this.watchDog.isAlive()) {
            this.watchDog.interrupt();
        }
        this.subLauncherManager.stopAllLauncher();
        this.postExecution();
    }

    @Override
    public void clean() {
        for (ReportableLauncher launcher : this.subLaunchers) {
            launcher.clean();
        }
    }

    @Override
    public String getId() {
        return this.executedEntity.getId();
    }

    @Override
    public String getName() {
        return String.valueOf(this.executedEntity.getSourceId()) + " - " + this.executedEntity.getId();
    }

    @Override
    public ILauncherResult getResult() {
        return this.result;
    }

    private void addNewLauncher(SubLauncher subLauncher) {
        ReportableLauncher subReportableLauncher = (ReportableLauncher)((Object)subLauncher);
        if (this.subLaunchers.contains(subReportableLauncher)) {
            return;
        }
        this.subLaunchers.add(subReportableLauncher);
        subReportableLauncher.addListener(this);
        subReportableLauncher.setParentLauncher(this);
        ILauncherResult subLauncherResult = subLauncher.getResult();
        LauncherResult newResult = new LauncherResult(this.result.getTotalTestCases() + subLauncherResult.getTotalTestCases());
        newResult.setNumPasses(this.result.getNumPasses() + subLauncherResult.getNumPasses());
        newResult.setNumFailures(this.result.getNumFailures() + subLauncherResult.getNumFailures());
        newResult.setNumIncomplete(this.result.getNumIncomplete() + subLauncherResult.getNumIncomplete());
        newResult.setNumErrors(this.result.getNumErrors() + subLauncherResult.getNumErrors());
        this.result = newResult;
        this.reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)subReportableLauncher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)subLauncher.getRunConfigurationDescription()));
        try {
            ReportController.getInstance().updateReportCollection(this.reportCollection);
        }
        catch (DALException e) {
            LogUtil.logError((Throwable)e);
        }
        this.onNewLauncherAdded();
    }

    protected void onNewLauncherAdded() {
    }

    @Override
    public void handleLauncherEvent(LauncherEvent event, LauncherNotifiedObject object) {
        if (event == LauncherEvent.UPDATE_RESULT) {
            TestStatus.TestStatusValue statusValue = (TestStatus.TestStatusValue)object.getObject();
            switch (statusValue) {
                case ERROR: {
                    this.result.increaseErrors();
                    break;
                }
                case FAILED: {
                    this.result.increaseFailures();
                    break;
                }
                case PASSED: {
                    this.result.increasePasses();
                    break;
                }
            }
            this.onUpdateResult(statusValue);
        }
    }

    public class TestSuiteCollectionLauncherManager
    extends LauncherManager {
        @Override
        protected boolean isLauncherReadyToRun(ILauncher launcher) {
            if (TestSuiteCollectionLauncher.this.executionMode == TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
                return this.getRunningLaunchers().size() < TestSuiteCollectionLauncher.this.executedEntity.getEntity().getMaxConcurrentInstances();
            }
            return this.getRunningLaunchers().isEmpty();
        }

        @Override
        public String getChildrenLauncherStatus(int consoleWidth) {
            return super.getChildrenLauncherStatus(consoleWidth);
        }

        @Override
        protected void schedule() {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            super.schedule();
        }

        @Override
        public void addLauncher(ILauncher subLauncher) {
            TestSuiteCollectionLauncher.this.addNewLauncher((SubLauncher)subLauncher);
            super.addLauncher(subLauncher);
        }
    }
}

